package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 重大项目综合得分统计
 * @author 陈实
 * @Package com.artfess.reform.fill.vo
 * @date 2023/3/18 16:22
 * @Description:
 */
@Data
public class ProjectSynScoreVo {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "品牌显示度得分")
    private BigDecimal brandScore;

    @ApiModelProperty(value = "举措推进力得分")
    private BigDecimal measureScore;

    @ApiModelProperty(value = "量化目标落实力得分")
    private BigDecimal targetScore;

    @ApiModelProperty(value = "改革风险扣分")
    private BigDecimal riskScore;

    @ApiModelProperty(value = "综合得分(扣分前)")
    private BigDecimal synScore;

    @ApiModelProperty(value = "综合得分(扣分后)")
    private BigDecimal synAfterScore;


}
