package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 重大项目的扣分统计Vo
 * @author 陈实
 * @Package com.artfess.reform.fill.vo
 * @date 2023/3/18 16:22
 * @Description:
 */
@Data
public class ProjectRiskScoreVo {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "发生重大负面舆情次数")
    private Integer pubNum;

    @ApiModelProperty(value = "发生重大负面舆情扣分")
    private BigDecimal pubScore;

    @ApiModelProperty(value = "较大群体事件次数")
    private Integer largerNum;

    @ApiModelProperty(value = "较大群体事件扣分")
    private BigDecimal largerScore;

    @ApiModelProperty(value = "重大群体事件次数")
    private Integer greatNum;

    @ApiModelProperty(value = "重大群体事件扣分")
    private BigDecimal greatScore;

    @ApiModelProperty(value = "特别重大群体事件次数")
    private Integer specialGreatNum;

    @ApiModelProperty(value = "特别重大群体事件扣分")
    private BigDecimal specialGreatScore;

    @ApiModelProperty(value = "总次数")
    private Integer totleNum;

    @ApiModelProperty(value = "总扣分")
    private BigDecimal score;


}
