package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 区县改革试点Vo
 *
 * @author 黎沐华
 * @date 2023/3/31 22:18
 */
@Data
@ApiModel("区县改革试点Vo")
public class CountyPilotReformVo {

    @ApiModelProperty("图表数据")
    private Map<Integer, List<CountyChartVo>> chart;

    @ApiModelProperty("成果数据")
    private List<CountyPilotReformVo> achievement;

    @ApiModelProperty("成效类型")
    private Integer achievementType;

    @ApiModelProperty("成果总数")
    private Integer totalAchievement;

    @ApiModelProperty("成果相较上季增长数")
    private Integer gapQAchievement;

    public CountyPilotReformVo() {
    }

    public  CountyPilotReformVo(Integer achievement, Integer totalAchievement) {
        this.achievementType = achievement;
        this.totalAchievement = totalAchievement;
    }
}
