package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 全市推广排行榜Vo
 *
 * @author 黎沐华
 * @since  2023/4/1 12:07
 */
@Data
@ApiModel("全市推广排行榜Vo")
public class CountyCityPromotionVo {

    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("区县ID")
    private String countyId;

    @ApiModelProperty("区县Code")
    private String countyCode;

    @ApiModelProperty("经验条数")
    private Integer experienceCount=0;

    @ApiModelProperty("排名")
    private Integer rank;

    @ApiModelProperty(value = "排名是否提升", notes = "相较上一季度排名是否提升")
    private Boolean promote = null;

    public CountyCityPromotionVo(String county, String countyId, String countyCode) {
        this.county = county;
        this.countyId = countyId;
        this.countyCode = countyCode;
    }

    public CountyCityPromotionVo() {
    }
}
