package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 区县大屏echarts数据VO
 *
 * @author 黎沐华
 * @since 2023/4/1 9:14
 */
@Data
@ApiModel("区县大屏echarts数据VO")
public class CountyChartVo {

    @ApiModelProperty("X轴")
    private Integer x;

    @ApiModelProperty("图例, 使用字典")
    private Integer legend;

    @ApiModelProperty("Y轴")
    private Integer y;

    @ApiModelProperty("常规计数，用于非折线图")
    private Integer commonCount;

    @ApiModelProperty("常规描述，这个字段使用字典数据时，需要手动翻译字典")
    private String description;

    @ApiModelProperty("子级数据")
    private Map<String,List<CountyChartVo>> subData;

    public CountyChartVo() {
    }

    public CountyChartVo(Integer legend, Integer commonCount) {
        this.legend = legend;
        this.commonCount = commonCount;
    }

    public CountyChartVo(String description, Integer commonCount) {
        this.commonCount = commonCount;
        this.description = description;
    }

}
