package com.artfess.reform.statistics.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.poi.ss.formula.functions.Trend;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author 黎沐华
 * @since 2023/3/30 10:40
 */
@Data
@ApiModel("区县大屏核心指标数据")
public class CoreIndexVo {

    @ApiModelProperty(value = "评比日期")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    private Integer fillYear;

    @ApiModelProperty(value = "评比区县NAME（关联组织机构表NAME）")
    private String unitName;

    @ApiModelProperty(value = "评比区县CODE（关联组织机构表编码）")
    private String unitCode;

    @ApiModelProperty(value = "评比区县GRADE（关联组织机构表级别）")
    private Integer unitGrade;

    @ApiModelProperty(value = "平均得分")
    private BigDecimal avgScore;

    @ApiModelProperty(value = "国家级试点项目数量")
    private Integer nationalProjectNum;

    @ApiModelProperty(value = "国家级试点项目数量排名")
    private Integer nationalProjectSn;

    @ApiModelProperty(value = "国家级试点项目数量档次（A，B，C，D）")
    private String nationalProjectGrade;

    @ApiModelProperty(value = "国家级试点项目数量排名趋势")
    private Integer nationalProjectTrend;

    @ApiModelProperty(value = "国家级试点项目本年度新增数量")
    private Integer nationalAddNum;

    @ApiModelProperty(value = "本年度新增国家级试点排名")
    private Integer nationalAddSn;

    @ApiModelProperty(value = "本年度新增国家级试点档次（A，B，C，D）")
    private String nationalAddGrade;

    @ApiModelProperty(value = "本年度新增国家级试点排名趋势")
    private Integer nationalAddTrend;

    @ApiModelProperty(value = "国家级试点项目按时验收数量")
    private Integer nationalPassNum;

    @ApiModelProperty(value = "国家级试点项目按时验收率")
    private BigDecimal nationalPassRate;

    @ApiModelProperty(value = "国家级试点项目按时验收率排名")
    private Integer nationalPassSn;

    @ApiModelProperty(value = "国家级试点项目按时验收率档次（A，B，C，D）")
    private String nationalPassGrade;

    @ApiModelProperty(value = "国家级试点项目按时验收率排名趋势")
    private Integer nationalPassTrend;

    @ApiModelProperty(value = "落实改革力得分")
    private BigDecimal workableScore;

    @ApiModelProperty(value = "落实改革力得分区域排名")
    private Integer workableRegionSn;

    @ApiModelProperty(value = "落实改革力得分全市排名")
    private Integer workableAllSn;

    @ApiModelProperty(value = "承接国家级试点项目推进中数量")
    private Integer nationalPushNum;

    @ApiModelProperty(value = "承接的国家级试点本季度增加数量")
    private Integer nationalProjectAddNum ;

    @ApiModelProperty(value = "承接市级试点项目推进中数量")
    private Integer cityPushNum;

    @ApiModelProperty(value = "承接市级试点项目本季度新增数量")
    private Integer cityProjectAddNum;

    @ApiModelProperty(value = "落实改革力得分区域排名趋势")
    private Integer workableRegionTrend;

    @ApiModelProperty(value = "落实改革力得分全市排名趋势")
    private Integer workableAllTrend;


    @ApiModelProperty(value = "改革经验获全国性肯定评价（件次）")
    private Integer nationwideNum;

    @ApiModelProperty(value = "改革经验获全国性肯定评价得分")
    private BigDecimal nationwideScore ;

    @ApiModelProperty(value = "改革经验获全国性肯定全市排名")
    private Integer nationwideSn ;

    @ApiModelProperty(value = "改革经验获全国性肯定全市排名档次（A，B，C，D，E）")
    private String nationwideGrade ;

    @ApiModelProperty(value = "改革经验获全国性肯定全市排名趋势")
    private Integer nationwideTrend;

    @ApiModelProperty(value = "改革经验获全市推广（件次）")
    private Integer cityNum;

    @ApiModelProperty(value = "改革经验获全市推广得分")
    private BigDecimal cityScore ;

    @ApiModelProperty(value = "改革经验获全市推广排名")
    private Integer citySn ;

    @ApiModelProperty(value = "改革经验获全市推广全市排名档次（A，B，C，D，E）")
    private String cityGrade ;

    @ApiModelProperty(value = "改革经验获全市推广全市排名趋势")
    private Integer cityTrend;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道（件次）")
    private Integer mediaNum ;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道得分")
    private BigDecimal mediaScore ;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道全市排名")
    private Integer mediaSn ;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道全市排名档次（A，B，C，D，E）")
    private String mediaGrade;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道全市排名趋势")
    private Integer mediaTrend;

    @ApiModelProperty(value = "品牌显示度得分")
    private BigDecimal brandScore ;

    @ApiModelProperty(value = "品牌显示度区域排名")
    private Integer brandRegionSn;

    @ApiModelProperty(value = "品牌显示度区域排名趋势")
    private Integer brandRegionTrend;

    @ApiModelProperty(value = "品牌显示度全市排名")
    private Integer brandAllSn;

    @ApiModelProperty(value = "品牌显示度全市排名趋势")
    private Integer brandAllTrend;


    @ApiModelProperty(value = "社情民意电话调查满意度（%）", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的综合得分")
    private BigDecimal satisfied;

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件（件次）")

    private Integer opinionNum;

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件（扣分）")
    private BigDecimal opinionDeScore;

    @ApiModelProperty(value = "改革风险得分")
    private BigDecimal opinionScore ;

    @ApiModelProperty(value = "改革风险得分全市排名")
    private Integer opinionAllSn ;

    @ApiModelProperty(value = "改革风险得分全市排名趋势")
    private Integer opinionAllTrend;

    @ApiModelProperty(value = "社情民意电话调查满意度得分，即经过功效系数法计算过后的得分")
    private BigDecimal satisfiedScore;

    @ApiModelProperty(value = "社情民意电话调查满意度区域排名", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的区域排名")
    private Integer satisfiedRegionSn;

    @ApiModelProperty(value = "满意度区域排名趋势")
    private Integer satisfiedRegionTrend;

    @ApiModelProperty(value = "社情民意电话调查满意度全市排名", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的全市排名")
    private Integer satisfiedAllSn;

    @ApiModelProperty(value = "社情民意电话调查满意度全市排名档次", notes = "排名档次（A：1~9，B:10~17，C：18~25，D：26~33，E:34~41）")
    private String satisfiedGrade;

    @ApiModelProperty(value = "满意度全市排名趋势")
    private Integer satisfiedAllTrend;

    @ApiModelProperty(value = "社情民意电话调查满意度蝉联次数", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的蝉联次数")
    private Integer satisfiedHoldNum;

    @ApiModelProperty(value = "综合得分", notes = "得分减去扣分后的最终结果")
    private BigDecimal score ;

    @ApiModelProperty(value = "综合得分区域排名")
    private Integer regionSn;

    @ApiModelProperty(value = "综合得分区域排名趋势")
    private Integer regionTrend;

    @ApiModelProperty(value = "综合得分全市排名分档")
    private String allGrade;

    @ApiModelProperty(value = "综合得分全市排名")
    private Integer allSn;

    @ApiModelProperty(value = "综合得分全市排名趋势")
    private Integer allTrend;

    @ApiModelProperty(value = "数字重庆建设进展率")
    private BigDecimal digitRate;

    @ApiModelProperty(value = "数字重庆建设进展率分档情况")
    private String digitGrade;

    @ApiModelProperty(value = "数字重庆建设进展率排名")
    private Integer digitSn;

    @ApiModelProperty(value = "数字重庆建设进展率排名趋势")
    private Integer digitTrend;

    @ApiModelProperty(value = "国企改革进展进展率")
    private BigDecimal reformRate;

    @ApiModelProperty(value = "国企改革进展进展率分档情况")
    private String reformGrade;

    @ApiModelProperty(value = "国企改革进展进展率排名")
    private Integer reformSn;

    @ApiModelProperty(value = "国企改革进展进展率排名趋势")
    private Integer reformTrend;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展率")
    private BigDecimal manufacturingIndustryRate;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展率分档情况")
    private String manufacturingIndustryGrade;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展进展率排名")
    private Integer manufacturingIndustrySn;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展进展率排名趋势")
    private Integer manufacturingIndustryTrend;

    @ApiModelProperty(value = "建立企业上市助推机制进展(分)")
    private BigDecimal listedCompaniesDivide;

    @ApiModelProperty(value = "建立企业上市助推机制进展率分档情况")
    private String listedCompaniesGrade;

    @ApiModelProperty(value = "建立企业上市助推机制进展率排名")
    private Integer listedCompaniesSn;

    @ApiModelProperty(value = "建立企业上市助推机制进展率排名趋势")
    private Integer listedCompaniesTrend;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率")
    private BigDecimal creditRate;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率分档情况")
    private String creditGrade;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率排名")
    private Integer creditSn;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率排名趋势")
    private Integer creditTrend;
}
