package com.artfess.reform.statistics.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author 黎沐华
 * @since 2023/3/30 10:40
 */
@Data
@ApiModel("区县品牌显示度评分结果计算VO")
public class BrandCalVo {

    @ApiModelProperty(value = "组织机构ID")
    private String orgId;

    @ApiModelProperty(value = "组织机构名")
    private String orgName;

    @ApiModelProperty(value = "组织机构编码")
    @TableField("UNIT_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "组织机构级别")
    private Integer orgGrade;

    @ApiModelProperty("成效类型")
    private String effectType;

    @ApiModelProperty("成效类型计数")
    private Integer effectCount;

    @ApiModelProperty("成效月份")
    private Integer effectMonth;

    @ApiModelProperty("成效年份")
    private Integer effectYear;

    public BrandCalVo( Integer effectMonth, Integer effectCount) {
        this.effectCount = effectCount;
        this.effectMonth = effectMonth;
    }

    public BrandCalVo() {
    }
}
