package com.artfess.reform.statistics.model;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目具体措施推进力评分结果
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
@TableName("BIZ_SCORING_PROJECT_MEASURE")
@ApiModel(value="BizScoringProjectMeasure对象", description="项目具体措施推进力评分结果")
@Data
public class BizScoringProjectMeasure extends BaseModel<BizScoringProjectMeasure> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "评比类型")
    @TableField("FILL_TYPE_")
    private String fillType;

    @ApiModelProperty(value = "评比项目")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "评比项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "明确措施个数")
    @TableField("MEASURE_NUM_")
    private Integer measureNum;

    @ApiModelProperty(value = "计划个数")
    @TableField("PLAN_NUM_")
    private Integer planNum;

    @ApiModelProperty(value = "完成个数")
    @TableField("PLAN_REACH_NUM_")
    private Integer planReachNum;

    @ApiModelProperty(value = "完成率")
    @TableField("PLAN_REACH_RATE_")
    private BigDecimal planReachRate;

    @ApiModelProperty(value = "明确形成制度个数")
    @TableField("REGIME_NUM_")
    private Integer regimeNum;

    @ApiModelProperty(value = "实际形成制度个数")
    @TableField("ACTUAL_REGIME_NUM_")
    private Integer actualRegimeNum;

    @ApiModelProperty(value = "形成制度得分")
    @TableField("REGIME_SCORE_")
    private BigDecimal regimeScore;

    @ApiModelProperty(value = "明确上线应用个数")
    @TableField("APP_NUM_")
    private Integer appNum;

    @ApiModelProperty(value = "实际上线应用个数")
    @TableField("ACTUAL_APP_NUM_")
    private Integer actualAppNum;

    @ApiModelProperty(value = "实际搭建平台个数")
    @TableField("PLATFORM_NUM_")
    private Integer platformNum;

    @ApiModelProperty(value = "明确搭建平台个数")
    @TableField("ACTUAL_PLATFORM_NUM_")
    private Integer actualPlatformNum;

    @ApiModelProperty(value = "搭建平台上线应用得分")
    @TableField("APP_PLATFORM_SCORE_")
    private BigDecimal appPlatformScore;

    @ApiModelProperty(value = "具体举措推进力评分")
    @TableField("MEASURE_SCORE_")
    private BigDecimal measureScore;

    @ApiModelProperty(value = "具体举措推进力排名")
    @TableField("MEASURE_SN_")
    private Integer measureSn;

    @ApiModelProperty(value = "蝉联次数")
    @TableField("HOLD_NUM_")
    private Integer holdNum;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "类型")
    @TableField(exist = false)
    private Integer type;

    @ApiModelProperty(value = "形成制度的完成率")
    @TableField(exist = false)
    private BigDecimal regimeRate;

    @ApiModelProperty(value = "搭建平台上线应用的完成率")
    @TableField(exist = false)
    private BigDecimal appPlatformRate;
}
