package com.artfess.reform.statistics.model;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目品牌显示度评分结果
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
@TableName("BIZ_SCORING_PROJECT_BRAND")
@ApiModel(value="BizScoringProjectBrand对象", description="项目品牌显示度评分结果")
@Data
public class BizScoringProjectBrand extends BaseModel<BizScoringProjectBrand> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "评比类型")
    @TableField("FILL_TYPE_")
    private String fillType;

    @ApiModelProperty(value = "评比项目")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "评比项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "改革经验获全国性肯定评价件次")
    @TableField("NATIONWIDE_NUM_")
    private Integer nationwideNum=0;

    @ApiModelProperty(value = "改革经验获全国性肯定评价得分")
    @TableField("NATIONWIDE_SCORE_")
    private BigDecimal nationwideScore;

    @ApiModelProperty(value = "改革经验获全市推广件次")
    @TableField("CITY_NUM_")
    private Integer cityNum=0;

    @ApiModelProperty(value = "改革经验获全市推广得分")
    @TableField("CITY_SCORE_")
    private BigDecimal cityScore;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道件次")
    @TableField("MEDIA_NUM_")
    private Integer mediaNum=0;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道得分")
    @TableField("MEDIA_SCORE_")
    private BigDecimal mediaScore;

    @ApiModelProperty(value = "品牌显示度得分")
    @TableField("BRAND_SCORE_")
    private BigDecimal brandScore;

    @ApiModelProperty(value = "品牌显示得分区域排名")
    @TableField("BRAND_REGION_SN_")
    private Integer brandRegionSn;

    @ApiModelProperty(value = "品牌显示得分全市排名")
    @TableField("BRAND_ALL_SN_")
    private Integer brandAllSn;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "蝉联次数")
    @TableField("HOLD_NUM_")
    private Integer holdNum;


}
