package com.artfess.reform.statistics.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.math.BigDecimal;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-07-21
 */
@TableName("BIZ_SCORING_COUNTY_MAJOR")
@ApiModel(value="BizScoringCountyMajor对象", description="")
@Data
public class BizScoringCountyMajor extends BaseModel<BizScoringCountyMajor> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("FILL_DATE_")
    private Date fillDate;

    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @TableField("FILL_TYPE_")
    private String fillType;

    @TableField("UNIT_NAME_")
    private String unitName;

    @TableField("UNIT_CODE_")
    private String unitCode;

    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @TableField("DIGIT_SN_")
    private Integer digitSn;

    @TableField("DIGIT_GRADE_")
    private String digitGrade;

    @TableField("DIGIT_RATE_")
    private BigDecimal digitRate;

    @ApiModelProperty(value = "国企改革进展进展率")
    @TableField("REFORM_RATE_")
    private BigDecimal reformRate;

    @ApiModelProperty(value = "国企改革进展进展率分档情况")
    @TableField("REFORM_GRADE_")
    private String reformGrade;

    @ApiModelProperty(value = "国企改革进展进展率排名")
    @TableField("REFORM_SN_")
    private Integer reformSn;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展率")
    @TableField("MANUFACTURING_INDUSTRY_RATE_")
    private BigDecimal manufacturingIndustryRate;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展率分档情况")
    @TableField("MANUFACTURING_INDUSTRY_GRADE_")
    private String manufacturingIndustryGrade;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展进展率排名")
    @TableField("MANUFACTURING_INDUSTRY_SN_")
    private Integer manufacturingIndustrySn;

    @ApiModelProperty(value = "建立企业上市助推机制进展(分)")
    @TableField("LISTED_COMPANIES_DIVIDE_")
    private BigDecimal listedCompaniesDivide;

    @ApiModelProperty(value = "建立企业上市助推机制进展率分档情况")
    @TableField("LISTED_COMPANIES_GRADE_")
    private String listedCompaniesGrade;

    @ApiModelProperty(value = "建立企业上市助推机制进展率排名")
    @TableField("LISTED_COMPANIES_SN_")
    private Integer listedCompaniesSn;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率")
    @TableField("CREDIT_RATE_")
    private BigDecimal creditRate;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率分档情况")
    @TableField("CREDIT_GRADE_")
    private String creditGrade;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率排名")
    @TableField("CREDIT_SN_")
    private Integer creditSn;


}
