package com.artfess.reform.statistics.manager.impl;

import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.artfess.reform.statistics.dao.BizScoringProjectTargetDao;
import com.artfess.reform.statistics.manager.BizScoringProjectTargetManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目量化目标推进力评分结果 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
@Service
public class BizScoringProjectTargetManagerImpl extends BaseManagerImpl<BizScoringProjectTargetDao, BizScoringProjectTarget> implements BizScoringProjectTargetManager {

    @Override
    @Transactional
    public List<BizScoringProjectTarget> countScore(LocalDate countDate) {
        LocalDate now =LocalDate.now();
        if(countDate==null){
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        List<BizScoringProjectTarget> list = this.baseMapper.statisticsNum(countDate.getYear());
        if(list!=null && list.size()>0){
            List<BigDecimal> reachRateList = new ArrayList<>();//所有项目改革经验被5家中央媒体深度专题报道件次集合
            for(BizScoringProjectTarget target :list){
                target.setFillDate(countDate);
                target.setFillYear(countDate.getYear());
                target.setFillQuarter(getSeasonDay(countDate));
                target.setFillMonth(countDate.getMonthValue());
                target.setFillType(getFillType(countDate));
                reachRateList.add(target.getReachRate());
            }
            CumputeUtil util = new CumputeUtil(3);
            for(BizScoringProjectTarget target :list){
                //功效计算全国推广得分
                BigDecimal targetScore = util.cumpute3(reachRateList.toArray(new BigDecimal[reachRateList.size()]),target.getReachRate(),new BigDecimal(35),true);
                target.setTargetScore(targetScore);
            }

            //查询上月的第一名(可能存在并列第一) 月末最后一天计算（除去第一个月）
            List<BizScoringProjectTarget>  NO1List  =new ArrayList<>();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth()==lastDay.getDayOfMonth()) {
                QueryWrapper<BizScoringProjectTarget> queryWrapper =new QueryWrapper();
                queryWrapper.eq("TARGET_SN_", 1);
                queryWrapper.eq("FILL_YEAR_", countDate.getYear());
                queryWrapper.eq("FILL_MONTH_", countDate.getMonthValue()-1);
                queryWrapper.eq("FILL_TYPE_", "M");
                NO1List = this.baseMapper.selectList(queryWrapper);
            }

            //排名
            list = list.stream().sorted((s1, s2) -> -s1.getTargetScore().compareTo(s2.getTargetScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringProjectTarget>>> snlist  = list.stream().collect(Collectors.groupingBy(BizScoringProjectTarget::getTargetScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer index = 1;

            for (Map.Entry<BigDecimal, List<BizScoringProjectTarget>> entry : snlist) {
                for(BizScoringProjectTarget target : entry.getValue()){
                    target.setTargetSn(index);
                    //蝉联(每个月最后一天计算)
                    if(lastDay.getDayOfMonth() == countDate.getDayOfMonth()){
                        if((NO1List ==null|| NO1List.size()==0) && index==1){
                            target.setHoldNum(0);
                        }else if((NO1List!=null && NO1List.size()>0) && index==1 ){
                            for(BizScoringProjectTarget NO1:NO1List){
                                if(NO1.getProjectId().equals(target.getProjectId())){
                                    target.setHoldNum(NO1.getHoldNum()+1);
                                    break;
                                }else{
                                    target.setHoldNum(0);
                                }
                            }
                        }
                    }
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                index = index + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }
            QueryWrapper<BizScoringProjectTarget> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("FILL_DATE_", countDate);
            this.baseMapper.delete(queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }

    public static String getFillType(LocalDate dateTime){
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if(month == 3 ||month == 6 ||month == 9 ||month == 12 ){
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue()+2)/3;
    }
}
