package com.artfess.reform.statistics.manager.impl;

import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.reform.statistics.dao.BizScoringProjectSynDao;
import com.artfess.reform.statistics.manager.BizScoringProjectSynManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.vo.SynReportVo;
import com.artfess.reform.majorProjects.dao.PilotSpecificSchedulePushDao;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeTargetListVo;
import com.artfess.reform.statistics.vo.ProjectRiskScoreVo;
import com.artfess.reform.statistics.vo.ProjectSynScoreVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目综合评分结果 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
@Service
public class BizScoringProjectSynManagerImpl extends BaseManagerImpl<BizScoringProjectSynDao, BizScoringProjectSyn> implements BizScoringProjectSynManager {

    @Resource
    PilotSpecificSchedulePushDao pilotSpecificSchedulePushDao;

    @Override
    public  Map<String,Object> querySynReportByFillYearMonth(Integer fillYear, Integer fillMonth) {
        if(fillMonth>12 || fillMonth<1){
            Calendar calendar = Calendar.getInstance();
            fillMonth = calendar.get(Calendar.MONTH) + 1;
        }
        if(fillYear==null){
            Calendar calendar = Calendar.getInstance();
            fillYear = calendar.get(Calendar.YEAR) ;
        }
        String monthValueFieldName="";
        if(fillMonth==1){
            monthValueFieldName ="JAN_VALUE_";
        }else if(fillMonth==2){
            monthValueFieldName ="FEB_VALUE_";
        }else if(fillMonth==3){
            monthValueFieldName ="MAR_VALUE_";
        }else if(fillMonth==4){
            monthValueFieldName ="APR_VALUE_";
        }else if(fillMonth==5){
            monthValueFieldName ="MAY_VALUE_";
        }else if(fillMonth==6){
            monthValueFieldName ="JUN_VALUE_";
        }else if(fillMonth==7){
            monthValueFieldName ="JUL_VALUE_";
        }else if(fillMonth==8){
            monthValueFieldName ="AUG_VALUE_";
        }else if(fillMonth==9){
            monthValueFieldName ="SEP_VALUE_";
        }else if(fillMonth==10){
            monthValueFieldName ="OCT_VALUE_";
        }else if(fillMonth==11){
            monthValueFieldName ="NOV_VALUE_";
        }else if(fillMonth==12){
            monthValueFieldName ="DEC_VALUE_";
        }
        List<PilotQuantitativeTargetListVo> scheduleList= pilotSpecificSchedulePushDao.queryTargetListByFillYearMonth(fillYear,fillMonth,monthValueFieldName);
        List<SynReportVo> list = this.baseMapper.queryMonthReportByYearMonth(fillYear,fillMonth);

        Map<String,Object> report = new HashMap<>();
        report.put("target",scheduleList);
        report.put("syn",list);
        return report;
    }

    @Override
    public List<BizScoringProjectSyn> countScore(LocalDate countDate) {
        LocalDate now =LocalDate.now();
        if(countDate==null){
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        List<ProjectRiskScoreVo>  riskList = this.baseMapper.statisticsRiskScore(countDate.getYear(),countDate.getMonthValue());
        List<ProjectSynScoreVo> synList = this.baseMapper.statisticsSynScore(countDate);
        Map<String, ProjectRiskScoreVo> riskScoreMap = riskList.stream().collect(Collectors.toMap(ProjectRiskScoreVo::getProjectId, ProjectRiskScoreVo -> ProjectRiskScoreVo));
        Map<String,ProjectSynScoreVo> synScoreMap = synList.stream().collect(Collectors.toMap(ProjectSynScoreVo::getProjectId, ProjectSynScoreVo -> ProjectSynScoreVo));
        List<BizScoringProjectSyn>  projectSynList = new ArrayList<>();
        if(synScoreMap!=null && synScoreMap.size()>0){
            int season = this.getSeasonDay(countDate);
            String type = this.getFillType(countDate);
            BizScoringProjectSyn  scoringProjectSyn =null;
            for(String key:synScoreMap.keySet()){
                scoringProjectSyn =new BizScoringProjectSyn();
                ProjectSynScoreVo synVo = synScoreMap.get(key);
                ProjectRiskScoreVo riskScore = riskScoreMap.get(key);
                if(riskScore!=null){
                    BigDecimal synAfterScore= synVo.getSynScore().subtract(riskScore.getScore());
                    scoringProjectSyn.setScore(synAfterScore);
                }else{
                    scoringProjectSyn.setScore(synVo.getSynScore());
                }
                scoringProjectSyn.setProjectId(key);
                scoringProjectSyn.setProjectName(synScoreMap.get(key).getProjectName());
                scoringProjectSyn.setFillDate(countDate);
                scoringProjectSyn.setFillYear(countDate.getYear());
                scoringProjectSyn.setFillQuarter(season);
                scoringProjectSyn.setFillMonth(countDate.getMonthValue());
                scoringProjectSyn.setFillType(type);
                scoringProjectSyn.setOpinionNum(riskScore.getTotleNum());
                scoringProjectSyn.setOpinionScore(riskScore.getScore());
                projectSynList.add(scoringProjectSyn);
            }

            //查询上月的第一名
            List<BizScoringProjectSyn>  NO1List  =new ArrayList<>();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth()==lastDay.getDayOfMonth()) {
                QueryWrapper<BizScoringProjectSyn> queryWrapper =new QueryWrapper();
                queryWrapper.eq("ALL_SN_", 1);
                queryWrapper.eq("FILL_YEAR_", countDate.getYear());
                queryWrapper.eq("FILL_MONTH_", countDate.getMonthValue()-1);
                queryWrapper.eq("FILL_TYPE_", "M");
                NO1List = this.baseMapper.selectList(queryWrapper);
            }
            //排名
            projectSynList = projectSynList.stream().sorted((s1, s2) -> -s1.getScore().compareTo(s2.getScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringProjectSyn>>> snlist  = projectSynList.stream().collect(Collectors.groupingBy(BizScoringProjectSyn::getScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer index = 1;

            for (Map.Entry<BigDecimal, List<BizScoringProjectSyn>> entry : snlist) {
                for(BizScoringProjectSyn syn : entry.getValue()){
                    syn.setAllSn(index);
                    //蝉联(每个月最后一天计算)
                    if(lastDay.getDayOfMonth() == countDate.getDayOfMonth()){
                        if((NO1List ==null|| NO1List.size()==0) && index==1){
                            syn.setHoldNum(0);
                        }else if((NO1List!=null && NO1List.size()>0) && index==1 ){
                            for(BizScoringProjectSyn NO1:NO1List){
                                if(NO1.getProjectId().equals(syn.getProjectId())){
                                    syn.setHoldNum(NO1.getHoldNum()+1);
                                    break;
                                }else{
                                    syn.setHoldNum(0);
                                }
                            }
                        }
                    }
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                index = index + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }
            QueryWrapper<BizScoringProjectSyn> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("FILL_DATE_", countDate);
            this.baseMapper.delete(queryWrapper);
            this.saveBatch(projectSynList);
        }
        return projectSynList;
    }

    public static String getFillType(LocalDate dateTime){
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if(month == 3 ||month == 6 ||month == 9 ||month == 12 ){
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue()+2)/3;
    }

}
