package com.artfess.reform.statistics.manager.impl;

import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.artfess.reform.statistics.dao.BizScoringProjectIterationDao;
import com.artfess.reform.statistics.manager.BizScoringProjectIterationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;

/**
 * 项目具体举措迭代统计表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-15
 */
@Service
public class BizScoringProjectIterationManagerImpl extends BaseManagerImpl<BizScoringProjectIterationDao, BizScoringProjectIteration> implements BizScoringProjectIterationManager {

    @Override
    public List<BizScoringProjectIteration> countScore(LocalDate countDate) {
        LocalDate now =LocalDate.now();
        if(countDate==null){
            countDate = now;
        }
        int season = this.getSeasonDay(countDate);
        int month = countDate.getMonthValue();
        List<BizScoringProjectIteration> list =this.baseMapper.queryIterationByDate(countDate.getYear(),season,month);
        if(list!=null && list.size()>0){
            String type = this.getFillType(countDate);
            for(BizScoringProjectIteration iteration : list){
                iteration.setFillDate(countDate);
                iteration.setFillYear(countDate.getYear());
                iteration.setFillQuarter(season);
                iteration.setFillMonth(month);
                iteration.setFillType(type);
            }
            QueryWrapper<BizScoringProjectIteration> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("FILL_DATE_", countDate);
            this.baseMapper.delete(queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }
    public static String getFillType(LocalDate dateTime){
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if(month == 3 ||month == 6 ||month == 9 ||month == 12 ){
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue()+2)/3;
    }
}
