package com.artfess.reform.statistics.manager.impl;

import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.statistics.dao.BizScoringProjectBrandDao;
import com.artfess.reform.statistics.manager.BizScoringProjectBrandManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目品牌显示度评分结果 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
@Service
public class BizScoringProjectBrandManagerImpl extends BaseManagerImpl<BizScoringProjectBrandDao, BizScoringProjectBrand> implements BizScoringProjectBrandManager {

    @Override
    @Transactional
    public List<BizScoringProjectBrand> countScore(LocalDate countDate) {
        LocalDate now =LocalDate.now();
        if(countDate==null){
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());

        int fillYear = countDate.getYear();
        String completionDate =  fillYear+"-01-01";
        List<BizScoringProjectBrand> list = this.baseMapper.statisticsBrandNum(fillYear,null,null,completionDate);
        if(list!=null && list.size()>0){
            List<Integer> nationwideList = new ArrayList<>();//所有项目改革经验获全国性肯定评价件次集合
            List<Integer> mediaList = new ArrayList<>();//所有项目改革经验被5家中央媒体深度专题报道件次集合
            for(BizScoringProjectBrand brand :list){
                brand.setFillDate(countDate);
                brand.setFillYear(countDate.getYear());
                brand.setFillQuarter(getSeasonDay(countDate));
                brand.setFillMonth(countDate.getMonthValue());
                brand.setFillType(getFillType(countDate));

                nationwideList.add(brand.getNationwideNum());
                mediaList.add(brand.getMediaNum());
            }
            CumputeUtil util = new CumputeUtil(3);
            for(BizScoringProjectBrand brand :list){
                //功效计算全国推广得分
                BigDecimal nationwideScore = util.cumpute3(nationwideList.stream().map(BigDecimal::valueOf).toArray(BigDecimal[]::new),new BigDecimal(brand.getNationwideNum()),new BigDecimal(20));
                //功效计算5家媒体得分
                BigDecimal[] gerar3 = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0.9"), new BigDecimal("0.6")};
                BigDecimal mediaScore = util.cumpute3(mediaList.stream().map(BigDecimal::valueOf).toArray(BigDecimal[]::new),new BigDecimal(brand.getMediaNum()),new BigDecimal(15),gerar3,true);
                //5家媒体得分+全国推广得分 = 品牌显示度得分
                BigDecimal brandScore = nationwideScore.add(mediaScore);

                brand.setNationwideScore(nationwideScore);
                brand.setMediaScore(mediaScore);
                brand.setBrandScore(brandScore);
            }
            //查询上月的第一名(可能存在并列第一)
            List<BizScoringProjectBrand>  NO1List  =new ArrayList<>();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth()==lastDay.getDayOfMonth()) {
                QueryWrapper<BizScoringProjectBrand> queryWrapper =new QueryWrapper();
                queryWrapper.eq("BRAND_ALL_SN_", 1);
                queryWrapper.eq("FILL_YEAR_", countDate.getYear());
                queryWrapper.eq("FILL_MONTH_", countDate.getMonthValue()-1);
                queryWrapper.eq("FILL_TYPE_", "M");
                NO1List = this.baseMapper.selectList(queryWrapper);
            }

            //排名
            list = list.stream().sorted((s1, s2) -> -s1.getBrandScore().compareTo(s2.getBrandScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringProjectBrand>>> snlist  = list.stream().collect(Collectors.groupingBy(BizScoringProjectBrand::getBrandScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer index = 1;

            for (Map.Entry<BigDecimal, List<BizScoringProjectBrand>> entry : snlist) {
                for(BizScoringProjectBrand brand : entry.getValue()){
                    brand.setBrandAllSn(index);
                    //蝉联(每个月最后一天计算)
                    if(lastDay.getDayOfMonth() == countDate.getDayOfMonth()){
                        if((NO1List ==null|| NO1List.size()==0) && index==1){
                            brand.setHoldNum(0);
                        }else if((NO1List!=null && NO1List.size()>0) && index==1 ){
                            for(BizScoringProjectBrand NO1:NO1List){
                                if(NO1.getProjectId().equals(brand.getProjectId())){
                                    brand.setHoldNum(NO1.getHoldNum()+1);
                                    break;
                                }else{
                                    brand.setHoldNum(0);
                                }
                            }
                        }
                    }
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                index = index + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }
            QueryWrapper<BizScoringProjectBrand> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("FILL_DATE_", countDate);
            this.baseMapper.delete(queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }

    public static String getFillType(LocalDate dateTime){
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if(month == 3 ||month == 6 ||month == 9 ||month == 12 ){
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue()+2)/3;
    }
}
