package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.statistics.dao.BizScoringCountyWorkableDao;
import com.artfess.reform.statistics.manager.BizScoringCountyWorkableManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.artfess.reform.statistics.vo.BrandCalVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.reform.utils.CumputeUtil;
import com.artfess.reform.utils.FieldFillUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 区县落实改革力评分结果 服务实现类
 *
 * @author chens
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-27
 */
@Service
public class BizScoringCountyWorkableManagerImpl extends BaseManagerImpl<BizScoringCountyWorkableDao, BizScoringCountyWorkable> implements BizScoringCountyWorkableManager {

    @Override
    @Transactional
    public List<BizScoringCountyWorkable> countScore(LocalDate countDate) {
        LocalDate now =LocalDate.now();
        if(countDate==null){
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        // 统计数据
        List<BizScoringCountyWorkable> pilotCount = baseMapper.countPilot(countDate);

        if(pilotCount!=null&&pilotCount.size()>0 ){
            for(BizScoringCountyWorkable workable:pilotCount){
                workable.setFillDate(countDate);
                workable.setFillYear(countDate.getYear());
                workable.setFillQuarter(getSeasonDay(countDate));
                workable.setFillMonth(countDate.getMonthValue());
                workable.setFillType(getFillType(countDate));

                if(workable.getProjectEndNum()!=0){
                    //计算所有项目的按时通过率
                    BigDecimal passRate = new BigDecimal(workable.getPassNum()).divide(new BigDecimal(workable.getProjectEndNum()),4, BigDecimal.ROUND_HALF_UP);
                    if(passRate.compareTo(new BigDecimal(1))>0){
                        passRate=new BigDecimal(1);
                    }
                    workable.setPassRate(passRate.multiply(new BigDecimal(100)));
                }else{
                    workable.setPassRate(new BigDecimal(0));
                }
                if(workable.getNationalEndNum()!=0){
                    //计算所有国家级项目的按时通过率
                    BigDecimal nationalpassRate = new BigDecimal(workable.getNationalPassNum()).divide(new BigDecimal(workable.getNationalEndNum()),4, BigDecimal.ROUND_HALF_UP);
                    if(nationalpassRate.compareTo(new BigDecimal(1))>0){
                        nationalpassRate=new BigDecimal(1);
                    }
                    workable.setNationalPassRate(nationalpassRate.multiply(new BigDecimal(100)));
                }else{
                    workable.setNationalPassRate(new BigDecimal(100));
                }
                if(workable.getCityEndNum()!=0){

                    //计算所有市级项目的按时通过率
                    BigDecimal cityPassRate = new BigDecimal(workable.getCityPassNum()).divide(new BigDecimal(workable.getCityEndNum()),4, BigDecimal.ROUND_HALF_UP);
                    if(cityPassRate.compareTo(new BigDecimal(1))>0){
                        cityPassRate=new BigDecimal(1);
                    }
                    workable.setCityPassRate(cityPassRate.multiply(new BigDecimal(100)));
                }else{
                    workable.setCityPassRate(new BigDecimal(100));
                }

                //新增试点数
                if(workable.getAddNum()>=15){
                    workable.setNationalAddGrade("A");
                }else if (workable.getAddNum()<15&&workable.getAddNum()>=10){
                    workable.setNationalAddGrade("B");
                }else if (workable.getAddNum()<10&&workable.getAddNum()>=5){
                    workable.setNationalAddGrade("C");
                }else {
                    workable.setNationalAddGrade("D");
                }

                //国家级新增试点数
                if(workable.getNationalAddNum()>=6){
                    workable.setNationalAddGrade("A");
                }else if (workable.getNationalAddNum()==5){
                    workable.setNationalAddGrade("B");
                }else if (workable.getNationalAddNum()<5&&workable.getNationalAddNum()>=1){
                    workable.setNationalAddGrade("C");
                }else {
                    workable.setNationalAddGrade("D");
                }

                //市级新增试点数
                if(workable.getCityAddNum()>=15){
                    workable.setCityAddGrade("A");
                }else if (workable.getCityAddNum()<15&&workable.getCityAddNum()>=10){
                    workable.setCityAddGrade("B");
                }else if (workable.getCityAddNum()<10&&workable.getCityAddNum()>=5){
                    workable.setCityAddGrade("C");
                }else {
                    workable.setCityAddGrade("D");
                }

                //承接国家级推进中试点项目数
                if(workable.getNationalProjectNum()>=20){
                    workable.setNationalProjectGrade("A");
                }else if(workable.getNationalProjectNum()<20&&workable.getNationalProjectNum()>=15){
                    workable.setNationalProjectGrade("B");
                }else if(15 > workable.getNationalProjectNum() && workable.getNationalProjectNum() >= 10){
                    workable.setNationalProjectGrade("C");
                }else{
                    workable.setNationalProjectGrade("D");
                }
                //承接市级试点项目数
                if(workable.getCityProjectNum()>=31){
                    workable.setCityProjectGrade("A");
                }else if(workable.getCityProjectNum()<31&&workable.getCityProjectNum()>=23){
                    workable.setCityProjectGrade("B");
                }else if(23 > workable.getCityProjectNum() && workable.getCityProjectNum() >= 16){
                    workable.setCityProjectGrade("C");
                }else{
                    workable.setCityProjectGrade("D");
                }

                //按照排名划分四线五档
//                if(workable.getAddSn()<=9){
//                    workable.setAddGrade("A");
//                }else if(17 >= workable.getAddSn() && workable.getAddSn() > 9){
//                    workable.setAddGrade("B");
//                }else if(25 >= workable.getAddSn() && workable.getAddSn() > 17){
//                    workable.setAddGrade("C");
//                }else if(33 >= workable.getAddSn() && workable.getAddSn() > 25){
//                    workable.setAddGrade("D");
//                }else if(workable.getAddSn() > 33){
//                    workable.setAddGrade("E");
//                }
//                if(workable.getCityAddSn()<=9){
//                    workable.setCityAddGrade("A");
//                }else if(17 >=workable.getCityAddSn() && workable.getCityAddSn() > 9){
//                    workable.setCityAddGrade("B");
//                }else if(25 >= workable.getCityAddSn() && workable.getCityAddSn() > 17){
//                    workable.setCityAddGrade("C");
//                }else if(33 >= workable.getCityAddSn() && workable.getCityAddSn() > 25){
//                    workable.setCityAddGrade("D");
//                }else if(workable.getCityAddSn() > 33){
//                    workable.setCityAddGrade("E");
//                }
//               //按照排名划分四线五档
//                if(workable.getNationalAddSn()<=9){
//                    workable.setNationalAddGrade("A");
//                }else if(17 >= workable.getNationalAddSn() && workable.getNationalAddSn() > 9){
//                    workable.setNationalAddGrade("B");
//                }else if(25 >= workable.getNationalAddSn() && workable.getNationalAddSn() > 17){
//                    workable.setNationalAddGrade("C");
//                }else if(33 >= workable.getNationalAddSn() && workable.getNationalAddSn() > 25){
//                    workable.setNationalAddGrade("D");
//                }else if(workable.getNationalAddSn() > 33){
//                    workable.setNationalAddGrade("E");
//                }
                //按照排名划分四线五档
//                if(workable.getNationalProjectSn()<=9){
//                    workable.setNationalProjectGrade("A");
//                }else if(17 >= workable.getNationalProjectSn() && workable.getNationalProjectSn() > 9){
//                    workable.setNationalProjectGrade("B");
//                }else if(25 >= workable.getNationalProjectSn() && workable.getNationalProjectSn() > 17){
//                    workable.setNationalProjectGrade("C");
//                }else if(33 >= workable.getNationalProjectSn() && workable.getNationalProjectSn() > 25){
//                    workable.setNationalProjectGrade("D");
//                }else if(workable.getNationalProjectSn() > 33){
//                    workable.setNationalProjectGrade("E");
//                }
//              //按照排名划分四线五档
//                if(workable.getCityProjectSn()<=9){
//                    workable.setCityProjectGrade("A");
//                }else if(17 >= workable.getCityProjectSn() && workable.getCityProjectSn() > 9){
//                    workable.setCityProjectGrade("B");
//                }else if(25 >= workable.getCityProjectSn() && workable.getCityProjectSn() > 17){
//                    workable.setCityProjectGrade("C");
//                }else if(33 >= workable.getCityProjectSn() && workable.getCityProjectSn() > 25){
//                    workable.setCityProjectGrade("D");
//                }else if(workable.getCityProjectSn() > 33){
//                    workable.setCityProjectGrade("E");
//                }
            }
            BigDecimal[] nationalList = pilotCount.stream().map(BizScoringCountyWorkable::getNationalProjectNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] nationalPassList = pilotCount.stream().map(BizScoringCountyWorkable::getNationalPassRate).toArray(BigDecimal[]::new);

            BigDecimal[] cityList = pilotCount.stream().map(BizScoringCountyWorkable::getCityProjectNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] cityPassList = pilotCount.stream().map(BizScoringCountyWorkable::getCityPassRate).toArray(BigDecimal[]::new);

          /*  BigDecimal[] countList = pilotCount.stream().map(BizScoringCountyWorkable::getProjectNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] passList = pilotCount.stream().map(BizScoringCountyWorkable::getPassRate).toArray(BigDecimal[]::new);*/
            // 计算得分
            CumputeUtil util = new CumputeUtil(2);
            for(BizScoringCountyWorkable workable :pilotCount){
                BigDecimal nationalPassRate = workable.getNationalPassRate();
                Integer nationalProjectNum =  workable.getNationalProjectNum();
                //功效计算承接国家级试点项目数得分
                BigDecimal nationalProjectScore = util.cumpute2(nationalList, new BigDecimal(nationalProjectNum), new BigDecimal(10));
                //功效计算承接的国家级按时通过验收率得分
                BigDecimal nationalPassScore = util.cumpute2(nationalPassList,nationalPassRate,new BigDecimal(3.5),false);

                BigDecimal cityPassRate = workable.getCityPassRate();
                Integer cityProjectNum =  workable.getCityProjectNum();
                //功效计算承接市级试点项目数得分
                BigDecimal cityProjectScore = util.cumpute2(cityList, new BigDecimal(cityProjectNum), new BigDecimal(8));
                //功效计算承接的市级试点按时通过验收率得分
                BigDecimal cityPassScore = util.cumpute2(cityPassList,cityPassRate,new BigDecimal(3.5),false);
                //试点的改革落实力得分
                BigDecimal workScore = nationalProjectScore.add(nationalPassScore).add(cityProjectScore).add(cityPassScore).setScale(2, BigDecimal.ROUND_HALF_UP);

                workable.setNationalProjectScore(nationalProjectScore);
                workable.setNationalPassScore(nationalPassScore);
                workable.setCityProjectScore(cityProjectScore);
                workable.setCityPassScore(cityPassScore);
                workable.setWorkableScore(workScore);


            }

            //查询上季度的第一名
            List<BizScoringCountyWorkable>  NO1List  =new ArrayList<>();
            int month = countDate.getMonthValue();
            if ((month == 6 ||month == 9 ||month == 12) && countDate.getDayOfMonth()==lastDay.getDayOfMonth()) {
                QueryWrapper<BizScoringCountyWorkable> queryWrapper =new QueryWrapper();
                queryWrapper.eq("WORKABLE_ALL_SN_", 1);
                queryWrapper.eq("FILL_YEAR_", countDate.getYear());
                queryWrapper.eq("FILL_QUARTER_", getSeasonDay(countDate)-1);
                queryWrapper.eq("FILL_TYPE_", "Q");
                NO1List = list(queryWrapper);
            }
            //查询上季度的蝉联情况
            QueryWrapper<BizScoringCountyWorkable> queryWrapper =new QueryWrapper();
            queryWrapper.eq("FILL_YEAR_", countDate.getYear());
            queryWrapper.eq("FILL_QUARTER_", getSeasonDay(countDate)-1);
            queryWrapper.eq("FILL_TYPE_", "Q");
            List <BizScoringCountyWorkable> holdList = list(queryWrapper);
            Map<String, Integer> snmap =new HashMap<>();
            if(holdList!=null && holdList.size()>0){
                holdList.forEach(hold ->{
                    if(hold.getHoldNum()!=null){
                        snmap.put(hold.getUnitCode(),hold.getHoldNum());
                    }
                });
              //  snmap = holdList.stream().collect(Collectors.toMap(BizScoringCountyWorkable::getUnitCode, BizScoringCountyWorkable::getHoldNum, (key1, key2) -> key2));
            }

            //全市排名
            pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getWorkableScore().compareTo(s2.getWorkableScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyWorkable>>> snList  = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getWorkableScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyWorkable>> entry : snList) {
                for(BizScoringCountyWorkable workable : entry.getValue()){
                    workable.setWorkableAllSn(index);
                    //蝉联(每个月最后一天计算)
                    if((month == 3 ||month == 6 ||month == 9 ||month == 12) && lastDay.getDayOfMonth() == countDate.getDayOfMonth()){
                        if((NO1List ==null|| NO1List.size()==0) && index==1){
                            workable.setHoldNum(0);
                        }else if((NO1List!=null && NO1List.size()>0) && index==1 ){
                            for(BizScoringCountyWorkable NO1:NO1List){
                                if(NO1.getUnitCode().equals(workable.getUnitCode())){
                                    workable.setHoldNum(NO1.getHoldNum()+1);
                                    break;
                                }else{
                                    workable.setHoldNum(0);
                                }
                            }
                        }
                    }else{
                        if(!snmap.isEmpty()){
                            workable.setHoldNum(snmap.get(workable.getUnitCode()));
                        }
                    }
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                index = index + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }
            //区域排名
           /* Map<String, List<BizScoringCountyWorkable>> regionMap = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getUnitGrade)); // 按照区域进行分组
            for (String key : regionMap.keySet()) {
                List<BizScoringCountyWorkable> goupList = regionMap.get(key);
                goupList = goupList.stream().sorted((s1, s2) -> -s1.getWorkableScore().compareTo(s2.getWorkableScore())).collect(Collectors.toList());
                List<Map.Entry<BigDecimal, List<BizScoringCountyWorkable>>> groupList  = goupList.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getWorkableScore)).entrySet()
                        .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
                Integer groupIndex = 1;

                for (Map.Entry<BigDecimal, List<BizScoringCountyWorkable>> entry : groupList) {
                    for(BizScoringCountyWorkable workable : entry.getValue()){
                        workable.setWorkableRegionSn(groupIndex);
                    }
                    groupIndex = groupIndex + entry.getValue().size();
                }
            }*/

            //国家级试点与市级试点按时通过率全市排名
            pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getPassRate().compareTo(s2.getPassRate())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyWorkable>>> passSnList  = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getPassRate)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer passIndex = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyWorkable>> entry : passSnList) {
                for(BizScoringCountyWorkable workable : entry.getValue()){
                    workable.setPassSn(passIndex);
//                    if(passIndex<=9){
//                        workable.setPassGrade("A");
//                    }else if(17 >= passIndex && passIndex > 9){
//                        workable.setPassGrade("B");
//                    }else if(25 >= passIndex && passIndex > 17){
//                        workable.setPassGrade("C");
//                    }else if(33 >= passIndex && passIndex > 25){
//                        workable.setPassGrade("D");
//                    }else if(passIndex > 33){
//                        workable.setPassGrade("E");
//                    }
                    if(workable.getPassRate().compareTo(new BigDecimal(100))==0){
                        workable.setPassGrade("A");
                    }else if(workable.getPassRate().compareTo(new BigDecimal(100))<0&&workable.getPassRate().compareTo(new BigDecimal(95))>=0){
                        workable.setPassGrade("B");
                    }else if(workable.getPassRate().compareTo(new BigDecimal(95))<0&&workable.getPassRate().compareTo(new BigDecimal(90))>=0){
                        workable.setPassGrade("C");
                    }else{
                        workable.setPassGrade("D");
                    }
                }
                passIndex = passIndex + entry.getValue().size();
            }
            //国家级试点按时通过率全市排名
            pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getNationalPassRate().compareTo(s2.getNationalPassRate())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyWorkable>>> nationalPassSnList  = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getNationalPassRate)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer nationalPassIndex = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyWorkable>> entry : nationalPassSnList) {
                for(BizScoringCountyWorkable workable : entry.getValue()){
                    workable.setNationalPassSn(nationalPassIndex);
                    //国家级试点验收率按照排名划分四线五档
//                    if(nationalPassIndex<=9){
//                        workable.setNationalPassGrade("A");
//                    }else if(17 >= nationalPassIndex && nationalPassIndex > 9){
//                        workable.setNationalPassGrade("B");
//                    }else if(25 >= nationalPassIndex && nationalPassIndex > 17){
//                        workable.setNationalPassGrade("C");
//                    }else if(33 >= nationalPassIndex && nationalPassIndex > 25){
//                        workable.setNationalPassGrade("D");
//                    }else if(nationalPassIndex > 33){
//                        workable.setNationalPassGrade("E");
//                    }
                    if(workable.getNationalPassRate().compareTo(new BigDecimal(100))==0){
                        workable.setNationalPassGrade("A");
                    }else if(workable.getNationalPassRate().compareTo(new BigDecimal(100))<0&&workable.getNationalPassRate().compareTo(new BigDecimal(95))>=0){
                        workable.setNationalPassGrade("B");
                    }else if(workable.getNationalPassRate().compareTo(new BigDecimal(95))<0&&workable.getNationalPassRate().compareTo(new BigDecimal(90))>=0){
                        workable.setNationalPassGrade("C");
                    }else{
                        workable.setNationalPassGrade("D");
                    }
                }
                nationalPassIndex = nationalPassIndex + entry.getValue().size();
            }

            //市级试点按时通过率全市排名
            pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getCityPassRate().compareTo(s2.getCityPassRate())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyWorkable>>> cityPassSnList  = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getCityPassRate)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer cityPassIndex = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyWorkable>> entry : passSnList) {
                for(BizScoringCountyWorkable workable : entry.getValue()){
                    workable.setCityPassSn(cityPassIndex);
//                    if(cityPassIndex<=9){
//                        workable.setCityPassGrade("A");
//                    }else if(17 >= cityPassIndex && cityPassIndex > 9){
//                        workable.setCityPassGrade("B");
//                    }else if(25 >= cityPassIndex && cityPassIndex > 17){
//                        workable.setCityPassGrade("C");
//                    }else if(33 >= cityPassIndex && cityPassIndex > 25){
//                        workable.setCityPassGrade("D");
//                    }else if(cityPassIndex > 33){
//                        workable.setCityPassGrade("E");
//                    }
                    if(workable.getCityPassRate().compareTo(new BigDecimal(100))==0){
                        workable.setCityPassGrade("A");
                    }else if(workable.getCityPassRate().compareTo(new BigDecimal(100))<0&&workable.getCityPassRate().compareTo(new BigDecimal(95))>=0){
                        workable.setCityPassGrade("B");
                    }else if(workable.getCityPassRate().compareTo(new BigDecimal(95))<0&&workable.getCityPassRate().compareTo(new BigDecimal(90))>=0){
                        workable.setCityPassGrade("C");
                    }else{
                        workable.setCityPassGrade("D");
                    }
                }
                cityPassIndex = cityPassIndex + entry.getValue().size();
            }

            //国家级试点数量全市排名
            /*pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getNationalProjectNum().compareTo(s2.getNationalProjectNum())).collect(Collectors.toList());
            List<Map.Entry<Integer, List<BizScoringCountyWorkable>>> nationalSnList  = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getNationalProjectNum)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer nationaIndex = 1;
            for (Map.Entry<Integer, List<BizScoringCountyWorkable>> entry : nationalSnList) {
                for(BizScoringCountyWorkable workable : entry.getValue()){
                    workable.setNationalProjectSn(nationaIndex);
                }
                nationaIndex = nationaIndex + entry.getValue().size();
            }

            //市级级试点数量全市排名
            pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getCityProjectNum().compareTo(s2.getCityProjectNum())).collect(Collectors.toList());
            List<Map.Entry<Integer, List<BizScoringCountyWorkable>>> citySnList  = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getCityProjectNum)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer cityIndex = 1;
            for (Map.Entry<Integer, List<BizScoringCountyWorkable>> entry : citySnList) {
                for(BizScoringCountyWorkable workable : entry.getValue()){
                    workable.setCityProjectSn(cityIndex);
                }
                cityIndex = cityIndex + entry.getValue().size();
            }*/

            QueryWrapper<BizScoringCountyWorkable> delWrapper = new QueryWrapper<>();
            delWrapper.eq("FILL_DATE_", countDate);
            this.baseMapper.delete(delWrapper);
            saveBatch(pilotCount);
        }

        return pilotCount;
    }

    public static String getFillType(LocalDate dateTime){
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if(month == 3 ||month == 6 ||month == 9 ||month == 12 ){
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue()+2)/3;
    }
}
