package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.statistics.dao.BizScoringCountyBrandDao;
import com.artfess.reform.statistics.manager.BizScoringCountyBrandManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 区县品牌显示度评分结果 服务实现类
 *
 * @author 黎沐华
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-30
 */
@Service
public class BizScoringCountyBrandManagerImpl extends BaseManagerImpl<BizScoringCountyBrandDao, BizScoringCountyBrand> implements BizScoringCountyBrandManager {

    @Override
    @Transactional
    public List<BizScoringCountyBrand> countScore(LocalDate countDate) {
        // 取出并合并根数据
        LocalDate now = LocalDate.now();
        if(countDate==null){
            countDate = now;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(Calendar.YEAR, countDate.getYear());
        Date currYearFirst = calendar.getTime();

        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());

        List<BizScoringCountyBrand> data = this.baseMapper.countEffrctive(currYearFirst,countDate);
        if (data != null && data.size() > 0) {
            for (BizScoringCountyBrand brand : data) {
                brand.setFillDate(countDate);
                brand.setFillYear(countDate.getYear());
                brand.setFillQuarter(getSeasonDay(countDate));
                brand.setFillMonth(countDate.getMonthValue());
                brand.setFillType(getFillType(countDate));

                if(brand.getNationwideNum()>=16){
                    brand.setNationwideGrade("A");
                }else if(brand.getNationwideNum()<16&&brand.getNationwideNum()>=12){
                    brand.setNationwideGrade("B");
                }else if(brand.getNationwideNum()<12&&brand.getNationwideNum()>=7){
                    brand.setNationwideGrade("C");
                }else {
                    brand.setNationwideGrade("D");
                }

                if(brand.getCityNum()>=165){
                    brand.setCityGrade("A");
                }else if(brand.getCityNum()<165 && brand.getCityNum() >= 128){
                    brand.setCityGrade("B");
                }else if(brand.getCityNum()<128 && brand.getCityNum() >= 92){
                    brand.setCityGrade("C");
                }else {
                    brand.setCityGrade("D");
                }




//                if(brand.getNationwideSn()<=9){
//                    brand.setNationwideGrade("A");
//                }else if(17 >= brand.getNationwideSn() && brand.getNationwideSn() > 9){
//                    brand.setNationwideGrade("B");
//                }else if(25 >= brand.getNationwideSn() && brand.getNationwideSn() > 17){
//                    brand.setNationwideGrade("C");
//                }else if(33 >= brand.getNationwideSn() && brand.getNationwideSn() > 25){
//                    brand.setNationwideGrade("D");
//                }else if(brand.getNationwideSn() > 33){
//                    brand.setNationwideGrade("E");
//                }
//
//                if(brand.getCitySn()<=9){
//                    brand.setCityGrade("A");
//                }else if(17 >= brand.getCitySn() && brand.getCitySn() > 9){
//                    brand.setCityGrade("B");
//                }else if(25 >= brand.getCitySn() && brand.getCitySn() > 17){
//                    brand.setCityGrade("C");
//                }else if(33 >= brand.getCitySn() && brand.getCitySn() > 25){
//                    brand.setCityGrade("D");
//                }else if(brand.getCitySn() > 33){
//                    brand.setCityGrade("E");
//                }
//
//                if(brand.getMediaSn()<=9){
//                    brand.setMediaGrade("A");
//                }else if(17 >= brand.getMediaSn() && brand.getMediaSn() > 9){
//                    brand.setMediaGrade("B");
//                }else if(25 >= brand.getMediaSn() && brand.getMediaSn() > 17){
//                    brand.setMediaGrade("C");
//                }else if(33 >= brand.getMediaSn() && brand.getMediaSn() > 25){
//                    brand.setMediaGrade("D");
//                }else if(brand.getMediaSn() > 33){
//                    brand.setMediaGrade("E");
//                }
            }
            // 计算得分
            BigDecimal[] nationCount = data.stream().map(BizScoringCountyBrand::getNationwideNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] cityCount = data.stream().map(BizScoringCountyBrand::getCityNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] mediaCount = data.stream().map(BizScoringCountyBrand::getMediaNum).map(BigDecimal::new).toArray(BigDecimal[]::new);

            data.forEach(d -> {
                //全国推广得分
                d.setNationwideScore(new CumputeUtil().cumpute3(nationCount, new BigDecimal(d.getNationwideNum()), new BigDecimal(20), false));
                //全市推广得分
                d.setCityScore(new CumputeUtil().cumpute3(cityCount, new BigDecimal(d.getCityNum()), new BigDecimal(10), false));
                //媒体推广得分
                BigDecimal[] mediaCoefficient = new BigDecimal[]{new BigDecimal(1.0), new BigDecimal(0.8), new BigDecimal(0.6)};
                d.setMediaScore(new CumputeUtil(mediaCoefficient, 2).cumpute3(mediaCount, new BigDecimal(d.getMediaNum()), new BigDecimal(10), false));
                //品牌显示度总分
//                d.setBrandScore(d.getNationwideScore().add(d.getCityScore().add(d.getMediaScore()).setScale(2, BigDecimal.ROUND_HALF_UP)));
                d.setBrandScore(d.getNationwideScore().add(d.getCityScore().setScale(2, BigDecimal.ROUND_HALF_UP)));

            });

            //查询上季度的第一名
            List<BizScoringCountyBrand> NO1List = new ArrayList<>();
            int month = countDate.getMonthValue();
            if ((month == 6 || month == 9 || month == 12) && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
                QueryWrapper<BizScoringCountyBrand> queryWrapper = new QueryWrapper();
                queryWrapper.eq("BRAND_ALL_SN_", 1);
                queryWrapper.eq("FILL_YEAR_", countDate.getYear());
                queryWrapper.eq("FILL_QUARTER_", getSeasonDay(countDate) - 1);
                queryWrapper.eq("FILL_TYPE_", "Q");
                NO1List = list(queryWrapper);
            }
            //查询上季度的蝉联情况
            QueryWrapper<BizScoringCountyBrand> queryWrapper = new QueryWrapper();
            queryWrapper.eq("FILL_YEAR_", countDate.getYear());
            queryWrapper.eq("FILL_QUARTER_", getSeasonDay(countDate) - 1);
            queryWrapper.eq("FILL_TYPE_", "Q");
            List<BizScoringCountyBrand> holdList = list(queryWrapper);
            Map<String, Integer> snmap = new HashMap<>();
            if (holdList != null && holdList.size() > 0) {
                holdList.forEach(hold ->{
                    if(hold.getHoldNum()!=null){
                        snmap.put(hold.getUnitCode(),hold.getHoldNum());
                    }
                });
                //snmap = holdList.stream().collect(Collectors.toMap(BizScoringCountyBrand::getUnitCode, BizScoringCountyBrand::getHoldNum, (key1, key2) -> key2));
            }

            //全市排名
            data = data.stream().sorted((s1, s2) -> -s1.getBrandScore().compareTo(s2.getBrandScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyBrand>>> snList = data.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getBrandScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyBrand>> entry : snList) {
                for (BizScoringCountyBrand workable : entry.getValue()) {
                    workable.setBrandAllSn(index);
                    //蝉联(每个季度最后一天计算)
                    if ((month == 3 ||month == 6 || month == 9 || month == 12) && lastDay.getDayOfMonth() == countDate.getDayOfMonth()) {
                        if ((NO1List == null || NO1List.size() == 0) && index == 1) {
                            workable.setHoldNum(0);
                        } else if ((NO1List != null && NO1List.size() > 0) && index == 1) {
                            for (BizScoringCountyBrand NO1 : NO1List) {
                                if (NO1.getUnitCode().equals(workable.getUnitCode())) {
                                    workable.setHoldNum(NO1.getHoldNum() + 1);
                                    break;
                                } else {
                                    workable.setHoldNum(0);
                                }
                            }
                        }
                    } else {
                        //其它时候的蝉联数据取上月的数据
                        if (!snmap.isEmpty()) {
                            workable.setHoldNum(snmap.get(workable.getUnitCode()));
                        }
                    }
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                index = index + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }
            //区域排名
            /*Map<Integer, List<BizScoringCountyBrand>> regionMap = data.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getUnitGrade)); // 按照区域进行分组
            for (Integer key : regionMap.keySet()) {
                List<BizScoringCountyBrand> goupList = regionMap.get(key);
                goupList = goupList.stream().sorted((s1, s2) -> -s1.getBrandScore().compareTo(s2.getBrandScore())).collect(Collectors.toList());
                List<Map.Entry<BigDecimal, List<BizScoringCountyBrand>>> groupList = goupList.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getBrandScore)).entrySet()
                        .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
                Integer groupIndex = 1;

                for (Map.Entry<BigDecimal, List<BizScoringCountyBrand>> entry : groupList) {
                    for (BizScoringCountyBrand workable : entry.getValue()) {
                        workable.setBrandRegionSn(groupIndex);
                    }
                    groupIndex = groupIndex + entry.getValue().size();
                }

            }*/

            //全国推广全市排名
           /* data = data.stream().sorted((s1, s2) -> -s1.getNationwideScore().compareTo(s2.getNationwideScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyBrand>>> nationwideSnList = data.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getNationwideScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer nationwideIndex = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyBrand>> entry : nationwideSnList) {
                for (BizScoringCountyBrand workable : entry.getValue()) {
                    workable.setNationwideSn(nationwideIndex);
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                nationwideIndex = nationwideIndex + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }

            //全市推广全市排名
            data = data.stream().sorted((s1, s2) -> -s1.getCityScore().compareTo(s2.getCityScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyBrand>>> citySnList = data.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getCityScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer citySnIndex = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyBrand>> entry : citySnList) {
                for (BizScoringCountyBrand workable : entry.getValue()) {
                    workable.setCitySn(citySnIndex);
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                citySnIndex = citySnIndex + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }

            //媒体推广全市排名
            data = data.stream().sorted((s1, s2) -> -s1.getMediaScore().compareTo(s2.getMediaScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountyBrand>>> mediaSnList = data.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getMediaScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer mediaSnIndex = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountyBrand>> entry : mediaSnList) {
                for (BizScoringCountyBrand workable : entry.getValue()) {
                    workable.setMediaSn(mediaSnIndex);
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                mediaSnIndex = mediaSnIndex + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }*/

            QueryWrapper<BizScoringCountyBrand> delWrapper = new QueryWrapper<>();
            delWrapper.eq("FILL_DATE_", countDate);
            this.baseMapper.delete(delWrapper);
            saveBatch(data);
        }
        return data;
    }

    public static String getFillType(LocalDate dateTime) {
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}
