package com.artfess.reform.statistics.manager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesVo;
import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.artfess.reform.statistics.vo.*;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.List;

/**
 * @author chens
 * @date 2023/3/31 20:06
 */
@Service
public interface ProjectLargeScreeManager {

    /**
     * 指数排行榜
     * @param type 类型：composite 综合排名、single 单项
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    JSONArray indexRank(String type,Integer year,Integer month);


    /**
     * 作战图统计数据
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    JSONObject monthPlanNum(String projectId,Integer year,Integer month);

    /**
     * 各项目作战图统计数据
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    List<MonthPlanNumVO> monthPlanNumForProject(Integer year, Integer month);

    /**
     * 作战图统计详情数据
     * @return 数据
     */
    JSONObject  monthPlanNumDetails(Integer year,Integer month,String projectId);

    /**
     * 量化目标
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    JSONObject targetNum(Integer year,Integer month);

    /**
     * 改革需求热力榜
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    JSONObject demandHeatList(Integer year, Integer month);

    /**
     * 改革需求热力榜详情
     * @return 数据
     */
    JSONObject demandDetailList(QueryFilter<BizReformDemandAssignment> queryFilter);


    /**
     * 品牌榜月度统计（折线图）
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    List<BrandLineChartVO> brandLineChart(String projectId,Integer year, Integer month);

    /**
     * 品牌榜项目统计（折线图）
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    List<BrandLineChartVO> queryBrandForProject(String projectId,Integer year, Integer month);

    /**
     * 品牌榜详情
     * @param projectId
     * @param year
     * @param month
     * @return
     */
    List<PilotBrandPush> queryBrandForProjectInfo(String projectId, Integer year, Integer month);

    /**
     * 迭代榜项目统计
     * @param year 年
     * @param month 月度
     * @return 数据
     */
    List<BizScoringProjectIteration> queryIterationForProject(Integer year, Integer month);

    /**
     * 迭代榜项目详情查询
     */
    IterationVo queryIterationForProjectInfo(String projectId,Integer year,Integer month);

    /**
     * 成果榜数量统计（共计,环比）
     */
    ScheduleVo achievementCount(String projectId,Integer year,Integer month);

    /**
     * 查询各重大项目成果数量
     * @param year
     * @param month
     * @return
     */
    List<ScheduleVo> achievementInvCount(Integer year,Integer month);

    /**
     * 成果榜详细数据查询
     * @param queryFilter
     * @return
     */
    PageList<PilotMeasuresPush> achievementInfo(QueryFilter<PilotMeasuresPush> queryFilter);

    /**
     * 指标库达标率查询
     * @param year
     * @param month
     * @return
     */
    IndexVo reachRateCount(String projectId, Integer year, Integer month);

    /**
     * 各项目核心指标达标情况总览查询
     * @param year
     * @param month
     * @return
     */
    IndexProjectVo reachProjectRateCount(Integer year, Integer month);

    /**
     * 进入指标库查询
     */
    IndexDetailsVo indexDetails(String projectId, Integer year, Integer month);

    /**
     * 市级大屏进入各项目分驾驶舱月度计划清单查询
     */
    List<PilotSpecificSchedule> schedulePlanInfo(String projectId,Integer year,Integer month);

    /**
     * 市级大屏进入各项目分驾驶舱复制推广查询
     */
    List<PilotExperiencePush> pilotExperiencePushInfo(String projectId,Integer year,Integer month);

    /**
     * 市级大屏进入各项目分驾驶舱量化目标查询
     * @param projectId
     * @param year
     * @param month
     * @return
     */
    List<QuantitativeObjectivesVo> quantitativeObjectivesInfo(String projectId,Integer year, Integer month);

    /**
     * 验收率详情查询
     */
    AcceptanceVo acceptanceRateInfo(LocalDate countDate,String unitId);
}
