package com.artfess.reform.statistics.manager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.*;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.vo.*;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author 黎沐华
 * @date 2023/3/31 20:06
 */
@Service
public interface CountyLargeScreeManager {

    /**
     * 重点关注
     *  @param year 年
     *  @param quarter 季度
     * @return 数据
     */
    CoreIndexVo importantIndex(Integer year,Integer quarter);

    /**
     * 逐优榜

     *  @param year 年
     *  @param quarter 季度
     * @return 数据
     */
    List<CountySynVo> indexRank(Integer year,Integer quarter);

    /**
    * @Description: 试点成果统计数据
    * @param year 年
    * @param quarter  季度
    * @param unitCode  区县
    * @Return: com.artfess.reform.statistics.vo.CountyPilotReformVo
    * @Author: chens
    * @Date: 2023/4/5 14:15
    */
    CountyPilotReformVo pilotReform(Integer year,Integer quarter,String unitCode);

    /**
     * @Description: 查询统计品牌榜数据
     * @param year 年
     * @param quarter 季度
     * @param effectForm 1：全市推广，2：获全市推广，3：被5家中央媒体深度专题报道
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/8 16:11
     */
    CountyBrandVo brandReform(Integer year, Integer quarter,String unitId,List<Integer> effectForm);

    /**
    * 查询最新满意度数据的实际填报时间
    * @param year     填报年度
    * @param quarter  填报季度
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2023/6/9 11:11
    */
    String satisfactionRealityDate(Integer year, Integer quarter);

    /**
     * @Description: 查询区县品牌榜详细数据
     * @param year 年
     * @param quarter 季度
     * @param unitCode 区县编码
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/8 16:11
     */
    List<BizEffectEffectiveness> brandReformDetails(String unitCode,Integer year, Integer quarter,QueryFilter<BizEffectEffectiveness> queryFilter);

    /**
    * @Description: 查询区县大屏全市推广或全国+媒体推广的排名
    * @param year 年
    * @param quarter 季度
    * @param type 1：全市推广，2：全国+媒体推广
    * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
    * @Author: chens
    * @Date: 2023/4/8 16:11
    */
    List<BizScoringCountyBrand> citywidePromotionRank(Integer year, Integer quarter,Integer type);

    PageList<BizEffectEffectiveness> cityPromotionDetail(QueryFilter<BizEffectEffectiveness> queryFilter);

    JSONArray gisIndex(String type,Integer year,Integer quarter);

/*    JSONObject demandHeatList(Integer year, Integer quarter);

    JSONObject demandDetailList(QueryFilter<BizReformDemandAssignment> queryFilter);*/

    PageList<BizPilotAdvanceResult> pilotResultDetail(QueryFilter<BizPilotAdvanceResult> queryFilter);

    List<CountyChartVo> pilotLedger(Integer year, Integer quarter);

    PageList<BizReformPilotManagement> pilotLedgerDetail(QueryFilter<BizReformPilotManagement> queryFilter);

    PageList<BizReformPilotManagement> pilotLedgerDetailSpc(QueryFilter<BizReformPilotManagement> queryFilter);


    BizReformPilotManagement pilotPushDetail(String pilotId,String unitCode);

    JSONObject historyStatementFile(Integer year);

    /**
    * @Description: 二级驾驶舱 --核心指数
    * @param unitCode 区县编码
    * @param year 年度
    * @param quarter 季度
    * @Return: com.alibaba.fastjson.JSONObject
    * @Author: chens
    * @Date: 2023/4/5 14:56
    */
    CoreIndexVo queryCoreIndex(String unitCode, Integer year, Integer quarter);

    /**
     * @Description: 二级驾驶舱 --指数排行
     * @param unitCode 区县编码
     * @param year 年度
     * @param quarter 季度
     * @Return: com.alibaba.fastjson.JSONObject
     * @Author: chens
     * @Date: 2023/4/5 14:56
     */
    CoreIndexVo queryIndexSn(String unitCode, Integer year, Integer quarter);

    /**
    * @Description: 区县大屏综合报表
    * @param year 年度
    * @param quarter   季度
    * @Return: java.util.List<com.artfess.reform.statistics.vo.StatementDetailVo>
    * @Author: chens
    * @Date: 2023/4/6 19:16
    */
    List<StatementDetailVo> statementDetail( Integer year, Integer quarter);

    JSONObject reformDemand(Integer year, Integer quarter,String unitCode);

    JSONObject problemSolving(Integer year, Integer quarter,String unitCode);

    JSONObject brandBuild(Integer year, Integer quarter, String unitCode,QueryFilter<BizEffectEffectiveness> queryFilter);

    JSONObject currentStatementFile(Integer year,Integer quarter);

    PageList<BizReformPilotManagement> pilotLedgerDetailSec(QueryFilter<BizReformPilotManagement> queryFilter);

    BizReformSatisfactionManagement getByFiles(Integer year,Integer quarter);
//
//    Boolean isLook();
}
