package com.artfess.reform.statistics.manager;

import com.artfess.base.query.QueryFilter;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.fill.vo.MeasureListVO;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.time.LocalDate;
import java.util.List;

/**
 * 项目具体措施推进力评分结果 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
public interface BizScoringProjectMeasureManager extends BaseManager<BizScoringProjectMeasure> {

    IPage<MeasureListVO> select4Cockpit(QueryFilter<BizScoringProjectMeasure> queryFilter);

    List<BizScoringProjectMeasure> getList();

    /**
    * @Description: 计算项目具体措施推进力评分
     * @param countDate
    * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringProjectMeasure>
    * @Author: chens
    * @Date: 2023/4/24 15:51
    */
    List<BizScoringProjectMeasure> countScore(LocalDate countDate);
}
