package com.artfess.reform.statistics.dao;

import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.fill.vo.MeasureListVO;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目具体措施推进力评分结果 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
public interface BizScoringProjectMeasureDao extends BaseMapper<BizScoringProjectMeasure> {

    List<PilotMeasuresPush> getPushList(@Param("projectId")String projectId,@Param("planId")String planId);


    IPage<MeasureListVO> select4Cockpit(IPage<BizScoringProjectMeasure> iPage, @Param("type") Integer type,@Param("year") Integer year);

    /**
     * 根据填报年度查询所有项目的品牌显示度月度评分
     * @param fillYear 填报年
     * @param fillMonth 填报月
     * @return
     */
    List<BizScoringProjectMeasure>queryMonthMeasureByYearMonth(@Param("fillYear") Integer  fillYear, @Param("fillMonth") Integer  fillMonth);

    /**
    * @Description:更具时间统计当前的数据
    * @param fillYear 统计年份
    * @param fillQuarter 统计季度
    * @param fillMonth   统计月份
    * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringProjectMeasure>
    * @Author: chens
    * @Date: 2023/3/29 15:53
    */
    List<BizScoringProjectMeasure> statisticsNum(@Param("fillYear") Integer  fillYear,@Param("fillQuarter") Integer  fillQuarter,  @Param("fillMonth") Integer  fillMonth);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @param projectId  项目ID
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectMeasure> queryLatest(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType, @Param("projectId") String projectId);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectMeasure> queryLatestNo1(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType);

}
