package com.artfess.reform.statistics.dao;

import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.vo.BrandLineChartVO;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目品牌显示度评分结果 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
public interface BizScoringProjectBrandDao extends BaseMapper<BizScoringProjectBrand> {

    /**
     * 根据填报年度查询所有项目的品牌显示度月度评分
     * @param fillYear 填报年
     * @param fillMonth 填报月
     * @return
     */
    List<BizScoringProjectBrand> queryMonthBrandByYearMonth(@Param("fillYear") Integer  fillYear, @Param("fillMonth") Integer  fillMonth);

    /**
    * @Description: 统计品牌显示度
    * @param fillYear 填报年
    * @param fillQuarter 填报季度
    * @param fillMonth 填报月
    * @param completionDate  成果完成时间
    * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringProjectBrand>
    * @Author: chens
    * @Date: 2023/3/30 17:10
    */
    List<BizScoringProjectBrand> statisticsBrandNum(@Param("fillYear") Integer  fillYear, @Param("fillQuarter") Integer  fillQuarter,
                                                    @Param("fillMonth") Integer  fillMonth, @Param("completionDate") String  completionDate);


    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @param projectId  项目ID
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectBrand> queryLatest(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType, @Param("projectId") String projectId);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectBrand> queryLatestNo1(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType);

    /**
     * @Description: 按月统计品牌榜数据
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BrandLineChartVO> brandLineChart(@Param("projectId") String projectId,@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth);


    /**
     * @Description: 按项目统计品牌榜数据
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BrandLineChartVO> queryBrandForProject(@Param("projectId") String projectId,@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth);
}
