package com.artfess.reform.statistics.dao;

import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.vo.CountySynVo;
import com.artfess.reform.statistics.vo.StatementDetailVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 区县满意度评分、风险扣分、综合评分结果 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-03-30
 */
public interface BizScoringCountySynDao extends BaseMapper<BizScoringCountySyn> {
    List<BizScoringCountySyn> indexRank(@Param("year") Integer year,@Param("quarter") Integer quarter);


    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillQuarter 评比季度
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @param unitCode  区县编码
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringCountySyn> queryLatest(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter, @Param("fillType") String fillType, @Param("unitCode") String unitCode);

    /**
     * @Description: 查询最新的综合评分全市第一的数据
     * @param fillYear 评比年
     * @param fillQuarter 评比季度
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @param type 查询数据类型（syn：综合第一名，satisfied：满意度第一名）
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringCountySyn> queryLatestNo1(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter, @Param("fillType") String fillType,@Param("type") String type);


    /**
    * @Description: 查询区县综合评比分数
    * @param fillYear 评比年
    * @param fillQuarter   评比季度
    * @Return: java.util.List<com.artfess.reform.statistics.vo.StatementDetailVo>
    * @Author: chens
    * @Date: 2023/4/6 20:45
    */
    List<StatementDetailVo> statementDetail(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter);


    /**
     * @Description: 查询区县逐优榜信息
     * @param fillYear 评比年
     * @param fillQuarter   评比季度
     * @Return: java.util.List<com.artfess.reform.statistics.vo.CountySynVo>
     * @Author: chens
     * @Date: 2023/4/6 20:45
     */
    List<CountySynVo> indexSynRankBest(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter);

    /**
     * @Description: 查询区县的品牌显示度，落实改革力的统计信息
     * @param fillYear 评比年
     * @param fillQuarter   评比季度
     * @Return: java.util.List<com.artfess.reform.statistics.vo.CountySynVo>
     * @Author: chens
     * @Date: 2023/4/6 20:45
     */
    List<CountySynVo> indexSynForWorkableAndBrand(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter);

}
