package com.artfess.reform.statistics.dao;

import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.artfess.reform.statistics.vo.BrandCalVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 区县品牌显示度评分结果 Mapper 接口
 *
 * @author 黎沐华
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-30
 */
public interface BizScoringCountyBrandDao extends BaseMapper<BizScoringCountyBrand> {

    /**
     * @Description: 统计所有区县最新的评分结果的合计
     * @param fillYear 评比年
     * @param fillQuarter 评比季度
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    BizScoringCountyBrand statisticsLatest(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter);


    /**
     * 查询最新品牌显示度得分情况
     * @param fillYear    评比年
     * @param fillQuarter 评比季度
     * @param fillType    评比类型（日：D，月：M，季度：Q，年：Y）
     * @param unitCode    区县编码
     * @Description: 查询最新的评分结果
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringCountyBrand> queryLatest(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter, @Param("fillType") String fillType, @Param("unitCode") String unitCode);

    /**
     * 查询最新品牌显示度得分的全市排名第一的数据
     * @param fillYear    评比年
     * @param fillQuarter 评比季度
     * @param fillType    评比类型（日：D，月：M，季度：Q，年：Y）
     * @Description: 查询最新的评分结果
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringCountyBrand> queryLatestNo1(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter, @Param("fillType") String fillType);


    /**
     * @param startDate 评比的开始时间（一般来说是当前年的第一天）
     * @param endDate  评比的结束时间（一般来说是当前时间）
     * @Description: 统计品牌显示度数据
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 21:43
     */
    List<BizScoringCountyBrand> countEffrctive(@Param("startDate") Date startDate,@Param("endDate") LocalDate endDate);

    List<BrandCalVo> brandReformChart(@Param("year") Integer year,@Param("unitId") String unitId);
}
