package com.artfess.reform.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.vo.TargetAllVO;
import com.artfess.reform.fill.vo.TargetVO;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.artfess.reform.statistics.manager.BizScoringProjectTargetManager;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目量化目标推进力评分结果 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
@RestController
@RequestMapping("/bizScoringProjectTarget/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "项目量化目标推进力评分结果")
public class BizScoringProjectTargetController extends BaseController<BizScoringProjectTargetManager, BizScoringProjectTarget> {


    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    @Resource
    private PilotSpecificScheduleManager pilotSpecificScheduleManager;

    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<BizScoringProjectTarget> query(@RequestBody QueryFilter<BizScoringProjectTarget> queryFilter) {
        SimpleDateFormat formatter= new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        QueryWrapper<BizScoringProjectTarget> wrapper = new QueryWrapper<>();
        wrapper.orderByDesc("FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectTarget projects = baseService.getOne(wrapper);
        if (projects!=null){
            queryFilter.addFilter("FILL_DATE_",df.format(projects.getFillDate()), QueryOP.EQUAL);
        }else {
            Date date = new Date(System.currentTimeMillis());
            queryFilter.addFilter("FILL_DATE_",formatter.format(date), QueryOP.EQUAL);
        }
        return super.query(queryFilter);
    }

    @GetMapping(value="/target", produces={"application/json; charset=utf-8" })
    @ApiOperation("量化目标")
    public TargetVO target() {
        TargetVO vo = new TargetVO();
        LocalDateTime now = LocalDateTime.now();
        QueryWrapper<MunicipalMajorProjectManagement> projectwrapper = new QueryWrapper<>();
        projectwrapper.eq("IS_DELE_", "0");
        projectwrapper.eq("CLOSING_", 1);
        List<MunicipalMajorProjectManagement> projects = municipalMajorProjectManagementManager.list(projectwrapper);
        int allNum = 0;
        int monthNum = 0;
        BigDecimal allRate = new BigDecimal(0);
        for (MunicipalMajorProjectManagement project:projects){
            QueryWrapper<BizScoringProjectTarget> seasonWrapper = new QueryWrapper<>();
            seasonWrapper.eq("FILL_YEAR_",now.getYear());
            seasonWrapper.eq("FILL_MONTH_",now.getMonthValue());
            seasonWrapper.eq("PROJECT_ID_",project.getId());
            seasonWrapper.orderByDesc("FILL_DATE_");
            seasonWrapper.last("limit 1");
            BizScoringProjectTarget seasonList = baseService.getOne(seasonWrapper);
            if (seasonList!=null){
                allNum+=seasonList.getTargetNum();
                monthNum+=seasonList.getReachNum();
                if (!seasonList.getReachRate().equals(BigDecimal.ZERO)){
                    allRate = allRate.add(seasonList.getReachRate());
                }
            }
        }
        vo.setMonthNum(monthNum);
        vo.setAllNum(allNum);
        if (!allRate.equals(BigDecimal.ZERO)&&projects.size()>0){
            vo.setRate(allRate.divide(new BigDecimal(projects.size()),2,BigDecimal.ROUND_HALF_UP));
        }else {
            vo.setRate(allRate);
        }
        return vo;
    }

    @GetMapping(value="/targetAll", produces={"application/json; charset=utf-8" })
    @ApiOperation("量化目标总览")
    public List<TargetAllVO> targetAll() {
        List<TargetAllVO> vos = new ArrayList<>();
        TargetAllVO vo = new TargetAllVO();
        LocalDateTime now = LocalDateTime.now();
        QueryWrapper<MunicipalMajorProjectManagement> projectwrapper = new QueryWrapper<>();
        projectwrapper.eq("IS_DELE_", "0");
        projectwrapper.eq("CLOSING_", 1);
        List<MunicipalMajorProjectManagement> projects = municipalMajorProjectManagementManager.list(projectwrapper);

        for (MunicipalMajorProjectManagement project:projects){
            int allNum = 0;
            int finishNum = 0;
            QueryWrapper<PilotSpecificSchedule> scheduleQueryWrapper = new QueryWrapper<>();
            scheduleQueryWrapper.eq("PLAN_YEAR_",now.getYear());
            scheduleQueryWrapper.eq("IS_DELE_","0");
            scheduleQueryWrapper.eq("PROJECT_ID_",project.getId());
            List<PilotSpecificSchedule> schedules = pilotSpecificScheduleManager.list(scheduleQueryWrapper);
            allNum+=schedules.size();
            QueryWrapper<PilotMeasuresPush> pushQueryWrapper = new QueryWrapper<>();
            pushQueryWrapper.eq("IS_DELE_","0");
            pushQueryWrapper.eq("PROJECT_ID_",project.getId());
            pushQueryWrapper.eq("IS_OVER_",1);
            List<PilotMeasuresPush> pushes = pilotMeasuresPushManager.list(pushQueryWrapper);
            finishNum+=pushes.size();
            vo.setProjectName(project.getProjectName());
            if (finishNum>0&&allNum>0){
                vo.setRate(new BigDecimal(allNum).divide(new BigDecimal(finishNum),2,BigDecimal.ROUND_HALF_UP));
            }else {
                vo.setRate(BigDecimal.ZERO);
            }
            vos.add(vo);
        }

        vos = vos.stream().sorted(Comparator.comparing(TargetAllVO::getRate).reversed()).collect(Collectors.toList());

        return vos;
    }


    @GetMapping("/testCountScore")
    public List<BizScoringProjectTarget> testCountScore(@RequestParam(value = "countDate",required = false) LocalDate countDate) {
        return baseService.countScore(countDate);
    }


}
