package com.artfess.reform.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.statistics.manager.BizScoringProjectBrandManager;
import com.artfess.reform.statistics.manager.BizScoringProjectMeasureManager;
import com.artfess.reform.statistics.manager.BizScoringProjectTargetManager;
import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.artfess.reform.statistics.vo.SingleVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.reform.statistics.manager.BizScoringProjectSynManager;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 项目综合评分结果 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
@RestController
@RequestMapping("/bizScoringProjectSyn/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "项目综合评分结果")
public class BizScoringProjectSynController extends BaseController<BizScoringProjectSynManager, BizScoringProjectSyn> {


    @PostMapping(value="/querySynReport", produces={"application/json; charset=utf-8" })
    @ApiOperation("重大改革项目综合报表查询")
    public Map<String,Object> querySynReport(@ApiParam(name="fillYear",value="填报年", required = true)@RequestParam Integer fillYear,
                                            @ApiParam(name="fillMonth",value="填报月", required = true)@RequestParam Integer fillMonth) {
        Map<String,Object> map = this.baseService.querySynReportByFillYearMonth(fillYear,fillMonth);
        return map;
    }


    @GetMapping("/testCountScore")
    public List<BizScoringProjectSyn> testCountScore(LocalDate countDate) {
        return baseService.countScore(countDate);
    }

}
