package com.artfess.reform.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.vo.IterationAddVO;
import com.artfess.reform.fill.vo.IterationUpdateVO;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresHistoryManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.artfess.reform.statistics.manager.BizScoringProjectIterationManager;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目具体举措迭代统计表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-15
 */
@RestController
@RequestMapping("/bizScoringProjectIteration/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "项目具体举措迭代统计")
public class BizScoringProjectIterationController extends BaseController<BizScoringProjectIterationManager, BizScoringProjectIteration> {


    @Resource
    private PilotSpecificMeasuresHistoryManager pilotSpecificMeasuresHistoryManager;

    @Resource
    private PilotSpecificMeasuresManager pilotSpecificMeasuresManager;

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<BizScoringProjectIteration> query(@RequestBody QueryFilter<BizScoringProjectIteration> queryFilter) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper<BizScoringProjectIteration> wrapper = new QueryWrapper<>();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        wrapper.orderByDesc("FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectIteration projects = baseService.getOne(wrapper);
        if (projects != null) {
            queryFilter.addFilter("FILL_DATE_", df.format(projects.getFillDate()), QueryOP.EQUAL);
        } else {
            Date date = new Date(System.currentTimeMillis());
            queryFilter.addFilter("FILL_DATE_", formatter.format(date), QueryOP.EQUAL);
        }

        PageList<BizScoringProjectIteration> result =  super.query(queryFilter);
        List<BizScoringProjectIteration> list = result.getRows();
        for (BizScoringProjectIteration iteration : list){
            QueryWrapper<PilotSpecificMeasuresHistory> historyQueryWrapper = new QueryWrapper<>();
            historyQueryWrapper.eq("PROJECT_ID_",iteration.getProjectId());
            historyQueryWrapper.eq("STATUS_",5);
            historyQueryWrapper.eq("IS_DELE_","0");
            historyQueryWrapper.eq("DISTRIBUTION_TYPE_",1);
            historyQueryWrapper.eq("ITERATION_",1);
            List<PilotSpecificMeasuresHistory> histories = pilotSpecificMeasuresHistoryManager.list(historyQueryWrapper);
            List<IterationAddVO> addVOS = new ArrayList<>();
            if (histories.size()>0){
                for (PilotSpecificMeasuresHistory add : histories){
                    IterationAddVO addVO = new IterationAddVO();
                    addVO.setCause(add.getIterationAccording());
                    addVO.setName(add.getReformSpecificMeasures());
                    addVOS.add(addVO);
                }
            }
            iteration.setAddVOS(addVOS);

            QueryWrapper<PilotSpecificMeasures> updateWrapper = new QueryWrapper<>();
            updateWrapper.eq("PROJECT_ID_",iteration.getProjectId());
            updateWrapper.eq("STATUS_",5);
            updateWrapper.eq("IS_DELE_","0");
            updateWrapper.eq("DISTRIBUTION_TYPE_",1);
            updateWrapper.eq("ITERATION_",1);
            List<IterationUpdateVO> updateVOS = new ArrayList<>();
            for (PilotSpecificMeasures measures:pilotSpecificMeasuresManager.list(updateWrapper)){
                QueryWrapper<PilotSpecificMeasuresHistory> updateHistory = new QueryWrapper<>();
                updateHistory.eq("PROJECT_ID_",iteration.getProjectId());
                updateHistory.eq("STATUS_",5);
                updateHistory.eq("IS_DELE_",0);
                updateHistory.eq("DISTRIBUTION_TYPE_",1);
                updateHistory.eq("ITERATION_",2);
                updateHistory.eq("SPECIFIC_MEASURES_ID_",measures.getId());
                updateHistory.orderByDesc("SN_");
                List<PilotSpecificMeasuresHistory>  updateList = pilotSpecificMeasuresHistoryManager.list(updateHistory);
                if (updateList.size()>0){
                    IterationUpdateVO updateVO = new IterationUpdateVO();
                    PilotSpecificMeasuresHistory newUpdate = updateList.get(0);
                    PilotSpecificMeasuresHistory oldUpdate = updateList.get(updateList.size()-1);
                    updateVO.setCause(newUpdate.getIterationAccording());
                    updateVO.setNewName(newUpdate.getReformSpecificMeasures());
                    updateVO.setOldName(oldUpdate.getReformSpecificMeasures());
                    updateVOS.add(updateVO);
                }

            }
            iteration.setUpdateVOS(updateVOS);
        }
        result.setRows(list);
        return result;
    }


    @GetMapping("/testCountScore")
    public List<BizScoringProjectIteration> testCountScore(LocalDate countDate) {
        return baseService.countScore(countDate);
    }
}
