package com.artfess.reform.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.statistics.manager.BizScoringCountySynManager;
import com.artfess.reform.statistics.model.BizScoringCountySyn;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.util.List;

/**
 * 区县满意度评分、风险扣分、综合评分结果 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-03-30
 */
@Slf4j
@RestController
@Api(tags = "区县满意度评分、风险扣分、综合评分结果接口")
@RequestMapping("/statistics/bizScoringCountySyn/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizScoringCountySynController extends BaseController<BizScoringCountySynManager, BizScoringCountySyn> {

    @GetMapping("/testCountScore")
    public List<BizScoringCountySyn> testCountScore(@RequestParam("countDate")LocalDate countDate) {
        return baseService.countScore(countDate);
    }

}
