package com.artfess.reform.majorProjects.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 重大改革项目明确的量化目标清单
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-03-10
 */
@Data
@ApiModel(value="PilotQuantitativeTargetListVo", description="重大改革项目明确的量化目标清单")
public class PilotQuantitativeTargetListVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "量化目标ID")
    private String objectivesId;

    @ApiModelProperty(value = "量化目标内容")
    private String reformQuantitativeObjectives;

    @ApiModelProperty(value = "量化目标计量单位")
    private String reformQuantitativeObjectivesUnit;

    @ApiModelProperty(value = "年目标值")
    private double yearValue;

    @ApiModelProperty(value = "当月目标值")
    private double monthValue;

    @ApiModelProperty(value = "填报ID")
    private String fillId;

    @ApiModelProperty(value = "填报年")
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    private Integer fillMonth;

    @ApiModelProperty(value = "填报月")
    private Date fillDate;

    @ApiModelProperty(value = "最新填报数据")
    private double fillData;

    @ApiModelProperty(value = "当年目标完成率")
    private double yearRate;

    @ApiModelProperty(value = "当月目标完成率")
    private double monthRate;



}
