package com.artfess.reform.majorProjects.vo;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.reform.majorProjects.model.PilotObjectivesDetails;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 改革方案明确的量化目标表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@ApiModel(value="PilotQuantitativeObjectivesPushVo对象", description="改革方案明确的量化目标推进详情VO")
public class PilotQuantitativeObjectivesPushVo extends PilotQuantitativeObjectivesPush {

    private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "量化目标")
    private String reformQuantitativeObjectives;

    @ApiModelProperty(value = "年度目标")
    private String reformQuantitativeObjectivesYear;

    @ApiModelProperty(value = "月度目标")
    private String reformQuantitativeObjectivesMouth;

    @ApiModelProperty(value = "目标单位")
    private String reformQuantitativeObjectivesUnit;

    @ApiModelProperty(value = "最新目标值")
    private BigDecimal reformQuantitativeObjectivesValue;

    @ApiModelProperty(value = "最新完成率")
    private BigDecimal complianceRate;


}
