package com.artfess.reform.majorProjects.vo;

import com.artfess.reform.majorProjects.model.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
@ApiModel(value="PilotProjectFillCreateVo对象", description="市级重大改革项目填报审核记录创建请求参数")
public class PilotProjectFillQueryVo {

    @ApiModelProperty(value = "市级重大改革项目信息，包含目标信息等")
    private MunicipalMajorProjectManagement municipalMajorProjectManagement;

    @ApiModelProperty(value = "市级重大改革项目填报审核记录")
    private PilotProjectFill pilotProjectFill;

    @ApiModelProperty(value = "量化目标推进情况集合")
    private List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushList;

    @ApiModelProperty(value = "项目具体举措计划推进情况集合")
    private List<PilotMeasuresPushVo> pilotMeasuresPushList;

    @ApiModelProperty(value = "项目具体举措计划推进情况集合（按照季度处理后的数据）")
    private List<Map<String, List<PilotMeasuresPushVo>>> pilotMeasuresPushQuarterList;

    @ApiModelProperty(value = "项目经验推广总结情况集合")
    private List<PilotExperiencePush> pilotExperiencePushList;

    @ApiModelProperty(value = "进度计划明细推进情况集合")
    private List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList;

    @ApiModelProperty(value = "项目品牌显示度情况集合")
    private List<PilotBrandPush> pilotBrandPushList;


}
