package com.artfess.reform.majorProjects.vo;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.reform.majorProjects.model.*;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 市级重大改革项目管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@ApiModel(value="MunicipalMajorProjectManagementVo对象", description="市级重大改革项目审核填报初始化对象")
public class MunicipalMajorProjectManagementVo{

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试点项目名称")
    private String projectName;

    @ApiModelProperty(value = "数据ID")
    private String dataId;

    @ApiModelProperty(value = "项目类型(1:加快实施一批，2:准备启动一批，3:谋划储备一批)")
    private Integer projectType;

    @ApiModelProperty(value = "牵头市领导")
    private String leader;

    @ApiModelProperty(value = "责任单位ID")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    private String unitGrade;

    @ApiModelProperty(value = "审核状态（子表更新后自动更新）")
    private Integer status;

    @ApiModelProperty(value = "主责单位状态最后更新时间")
    private LocalDateTime propulsiveUpdateDate;

    @ApiModelProperty(value = "是否结项（0：已结项，1：未结项，结项后数据将不再在驾驶舱上面展示）")
    private Integer closing;

    @ApiModelProperty(value = "更新状态（后端字段，0：已更新，1：未更新）")
    private Integer propulsiveUpdateStatus;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "改革方案明确的量化目标集合-包含推进情况草稿")
    private List<PilotQuantitativeObjectivesVo> pilotQuantitativeObjectivesList;

    @ApiModelProperty(value = "改革方案明确的具体举措集合")
    private List<PilotSpecificMeasures> pilotSpecificMeasuresList;

    @ApiModelProperty(value = "进度计划表集合-包含计划推进情况草稿")
    private List<PilotMeasuresVo> pilotSpecificScheduleList;

    @ApiModelProperty(value = "进度计划表集合（按照季度处理后的数据）")
    private List<Map<String, List<PilotMeasuresVo>>> pilotSpecificScheduleQuarterList;

    @ApiModelProperty(value = "市级重大改革项目填报审核记录")
    private PilotProjectFill pilotProjectFill;

    @ApiModelProperty(value = "项目经验推广总结情况集合")
    private List<PilotExperiencePush> pilotExperiencePushList;

    @ApiModelProperty(value = "进度计划明细推进情况集合")
    private List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList;

    @ApiModelProperty(value = "项目品牌显示度情况集合")
    private List<PilotBrandPush> pilotBrandPushList;

}
