package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 改革方案明确的具体举措迭代历史表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@TableName("BIZ_PILOT_SPECIFIC_MEASURES_HISTORY")
@ApiModel(value="BizPilotSpecificMeasuresHistory对象", description="改革方案明确的具体举措迭代历史表")
public class PilotSpecificMeasuresHistory extends AutoFillFullModel<PilotSpecificMeasuresHistory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "原始举措数据ID")
    @TableField("SPECIFIC_MEASURES_ID_")
    private String specificMeasuresId;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value ="同步状态（0：未同步，1：已同步）")
    @TableField("SYN_STATUS_")
    private Integer synStatus;

    @ApiModelProperty(value = "迭代年份")
    @TableField("ITERATION_YEAR_")
    private Integer iterationYear;

    @ApiModelProperty(value = "迭代季度")
    @TableField("ITERATION_QUARTER_")
    private Integer iterationQuarter;

    @ApiModelProperty(value = "迭代月度")
    @TableField("ITERATION_MONTH_")
    private Integer iterationMonth;

    @ApiModelProperty(value = "迭代日期")
    @TableField("ITERATION_DATE_")
    private LocalDate iterationDate;

    @ApiModelProperty(value = "具体举措")
    @TableField("REFORM_SPECIFIC_MEASURES_")
    private String reformSpecificMeasures;

    @ApiModelProperty(value = "分发类型（0：改革委下发,1：责任单位迭代）")
    @TableField("DISTRIBUTION_TYPE_")
    private Integer distributionType;

    @ApiModelProperty(value = "责任单位跌代类型（0：责任单位新增，1：责任单位迭代【修改】）")
    @TableField("ITERATION_")
    private Integer iteration;

    @ApiModelProperty(value = "责任单位迭代依据")
    @TableField("ITERATION_ACCORDING_")
    private String iterationAccording;

    @ApiModelProperty(value = "审核状态（使用字典，0：草稿，1：已录入待审核，2：责任单位领导审核驳回,3：责任单位领导审核通过，4：市委改革办审核驳回，5：市委改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "迭代版本号（从0开始，依次累加）")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele = "0";


    @ApiModelProperty(value = "原始举措")
    @TableField(exist = false)
    private String rawMeasures;

    @ApiModelProperty(value = "月度计划集合")
    @TableField(exist = false)
    private List<PilotSpecificSchedule> pilotSpecificScheduleList;

}
