package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目经验推广总结情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */

@Data
@TableName("BIZ_PILOT_EXPERIENCE_PUSH")
@ApiModel(value="BizPilotExperiencePush对象", description="项目经验推广总结情况")
public class PilotExperiencePush extends AutoFillFullModel<PilotExperiencePush> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据ID")
    @TableField(exist = false)
    private String dataId;

    @ApiModelProperty(value = "填报ID")
    @TableField("FILL_ID_")
    private String fillId;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "推广方式(1:新闻发布会，2：现场观摩会，3：系统培训会，4：总结推广会，5：其它）")
    @TableField("PROMOTION_TYPE_")
    private Integer promotionType;

    @ApiModelProperty(value = "推广内容")
    @TableField("PROMOTION_CONTENT_")
    private String promotionContent;

    @ApiModelProperty(value = "推广日期")
    @TableField("PROMOTION_DATE_")
    private LocalDate promotionDate;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private String classified;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    private String isDelete = "0";

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> defaultFileList;
}
