package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目品牌显示度情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */

@Data
@TableName("BIZ_PILOT_BRAND_PUSH")
@ApiModel(value="BizPilotBrandPush对象", description="项目品牌显示度情况")
public class PilotBrandPush extends AutoFillFullModel<PilotBrandPush> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据ID")
    @TableField(exist = false)
    private String dataId;

    @ApiModelProperty(value = "填报ID")
    @TableField("FILL_ID_")
    private String fillId;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "获奖日期")
    @TableField("COMPLETION_DATE_")
    private LocalDate completionDate;

    @ApiModelProperty(value = "获肯定方式（1：获全国性肯定评价，2：获全市推广，3：被5家中央媒体深度专题报道）")
    @TableField("EFFECT_FORM_")
    private Integer effectForm;

    @ApiModelProperty(value = "具体情形（使用级联字典，与成效形式级联，获全国性肯定评价包括: 1：在党和国家领导人出席的全国性会议作经验交流，2：获党中央国务院或中办国办发文通报表彰。3：在党中央国务院或中办国办文件中得到肯定性表述。4：被中央和国家有关部委工作简报刊发。5：获党和国家领导人肯定性批示。6：在国家部委主要领导出席的全国性会议作经验交流。7：在国家部委文件中得到肯定性表述。	            获全市推广包括:	            1：获市委市政府(含两办)文件点名推广。2：在有市委或市政府主要领导出席的全市性会议上作经验交流。3：在本区县召开有市领导参加的改革经验现场推广会。4：改革经验被列入市委:“最佳实践”案例。5：在本区县召开有市级部门主要负责人参加的全市性改革经验现场推广会。6：获市级部门文件点名推广。	            5家中央媒体包括: 1：人民日报新华社。2：光明日报。3：经济日报。4：中央广播电视总台）")
    @TableField("SPECIFIC_DETAILS_")
    private Integer specificDetails;

    @ApiModelProperty(value = "获肯定依据（文字描述+上传作证材料+网站链接）")
    @TableField("PROPULSIVE_DETAILED_")
    private String propulsiveDetailed;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private String classified;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    private String isDelete = "0";

    @ApiModelProperty(value = "解决问题")
    @TableField("SOLVE_PROBLEM_")
    private String solveProblem;

    @ApiModelProperty(value = "取得成果")
    @TableField("RESULT_")
    private String result;

    @ApiModelProperty(value = "文件上传ids")
    @TableField(exist = false)
    private List<String> ids;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> files;


}
