package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.*;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 市级重大改革项目填报审核记录
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-10-17
 */

@Data
@TableName("BIZ_PILOT_NOT_START_PROJECT_FILL")
@ApiModel(value="BizPilotNotStartProjectFill对象", description="市级重大改革项目填报审核记录")
public class BizPilotNotStartProjectFill extends AutoFillFullModel<BizPilotNotStartProjectFill> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目ID")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private Date fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "审核状态（使用字典，0：草稿，1：提交改革办核准，2：改革办审核驳回，,3：改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "驳回意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "执行结果（0：同意，1：驳回，2：撤回）")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "月度战况列表")
    @TableField(exist = false)
    List<BizPilotNotStartMeasuresPush> pilotNotStartMeasuresPushList;

}
