package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 市级重大改革项目(谋划储备一批和准备启动一批)管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-10-17
 */

@Data
@TableName("BIZ_MUNICIPAL_NOT_START_PROJECT_MANAGEMENT")
@ApiModel(value="BizMunicipalNotSatrtProjec对象", description="市级重大改革项目(谋划储备一批和准备启动一批)管理表")
public class BizMunicipalNotStartProjectManagement extends AutoFillFullModel<BizMunicipalNotStartProjectManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试点项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "项目类型(1:加快实施一批，2:准备启动一批，3:谋划储备一批)")
    @TableField("PROJECT_TYPE_")
    private Integer projectType;

    @ApiModelProperty(value = "专项小组名称")
    @TableField("GROUP_NAME_")
    private String groupName;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("PROJECT_FIELD_")
    private Integer projectField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField("PROJECT_RUNWAY_")
    private Integer projectRunway;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "审核状态（0.草稿 1.分发）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "审核状态")
    @TableField(exist = false)
    private Integer fillStatus ;

    @ApiModelProperty(value = "审核id")
    @TableField(exist = false)
    private String fillId;

    @ApiModelProperty(value = "月度战况列表")
    @TableField(exist = false)
    List<BizPilotNotStartMeasuresPush> pilotNotStartMeasuresPushList;
}
