package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.majorProjects.manager.*;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.dao.PilotSpecificSchedulePushDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.vo.*;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * j进度计划推进情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Service
public class PilotSpecificSchedulePushManagerImpl extends BaseManagerImpl<PilotSpecificSchedulePushDao, PilotSpecificSchedulePush> implements PilotSpecificSchedulePushManager {


    @Resource
    private FileManager fileManager;

    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    @Resource
    private PilotSpecificScheduleManager pilotSpecificScheduleManager;

    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Resource
    private SysDictionaryManager sysDictionaryManager;

    @Resource
    private PilotProjectFillManager pilotProjectFillManager;

    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;


    @Override
    @Transactional
    public void create(PilotSpecificSchedulePush pilotSpecificSchedulePush) {
        Assert.notNull(pilotSpecificSchedulePush, "计划推进情况不能为空！");
        // 保存数据
        boolean save = super.save(pilotSpecificSchedulePush);
        // 保存文件
        List<DefaultFile> defaultFileList = pilotSpecificSchedulePush.getDefaultFileList();
        if(null != defaultFileList && defaultFileList.size() > 0){
//            defaultFileList.stream().forEach(p -> p.setBizId(pilotSpecificSchedulePush.getId()));
            List<String>  fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
            // 修改附件bizId
            fileManager.updateFileBizIdByIds(fileIdList, pilotSpecificSchedulePush.getId(), "ProjectResult");
        }
    }

    @Override
    @Transactional
    public boolean save(PilotSpecificSchedulePush pilotSpecificSchedulePush) {
        boolean b = super.save(pilotSpecificSchedulePush);
        // 保存文件
        List<DefaultFile> defaultFileList = pilotSpecificSchedulePush.getDefaultFileList();
        if(null != defaultFileList && defaultFileList.size() > 0){
//            defaultFileList.stream().forEach(p -> p.setBizId(pilotSpecificSchedulePush.getId()));
            List<String>  fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
            // 修改附件bizId
            fileManager.updateFileBizIdByIds(fileIdList, pilotSpecificSchedulePush.getId(), "ProjectResult");
        }
        return b;
    }

    @Override
    @Transactional
    public void saveBatch(List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList) {
        Assert.notNull(pilotSpecificSchedulePushList, "计划推进情况不能为空！");
        super.saveBatch(pilotSpecificSchedulePushList);
        if(null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0){
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : pilotSpecificSchedulePushList){
                List<DefaultFile> defaultFileList = pilotSpecificSchedulePush.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String>  fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileIdList, pilotSpecificSchedulePush.getId(), "ProjectResult");
                }
            }
        }
    }

    @Override
    public boolean saveOrUpdate(PilotSpecificSchedulePush pilotSpecificSchedulePush) {
        boolean b = super.saveOrUpdate(pilotSpecificSchedulePush);
        // 保存文件
        List<DefaultFile> defaultFileList = pilotSpecificSchedulePush.getDefaultFileList();
        if(null != defaultFileList && defaultFileList.size() > 0){
//            defaultFileList.stream().forEach(p -> p.setBizId(pilotSpecificSchedulePush.getId()));
            List<String>  fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
            // 修改附件bizId
            fileManager.updateFileBizIdByIds(fileIdList, pilotSpecificSchedulePush.getId(), "ProjectResult");
        }
        return b;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<PilotSpecificSchedulePush> pilotSpecificSchedulePushList) {
        Assert.notNull(pilotSpecificSchedulePushList, "计划推进情况不能为空！");
        boolean b = super.saveOrUpdateBatch(pilotSpecificSchedulePushList);
        if(null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0){
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : pilotSpecificSchedulePushList){
                List<DefaultFile> defaultFileList = pilotSpecificSchedulePush.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String>  fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileIdList, pilotSpecificSchedulePush.getId(), "ProjectResult");
                }
            }
        }
        return b;
    }

    @Override
    public PilotSpecificSchedulePush getById(String id) {
        PilotSpecificSchedulePush pilotSpecificSchedulePush = super.get(id);
        if(null == pilotSpecificSchedulePush){
            throw new BaseException("数据不存在！");
        }
        if("1".equalsIgnoreCase(pilotSpecificSchedulePush.getIsDele())){
            throw new BaseException("数据已删除！");
        }
        pilotSpecificSchedulePush.setDefaultFileList(fileManager.queryFileByBizId(pilotSpecificSchedulePush.getId(), "ProjectResult"));
        return pilotSpecificSchedulePush;
    }


    @Override
    public List<PilotSpecificSchedulePush> queryNoPage(QueryFilter<PilotSpecificSchedulePush> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushes = super.queryNoPage(queryFilter);
        if (null != pilotSpecificSchedulePushes && pilotSpecificSchedulePushes.size() > 0) {
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : pilotSpecificSchedulePushes){
                pilotSpecificSchedulePush.setDefaultFileList(fileManager.queryFileByBizId(pilotSpecificSchedulePush.getId(), "ProjectResult"));
            }
        }
        return pilotSpecificSchedulePushes;
    }

    @Override
    public PageList<PilotSpecificSchedulePush> query(QueryFilter<PilotSpecificSchedulePush> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        PageList<PilotSpecificSchedulePush> result = super.query(queryFilter);
        List<PilotSpecificSchedulePush> records = result.getRows();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(PilotSpecificSchedulePush pilotSpecificSchedulePush : records){
                pilotSpecificSchedulePush.setDefaultFileList(fileManager.queryFileByBizId(pilotSpecificSchedulePush.getId(), "ProjectResult"));
            }
        }
        return result;
    }



    @Override
    public List<PilotSpecificSchedulePush> queryListByObjectivesMeasuresId(String objectivesMeasuresId) {
        // 数据信息
        List<PilotSpecificSchedulePush> pilotQuantitativeObjectivesPushList = super
                .list(new QueryWrapper<PilotSpecificSchedulePush>()
                        .eq("OBJECTIVES_MEASURES_ID_", objectivesMeasuresId).eq("IS_DELE_", "0"));
        // 附件信息
        if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0){
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : pilotQuantitativeObjectivesPushList){
                pilotSpecificSchedulePush.setDefaultFileList(fileManager.queryFileByBizId(pilotSpecificSchedulePush.getId(), "ProjectResult"));
            }
        }
        return pilotQuantitativeObjectivesPushList;
    }

    @Override
    @Transactional
    public void schedulePushSave(List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList) {
        Assert.notNull(pilotSpecificSchedulePushList, "进度计划推进情况不能为空！");
        super.saveOrUpdateBatch(pilotSpecificSchedulePushList);
        if(null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0){
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : pilotSpecificSchedulePushList){
                Assert.notNull(pilotSpecificSchedulePush.getProjectId(), "项目ID未设置，请先设置项目ID！");
                Assert.notNull(pilotSpecificSchedulePush.getObjectivesMeasuresId(), "进度计划ID未设置，请先设置进度计划ID！");
                List<DefaultFile> defaultFileList = pilotSpecificSchedulePush.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String>  fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileIdList, pilotSpecificSchedulePush.getId());
                }
            }
        }
    }

    @Override
    public void schedulePushSaveSaveAndCommit(List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList) {
        Assert.notNull(pilotSpecificSchedulePushList, "进度计划推进情况不能为空！");
        if(null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0){
            List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
            List<AchieveStatusLogAndAuditResultVo> logList = new ArrayList<>();
            super.saveOrUpdateBatch(pilotSpecificSchedulePushList);
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : pilotSpecificSchedulePushList){
                Assert.notNull(pilotSpecificSchedulePush.getProjectId(), "项目ID未设置，请先设置项目ID！");
                Assert.notNull(pilotSpecificSchedulePush.getObjectivesMeasuresId(), "进度计划ID未设置，请先设置进度计划ID！");

                List<DefaultFile> defaultFileList = pilotSpecificSchedulePush.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String>  fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileIdList, pilotSpecificSchedulePush.getId());
                }
                // 审批日志
                AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
                logVo.setBizId(pilotSpecificSchedulePush.getId());
                logVo.setModeType(6);
                logVo.setModuleTableName("BIZ_PILOT_SPECIFIC_SCHEDULE_PUSH");
                logVo.setItemTitle("市级重大改革项目【进度计划推进情况】提交");
                // 字典数据 shzt
                logVo.setStatus("1");
                logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, 1));
                logVo.setApprovalResults(0);
                logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
                logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
                logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
                logVo.setOperateUserId(ContextUtil.getCurrentUserId());
                logVo.setOperateUserName(ContextUtil.getCurrentUserName());
                logVo.setOperateDate(LocalDateTime.now());
                logVo.setModeType(0);
                logVo.setPriority(0);
                logList.add(logVo);
            }
            // 保存审批日志
            achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(logList);
        }
    }

    @Override
    public void schedulePushExamine(ObjectivesPushExamine schedulePushExamine) {
        Assert.notNull(schedulePushExamine, "推进情况审核数据不能为空！");
        Assert.notNull(schedulePushExamine.getIds(), "推进情况审核数据ID不能为空！");
        Assert.notNull(schedulePushExamine.getStatus(), "推进情况审核状态不能为空！");
        UpdateWrapper<PilotSpecificSchedulePush> pilotSpecificSchedulePushUpdateWrapper = new UpdateWrapper<>();
        pilotSpecificSchedulePushUpdateWrapper.set("STATUS_", schedulePushExamine.getStatus()).in("ID_", schedulePushExamine.getIds());
        this.update(pilotSpecificSchedulePushUpdateWrapper);

        QueryWrapper<PilotSpecificSchedulePush> pilotSpecificSchedulePushUpdateQuerWrapper = new QueryWrapper<>();
        pilotSpecificSchedulePushUpdateWrapper.in("ID_", schedulePushExamine.getIds());
        List<PilotSpecificSchedulePush> list = this.list(pilotSpecificSchedulePushUpdateQuerWrapper);
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
        List<AchieveStatusLogAndAuditResultVo> logList = new ArrayList<>();

        if(null != list && list.size() > 0){
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : list){
                // 审批日志
                AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
                // 如果全部审核通过，就计算出目标的最新完成率
                if(5 == schedulePushExamine.getStatus()) {
                    logVo.setFinish(true);
                    // 如果推进进度选择的已完成，并且审批通过，则将整个计划的状态更新为（已完成）
                    if(null != pilotSpecificSchedulePush.getProgressStatus() && pilotSpecificSchedulePush.getProgressStatus() == 3){
                        UpdateWrapper<PilotSpecificSchedule> pilotSpecificScheduleManagerUpdateWrapper = new UpdateWrapper<>();
                        pilotSpecificScheduleManagerUpdateWrapper.set("PROGRESS_STATUS_", 3).eq("ID_", pilotSpecificSchedulePush.getObjectivesMeasuresId());
                        pilotSpecificScheduleManager.update(pilotSpecificScheduleManagerUpdateWrapper);
                    }
                }else {
                    UpdateWrapper<PilotSpecificSchedule> pilotSpecificScheduleManagerUpdateWrapper = new UpdateWrapper<>();
                    pilotSpecificScheduleManagerUpdateWrapper.set("PROGRESS_STATUS_", 2).eq("ID_", pilotSpecificSchedulePush.getObjectivesMeasuresId());
                    pilotSpecificScheduleManager.update(pilotSpecificScheduleManagerUpdateWrapper);
                }
                logVo.setBizId(pilotSpecificSchedulePush.getId());
                logVo.setModeType(6);
                logVo.setModuleTableName("BIZ_PILOT_QUANTITATIVE_OBJECTIVES_PUSH");
                logVo.setItemTitle("市级重大改革项目改革方案【进度计划推进情况】审核");
                // 字典数据 shzt
                logVo.setStatus(String.valueOf(schedulePushExamine.getStatus()));
                logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, schedulePushExamine.getStatus()));
                logVo.setApprovalResults(0);
                logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
                logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
                logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
                logVo.setOperateUserId(ContextUtil.getCurrentUserId());
                logVo.setOperateUserName(ContextUtil.getCurrentUserName());
                logVo.setOperateDate(LocalDateTime.now());
                logVo.setModeType(0);
                logVo.setPriority(0);
                logVo.setApprovalComments(schedulePushExamine.getApprovalComments());
                logList.add(logVo);
            }
            // 保存审批日志
            achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(logList);
        }
    }

    @Override
    public PageList<SchedulePushExamineAndProjectVo> schedulePushListByPage(QueryFilter<PilotSpecificSchedulePush> queryFilter) {
        List<SchedulePushExamineAndProjectVo> listVo = new ArrayList<>();
        PageList<PilotSpecificSchedulePush> pageList = this.query(queryFilter);
        List<PilotSpecificSchedulePush> list = pageList.getRows();

        Map<String, MunicipalMajorProjectManagement> projectMap = new HashMap<>();
        Map<String, PilotSpecificSchedule> objectivesMap = new HashMap<>();

        if(null != list && list.size() > 0){
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : list) {
                SchedulePushExamineAndProjectVo vo = new SchedulePushExamineAndProjectVo();
                vo.setPilotSpecificSchedulePush(pilotSpecificSchedulePush);
                // 进度计划
                String objectivesMeasuresId = pilotSpecificSchedulePush.getObjectivesMeasuresId();
                PilotSpecificSchedule pilotSpecificSchedule = objectivesMap.get(objectivesMeasuresId);
                if(null == pilotSpecificSchedule){
                    pilotSpecificSchedule = pilotSpecificScheduleManager.get(objectivesMeasuresId);
                    objectivesMap.put(objectivesMeasuresId, pilotSpecificSchedule);
                }
                vo.setPilotSpecificSchedule(pilotSpecificSchedule);
                // 重大项目信息
                String projectId = "";
                if(null != pilotSpecificSchedule){
                    projectId = pilotSpecificSchedule.getProjectId();
                }
                if(StringUtils.isBlank(projectId)){
                    projectId = pilotSpecificSchedulePush.getProjectId();
                }
                MunicipalMajorProjectManagement municipalMajorProjectManagement = projectMap.get(projectId);
                if(null == municipalMajorProjectManagement){
                    municipalMajorProjectManagement = municipalMajorProjectManagementManager.get(projectId);
                    projectMap.put(projectId, municipalMajorProjectManagement);
                }
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                listVo.add(vo);
            }
        }
        PageList<SchedulePushExamineAndProjectVo> result = new PageList<>();
        result.setRows(listVo);
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        return result;
    }

    @Override
    public PageList<QuantitativeObjectivesPushFillQueryVo> scheduleAndMeasurePushListByPage(QueryFilter<PilotProjectFill> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("FLOW_TYPE_", 2, QueryOP.EQUAL);
        return pilotProjectFillManager.queyrQuantitativeObjectivesPushFillList(queryFilter);
    }

    @Override
    public List<PilotSpecificSchedulePush> queryListByFillId(String id) {
        QueryWrapper<PilotSpecificSchedulePush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("FILL_ID_", id).eq("IS_DELE_", 0);
        List<PilotSpecificSchedulePush> list = this.list(queryWrapper);
        // 附件信息
        if (null != list && list.size() > 0){
            for (PilotSpecificSchedulePush pilotSpecificSchedulePush : list){
                pilotSpecificSchedulePush.setDefaultFileList(fileManager.queryFileByBizId(pilotSpecificSchedulePush.getId(), "ProjectResult"));
            }
        }
        return list;
    }

    @Override
    @Transactional
    public void pilotSpecificSchedulePushAndMeasurePushExamine(FillPushExamineVo fillPushExamineVo) {
        Assert.notNull(fillPushExamineVo, "审核数据不能为空");
        Assert.notNull(fillPushExamineVo.getId(), "审核填报数据不能为空");
        Assert.notNull(fillPushExamineVo.getStatus(), "审核数据状态不能为空");
//        pilotProjectFillManager.examineVo(fillPushExamineVo);
        // 更新计划子表审核状态
        PilotProjectFill pilotProjectFill = new PilotProjectFill();
        pilotProjectFill.setId(fillPushExamineVo.getId());
        pilotProjectFill.setStatus(fillPushExamineVo.getStatus());
        pilotProjectFill.setApprovalResults(fillPushExamineVo.getApprovalResults());
        pilotProjectFill.setFlowType(fillPushExamineVo.getFlowType());
        if (BeanUtils.isNotEmpty(fillPushExamineVo.getProjectId()))pilotProjectFill.setProjectId(fillPushExamineVo.getProjectId());
        //记录操作日志
        pilotProjectFillManager.createLog(pilotProjectFill,fillPushExamineVo.getTitle());
        // 计划审核状态
        pilotMeasuresPushManager.updateStatusByProjectFill(pilotProjectFill);
        //当执行撤回操作时
//        if (BeanUtils.isNotEmpty(pilotProjectFill.getApprovalResults())&&pilotProjectFill.getApprovalResults()==2&&pilotProjectFill.getStatus()==3){
//            List<PilotMeasuresPush> list = pilotMeasuresPushManager.list(new QueryWrapper<PilotMeasuresPush>().eq("FILL_ID_", pilotProjectFill.getId()));
//            if (BeanUtils.isNotEmpty(list)){
//                List<LocalDateTime> times = list.stream().map(PilotMeasuresPush::getCreateTime).collect(Collectors.toList());
//                UpdateWrapper<PilotSpecificSchedule> updateWrapper=new UpdateWrapper<>();
//                updateWrapper.eq("PROJECT_ID_",pilotProjectFill.getProjectId())
//                        .in("ACTUAL_COMPLETION_TIME",times)
//                        .eq("IS_DELE_","0")
//                        .set("PROGRESS_STATUS_",null);
//
//                updateWrapper.set("ACTUAL_COMPLETION_TIME",pilotMeasuresPush.getCreateTime());
//            }
//        }
        //修改审核状态
        UpdateWrapper<PilotProjectFill> updateWrapper=new UpdateWrapper<>();
        updateWrapper.eq("ID_",fillPushExamineVo.getId())
                     .eq("IS_DELE_","0")
                     .set("STATUS_",fillPushExamineVo.getStatus());
        pilotProjectFillManager.update(updateWrapper);

    }

    @Override
    @Transactional
    public void pilotSpecificSchedulePushAndMeasurePushSaveCommit(PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo) {
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo, "推进情况数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotMeasuresPushList(), "项目改革方案明确的计划推进情况数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill(), "填报数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill().getProjectId(), "填报数据项目ID不能为空！");
        PilotProjectFill pilotProjectFill = pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill();
        if(pilotProjectFill == null){
            pilotProjectFill = new PilotProjectFill();
        }
        if(pilotProjectFill.getFillDate() == null ){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue()-1)/3+1;
        pilotProjectFill.setFillQuarter(quarter);
        if(StringUtils.isBlank(pilotProjectFill.getUnitId())){
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(1);
        pilotProjectFill.setFlowType(2);
        //判断开关
        PilotProjectFill entity = pilotProjectFillManager.getById(pilotProjectFill.getId());
        boolean check=BeanUtils.isEmpty(pilotProjectFill.getId())||entity.getStatus()!=pilotProjectFill.getStatus();
        // 保存填报信息
        this.pilotProjectFillManager.saveOrUpdate(pilotProjectFill);
        //当满足条件才记录
        if (check)pilotProjectFillManager.createLog(pilotProjectFill, "市级重大项目月度计划推进");
        // 保存项目改革方案明确的计划推进情况
        List<PilotMeasuresPush> pilotMeasuresPushList = pilotSpecificSchedulePushAndMeasurePushVo.getPilotMeasuresPushList();
        for(PilotMeasuresPush p : pilotMeasuresPushList){
            String projectId = p.getProjectId();
            String measuresId = p.getMeasuresId();
            if(StringUtils.isBlank(projectId)){
                p.setProjectId(pilotProjectFill.getProjectId());
            }
            // 未完成的并且是审核中的数据才修改状态
            if(!(p.getStatus() != null && "1".equalsIgnoreCase(p.getIsOver()) && p.getStatus() == 5)){
                p.setStatus(pilotProjectFill.getStatus());
            }
            Assert.notNull(measuresId, "改革方案明确的计划ID未设置，请先设置计划ID！");
            p.setFillId(pilotProjectFill.getId());
            p.setIsDelete("0");
            pilotMeasuresPushManager.saveOrUpdate(p);
        }

        // 保存其他改革成果（明细推进情况集合）
        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotSpecificSchedulePushAndMeasurePushVo.getPilotSpecificSchedulePushList();
        if(null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0){
            for(PilotSpecificSchedulePush p : pilotSpecificSchedulePushList){
                String projectId = p.getProjectId();
                if(StringUtils.isBlank(projectId)){
                    p.setProjectId(pilotProjectFill.getProjectId());
                }
                if(p.getStatus() == null || p.getStatus() < 5){
                    p.setStatus(pilotProjectFill.getStatus());
                }
                p.setIsDele("0");
                p.setFillId(pilotProjectFill.getId());
            }
            this.saveOrUpdateBatch(pilotSpecificSchedulePushList);
        }

    }

    @Override
    @Transactional
    public void pilotSpecificSchedulePushAndMeasurePushSave(PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo) {
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo, "推进情况数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotMeasuresPushList(), "项目改革方案明确的计划推进情况数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill(), "填报数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill().getProjectId(), "填报数据项目ID不能为空！");
        PilotProjectFill pilotProjectFill = pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill();
        if(pilotProjectFill == null){
            pilotProjectFill = new PilotProjectFill();
        }
        if(pilotProjectFill.getFillDate() == null ){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue()-1)/3+1;
        pilotProjectFill.setFillQuarter(quarter);
        if(StringUtils.isBlank(pilotProjectFill.getUnitId())){
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(0);
        pilotProjectFill.setFlowType(2);
        //判断是否存在
        PilotProjectFill entity = pilotProjectFillManager.getById(pilotProjectFill.getId());
        boolean check= BeanUtils.isEmpty(pilotProjectFill.getId())||entity.getStatus()!=pilotProjectFill.getStatus();
        // 保存填报信息
        this.pilotProjectFillManager.saveOrUpdate(pilotProjectFill);
        //当新增时,才新增操作记录
        if (check) pilotProjectFillManager.createLog(pilotProjectFill, "市级重大项目月度计划推进");
        // 保存项目改革方案明确的计划推进情况
        List<PilotMeasuresPush> pilotMeasuresPushList = pilotSpecificSchedulePushAndMeasurePushVo.getPilotMeasuresPushList();
        for(PilotMeasuresPush p : pilotMeasuresPushList){
            String projectId = p.getProjectId();
            String measuresId = p.getMeasuresId();
            if(StringUtils.isBlank(projectId)){
                p.setProjectId(pilotProjectFill.getProjectId());
            }
            // 未完成的并且是审核中的数据才修改状态
            if(!(p.getStatus() != null && "1".equalsIgnoreCase(p.getIsOver()) && p.getStatus() == 5)){
                p.setStatus(pilotProjectFill.getStatus());
            }
            Assert.notNull(measuresId, "改革方案明确的计划ID未设置，请先设置计划ID！");
            p.setFillId(pilotProjectFill.getId());
            p.setIsDelete("0");
            pilotMeasuresPushManager.saveOrUpdate(p);
        }
//        pilotMeasuresPushManager.saveOrUpdateBatch(pilotMeasuresPushList);
        // 保存其他改革成果（明细推进情况集合）
        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotSpecificSchedulePushAndMeasurePushVo.getPilotSpecificSchedulePushList();
        if(null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0){
            for(PilotSpecificSchedulePush p : pilotSpecificSchedulePushList){
                String projectId = p.getProjectId();
                if(StringUtils.isBlank(projectId)){
                    p.setProjectId(pilotProjectFill.getProjectId());
                }
                if(p.getStatus() == null || p.getStatus() < 5){
                    p.setStatus(pilotProjectFill.getStatus());
                }
                p.setFillId(pilotProjectFill.getId());
                p.setIsDele("0");
            }
            this.saveOrUpdateBatch(pilotSpecificSchedulePushList);
        }

    }

    @Override
    public void pilotSpecificSchedulePushAndMeasurePushUpdate(PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo) {
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo, "推进情况数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotMeasuresPushList(), "项目改革方案明确的计划推进情况数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill(), "填报数据不能为空！");
        Assert.notNull(pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill().getProjectId(), "填报数据项目ID不能为空！");
        PilotProjectFill pilotProjectFill = pilotSpecificSchedulePushAndMeasurePushVo.getPilotProjectFill();
        UpdateWrapper<PilotProjectFill> update = new UpdateWrapper<PilotProjectFill>()
                .set("STATUS_", pilotProjectFill.getStatus())
                .eq("ID_", pilotProjectFill.getId());
        pilotMeasuresPushManager.updateStatusByProjectFill(pilotProjectFill);
        this.updateStatusByProjectFill(pilotProjectFill);
        //判断本次修改的值是否与上传相等
        PilotProjectFill entity = this.pilotProjectFillManager.getById(pilotProjectFill.getId());
        boolean check=entity.getStatus()==pilotProjectFill.getStatus();
        // 保存填报信息
        this.pilotProjectFillManager.update(update);
        //根据条件录入操作日志
        if (!check)pilotProjectFillManager.createLog(pilotProjectFill,"市级重大项目月度计划推进");
        // 保存项目改革方案明确的计划推进情况
        List<PilotMeasuresPush> pilotMeasuresPushList = pilotSpecificSchedulePushAndMeasurePushVo.getPilotMeasuresPushList();
        for(PilotMeasuresPush p : pilotMeasuresPushList){
            String projectId = p.getProjectId();
            String measuresId = p.getMeasuresId();
            if(StringUtils.isBlank(projectId)){
                p.setProjectId(pilotProjectFill.getProjectId());
            }
            // 未完成的并且是审核中的数据才修改状态
            if(!(p.getStatus() != null && "1".equalsIgnoreCase(p.getIsOver()) && p.getStatus() == 5)){
                p.setStatus(pilotProjectFill.getStatus());
            }
            Assert.notNull(measuresId, "改革方案明确的计划ID未设置，请先设置计划ID！");
            p.setFillId(pilotProjectFill.getId());
            p.setIsDelete("0");
        }
        pilotMeasuresPushManager.saveOrUpdateBatch(pilotMeasuresPushList);
        //更新推进状态
        for (PilotMeasuresPush p : pilotMeasuresPushList) {
            if (p.getStatus()==5){
                UpdateWrapper<PilotSpecificSchedule> updateWrapper=new UpdateWrapper<>();
                updateWrapper.eq("ID_",p.getMeasuresId())
                        .eq("IS_DELE_","0")
                        .isNull("ACTUAL_COMPLETION_TIME")
                        .set("PROGRESS_STATUS_",p.getIsOver());
                if (p.getIsOver().equals("3")){
                    PilotMeasuresPush pilotMeasuresPush = pilotMeasuresPushManager.getById(p.getId());
                    updateWrapper.set("ACTUAL_COMPLETION_TIME",pilotMeasuresPush.getCreateTime());
                }
                pilotSpecificScheduleManager.update(updateWrapper);
            }
        }
        // 保存其他改革成果（明细推进情况集合）
        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotSpecificSchedulePushAndMeasurePushVo.getPilotSpecificSchedulePushList();
        if(null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0){
            for(PilotSpecificSchedulePush p : pilotSpecificSchedulePushList){
                String projectId = p.getProjectId();
                if(StringUtils.isBlank(projectId)){
                    p.setProjectId(pilotProjectFill.getProjectId());
                }
                if(p.getStatus() == null || p.getStatus() < 5){
                    p.setStatus(pilotProjectFill.getStatus());
                }
                p.setFillId(pilotProjectFill.getId());
                p.setIsDele("0");

            }
            this.saveOrUpdateBatch(pilotSpecificSchedulePushList);
        }

    }

    @Override
    public PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo getDetails(String id) {
        Assert.notNull(id, "条件格式不能为空");
        PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo pilotProjectFillQueryVo = new PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo();
        PilotProjectFill pilotProjectFill = pilotProjectFillManager.get(id);
        pilotProjectFillQueryVo.setPilotProjectFill(pilotProjectFill);
        if (null != pilotProjectFill) {
            if (pilotProjectFill.getStatus() == 2 || pilotProjectFill.getStatus() == 4) {
                //驳回查询驳回意见
                AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(pilotProjectFill.getId(), pilotProjectFill.getStatus());
                pilotProjectFill.setApprovalComments(log.getApprovalComments());
            }
            // 1.項目信息
            MunicipalMajorProjectManagement municipalMajorProjectManagement = municipalMajorProjectManagementManager
                    .getMunicipalMajorProjectManagement(pilotProjectFill.getProjectId());
            pilotProjectFillQueryVo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
             // 2.改革方案明确的月度计划推进详情包括月度计划信息，包括具体季度的计划
            List<PilotMeasuresPushVo> pilotMeasuresPushList = pilotMeasuresPushManager.queryListByFillId(pilotProjectFill.getId(),pilotProjectFill.getProjectId(),"false");
            pilotProjectFillQueryVo.setPilotMeasuresPushList(pilotMeasuresPushList);
            // 按照月度处理月度计划数据
            List<Map<String, List<PilotMeasuresPushVo>>> pilotSpecificScheduleQuarterList = new ArrayList<>();
            if (null != pilotMeasuresPushList && pilotMeasuresPushList.size() > 0) {
                Map<String, List<PilotMeasuresPushVo>> map = new LinkedHashMap<>();
                for (PilotMeasuresPushVo vo : pilotMeasuresPushList) {
                    String planMonth = String.valueOf(vo.getPlanMonth());
                    List<PilotMeasuresPushVo> pilotMeasuresPushVos = map.get(planMonth);
                    if (null == pilotMeasuresPushVos) {
                        pilotMeasuresPushVos = new ArrayList<>();
                        pilotMeasuresPushVos.add(vo);
                        map.put(planMonth, pilotMeasuresPushVos);
                    } else {
                        pilotMeasuresPushVos.add(vo);
                        map.put(planMonth, pilotMeasuresPushVos);
                    }
                }
                if (null != map && map.size() > 0) {
                    for (String key : map.keySet()) {
                        Map<String, List<PilotMeasuresPushVo>> subMap = new LinkedHashMap<>();
                        subMap.put(key, map.get(key));
                        pilotSpecificScheduleQuarterList.add(subMap);
                    }
                }
            }
            pilotProjectFillQueryVo.setPilotMeasuresPushQuarterList(pilotSpecificScheduleQuarterList);
            /*// 3.其他改革成果（进度计划明细推进情况）集合
            List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = this
                    .queryListByFillId(pilotProjectFill.getId());
            pilotProjectFillQueryVo.setPilotSpecificSchedulePushList(pilotSpecificSchedulePushList);

            // 4. 历史审核数据
            PilotProjectFill historyPilotProjectFill = pilotProjectFillManager.getHistoryPilotProjectFill(pilotProjectFill.getProjectId(), 2);
            pilotProjectFillQueryVo.setPilotProjectFillHistory(historyPilotProjectFill);
            if(null != historyPilotProjectFill){
                // 4.1.历史-改革方案明确的月度计划推进详情包括月度计划信息集合
                List<PilotMeasuresPushVo> pilotMeasuresPushHistoryList = pilotMeasuresPushManager.queryListByFillId(pilotProjectFill.getId(),pilotProjectFill.getProjectId(),"true");
                pilotProjectFillQueryVo.setPilotMeasuresPushHistoryList(pilotMeasuresPushHistoryList);
                // 4.2 历史-改革方案明确的月度计划推进详情包括月度计划信息集合（按照季度处理后的数据）
                List<Map<String, List<PilotMeasuresPushVo>>> pilotMeasuresPushQuarterHistoryList = new ArrayList<>();
                if (null != pilotMeasuresPushHistoryList && pilotMeasuresPushHistoryList.size() > 0) {
                    Map<String, List<PilotMeasuresPushVo>> map = new LinkedHashMap<>();
                    for (PilotMeasuresPushVo vo : pilotMeasuresPushHistoryList) {
                        String planQuarter = String.valueOf(vo.getPlanQuarter());
                        List<PilotMeasuresPushVo> pilotMeasuresPushVos = map.get(planQuarter);
                        if (null == pilotMeasuresPushVos) {
                            pilotMeasuresPushVos = new ArrayList<>();
                            pilotMeasuresPushVos.add(vo);
                            map.put(planQuarter, pilotMeasuresPushVos);
                        } else {
                            pilotMeasuresPushVos.add(vo);
                            map.put(planQuarter, pilotMeasuresPushVos);
                        }
                    }
                    if (null != map && map.size() > 0) {
                        for (String key : map.keySet()) {
                            Map<String, List<PilotMeasuresPushVo>> subMap = new LinkedHashMap<>();
                            subMap.put(key, map.get(key));
                            pilotMeasuresPushQuarterHistoryList.add(subMap);
                        }
                    }
                }
                pilotProjectFillQueryVo.setPilotMeasuresPushQuarterHistoryList(pilotMeasuresPushQuarterHistoryList);
                // 4.2.历史-其他改革成果（进度计划明细推进情况）集合
                List<PilotSpecificSchedulePush> pilotSpecificSchedulePushHistoryList = this
                        .queryListByFillId(pilotProjectFill.getId());
                pilotProjectFillQueryVo.setPilotSpecificSchedulePushHistoryList(pilotSpecificSchedulePushHistoryList);
            }*/
        }

        return pilotProjectFillQueryVo;
    }

    @Override
    public PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo getHisDetails(String projectId) {
        Assert.notNull(projectId, "项目ID不能为空");
        PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo pilotProjectFillQueryVo = new PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo();
        // 4. 历史审核数据
        PilotProjectFill historyPilotProjectFill = pilotProjectFillManager.getHistoryPilotProjectFill(projectId, 2);
        if(null != historyPilotProjectFill){
            if (historyPilotProjectFill.getStatus() == 2 || historyPilotProjectFill.getStatus() == 4) {
                //驳回查询驳回意见
                AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(historyPilotProjectFill.getId(), historyPilotProjectFill.getStatus());
                historyPilotProjectFill.setApprovalComments(log.getApprovalComments());
            }
            // 4.1.历史-改革方案明确的月度计划推进详情包括月度计划信息集合
            List<PilotMeasuresPushVo> pilotMeasuresPushHistoryList = pilotMeasuresPushManager.queryListByFillId(historyPilotProjectFill.getId(),historyPilotProjectFill.getProjectId(),"true");
            pilotProjectFillQueryVo.setPilotMeasuresPushHistoryList(pilotMeasuresPushHistoryList);
        }
        pilotProjectFillQueryVo.setPilotProjectFillHistory(historyPilotProjectFill);
        return pilotProjectFillQueryVo;
    }

    @Override
    public void pilotSpecificSchedulePushCommit(String id) {
        Assert.notNull(id, "填报ID不能为空！");
        PilotProjectFill pilotProjectFill = pilotProjectFillManager.get(id);
        if(pilotProjectFill == null){
            throw new BaseException("未查询到相关填报数据，请刷新后重试！");
        }
        if(pilotProjectFill.getFillDate() == null ){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue()-1)/3+1;
        pilotProjectFill.setFillQuarter(quarter);
        if(StringUtils.isBlank(pilotProjectFill.getUnitId())){
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(1);
        pilotProjectFill.setFlowType(2);
        // 保存填报信息
        this.pilotProjectFillManager.saveOrUpdate(pilotProjectFill);
        // 更新计划子表审核状态
        pilotMeasuresPushManager.updateStatusByProjectFill(pilotProjectFill);
        // 更新其他改革成果审核状态
        pilotMeasuresPushManager.updateStatusByProjectFill(pilotProjectFill);
        this.updateStatusByProjectFill(pilotProjectFill);

        pilotProjectFillManager.createLog(pilotProjectFill,"市级重大项目月度计划推进");
    }

    @Override
    public void updateStatusByProjectFill(PilotProjectFill pilotProjectFill) {
        if(null == pilotProjectFill || StringUtils.isBlank(pilotProjectFill.getId())){
            return;
        }
        String fillId = pilotProjectFill.getId();
        Integer status = pilotProjectFill.getStatus();
        QueryWrapper<PilotSpecificSchedulePush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("FILL_ID_", fillId).eq("IS_DELE_", 0);

        List<PilotSpecificSchedulePush> list = this.list(queryWrapper);
        if(null != list && list.size() > 0){
            List<String> ids = new ArrayList<>();
            for (PilotSpecificSchedulePush p : list){
                if(p.getStatus() == null || p.getStatus() < 5){
                    ids.add(p.getId());
                }
            }
            if(null != ids && ids.size() > 0){
                UpdateWrapper<PilotSpecificSchedulePush> updateWrapper = new UpdateWrapper<>();
                updateWrapper.set("STATUS_", status);
                updateWrapper.in("ID_", ids);
                this.update(updateWrapper);
            }
        }

    }


    @Override
    public int countPilotSpecificSchedulePush(String id) {
        Assert.notNull(id, "计划ID不能为空");
        QueryWrapper<PilotSpecificSchedulePush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("OBJECTIVES_MEASURES_ID_", id).eq("IS_DELE_", 0);
        return this.count(queryWrapper);
    }
}
