package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.majorProjects.dao.PilotSpecificSchedulePushDao;
import com.artfess.reform.majorProjects.manager.*;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.dao.PilotQuantitativeObjectivesPushDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.vo.*;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 改革方案量化目标j进度计划推进情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Service
public class PilotQuantitativeObjectivesPushManagerImpl extends BaseManagerImpl<PilotQuantitativeObjectivesPushDao, PilotQuantitativeObjectivesPush> implements PilotQuantitativeObjectivesPushManager {


    @Resource
    private PilotQuantitativeObjectivesManager pilotQuantitativeObjectivesManager;

    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Resource
    private PilotObjectivesDetailsManager pilotObjectivesDetailsManager;

    @Resource
    private SysDictionaryManager sysDictionaryManager;

    @Resource
    private PilotSpecificSchedulePushDao pilotSpecificSchedulePushDao;

    @Resource
    private PilotProjectFillManager pilotProjectFillManager;

    @Override
    public void objectivesPushSave(List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList) {
        Assert.notNull(pilotQuantitativeObjectivesPushList, "推进情况数据不能为空！");
        pilotQuantitativeObjectivesPushList.stream().forEach(p->{
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            Assert.notNull(projectId, "项目ID未设置，请先设置项目ID！");
            Assert.notNull(objectivesMeasuresId, "进度计划ID未设置，请先设置进度计划ID！");
            LocalDate pushDate = p.getPushDate();
            p.setPushDate(pushDate);
        });
        this.saveBatch(pilotQuantitativeObjectivesPushList);
    }

    @Override
    public void objectivesPushSaveSaveAndCommit(List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList) {
        Assert.notNull(pilotQuantitativeObjectivesPushList, "推进情况数据不能为空！");
        pilotQuantitativeObjectivesPushList.stream().forEach(p->{
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            Assert.notNull(projectId, "项目ID未设置，请先设置项目ID！");
            Assert.notNull(objectivesMeasuresId, "进度I计划D未设置，请先设置进度计划ID！");
        });
        // 保存审批数据
        this.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
        List<AchieveStatusLogAndAuditResultVo> logList = new ArrayList<>();
        pilotQuantitativeObjectivesPushList.stream().forEach(p->{
            // 审批日志
            AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
            logVo.setBizId(p.getId());
            logVo.setModeType(6);
            logVo.setModuleTableName("BIZ_PILOT_QUANTITATIVE_OBJECTIVES_PUSH");
            logVo.setItemTitle("市级重大改革项目【改革方案量化目标推进情况】提交");
            // 字典数据 shzt
            logVo.setStatus("1");
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, 1));
            logVo.setApprovalResults(0);
            logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
            logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
            logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
            logVo.setOperateUserId(ContextUtil.getCurrentUserId());
            logVo.setOperateUserName(ContextUtil.getCurrentUserName());
            logVo.setOperateDate(LocalDateTime.now());
            logVo.setModeType(0);
            logVo.setPriority(0);
            logList.add(logVo);
        });
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(logList);
    }

    @Override
    public void objectivesPushExamine(ObjectivesPushExamine objectivesPushExamine) {
        Assert.notNull(objectivesPushExamine, "推进情况审核数据不能为空！");
        Assert.notNull(objectivesPushExamine.getIds(), "推进情况审核数据ID不能为空！");
        Assert.notNull(objectivesPushExamine.getStatus(), "推进情况审核状态不能为空！");
        UpdateWrapper<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushUpdateWrapper = new UpdateWrapper<>();
        pilotQuantitativeObjectivesPushUpdateWrapper.set("STATUS_", objectivesPushExamine.getStatus()).in("ID_", objectivesPushExamine.getIds());
        this.update(pilotQuantitativeObjectivesPushUpdateWrapper);
        QueryWrapper<PilotQuantitativeObjectivesPush>  queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id_", objectivesPushExamine.getIds());
        List<PilotQuantitativeObjectivesPush> list = this.list(queryWrapper);

        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
        List<AchieveStatusLogAndAuditResultVo> logList = new ArrayList<>();
        if(null != list && list.size() > 0){
            for (PilotQuantitativeObjectivesPush pilotQuantitativeObjectivesPush : list){
                // 量化目标ID
                String objectivesMeasuresId = pilotQuantitativeObjectivesPush.getObjectivesMeasuresId();
                PilotQuantitativeObjectives pilotQuantitativeObjectives = pilotQuantitativeObjectivesManager.get(objectivesMeasuresId);
                // 审批日志
                AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
                // 如果全部审核通过，就计算出目标的最新完成率
                if(5 == objectivesPushExamine.getStatus()) {
                    // 1.查询当前推进时间的年度目标值
                    LocalDate pushDate = pilotQuantitativeObjectivesPush.getPushDate();
                    if(null != pushDate){
                        QueryWrapper<PilotObjectivesDetails> pilotObjectivesDetailsQueryWrapper = new QueryWrapper<>();
                        pilotObjectivesDetailsQueryWrapper.eq("YEAR_", pushDate.getYear()).eq("OBJECTIVES_ID_", objectivesMeasuresId);
                        List<PilotObjectivesDetails> pilotObjectivesDetailsList = pilotObjectivesDetailsManager.list(pilotObjectivesDetailsQueryWrapper);
                        if(null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0){
                            PilotObjectivesDetails pilotObjectivesDetails = pilotObjectivesDetailsList.get(0);
                            BigDecimal yearValue = pilotObjectivesDetails.getYearValue();
                            if(null != yearValue && pilotQuantitativeObjectivesPush.getPushProgress() != null){
                                if(yearValue.compareTo(BigDecimal.ZERO) == 0){
                                    pilotQuantitativeObjectives.setComplianceRate(BigDecimal.ZERO);
                                }else {
                                    // 最新完成率 = 当前完成目标值 ÷ 年度目标值
                                    BigDecimal complianceRate = pilotQuantitativeObjectivesPush.getPushProgress()
                                            .divide(yearValue, 4, BigDecimal.ROUND_HALF_UP);
//                                    pilotQuantitativeObjectives.setComplianceRate(complianceRate.stripTrailingZeros());

                                    // 更新最新完成率、当前最新完成值、最新状态（已完成）
                                    UpdateWrapper<PilotQuantitativeObjectives> pilotQuantitativeObjectivesUpdateWrapper = new UpdateWrapper<>();
                                    pilotQuantitativeObjectivesUpdateWrapper.set("COMPLIANCE_RATE_", complianceRate.stripTrailingZeros())
                                            .set("REFORM_QUANTITATIVE_OBJECTIVES_VALUE_",  pilotQuantitativeObjectivesPush.getPushProgress());
                                    if(pilotQuantitativeObjectivesPush.getPushProgress().compareTo(yearValue) == 0
                                            || pilotQuantitativeObjectivesPush.getPushProgress().compareTo(yearValue) > 0){
                                        pilotQuantitativeObjectivesUpdateWrapper.set("PROGRESS_STATUS_", 3);
                                    }
                                    pilotQuantitativeObjectivesUpdateWrapper.eq("ID_", pilotQuantitativeObjectives.getId());
                                    pilotQuantitativeObjectivesManager.update(pilotQuantitativeObjectivesUpdateWrapper);

                                }
                            }
                        }
                    }
                    // 设置审批为完成状态
                    logVo.setFinish(true);
                }else {
                    // 更新目标状态（进行中）
                    UpdateWrapper<PilotQuantitativeObjectives> pilotQuantitativeObjectivesUpdateWrapper = new UpdateWrapper<>();
                    pilotQuantitativeObjectivesUpdateWrapper.set("PROGRESS_STATUS_", 2).eq("ID_", pilotQuantitativeObjectives.getId());
                    pilotQuantitativeObjectivesManager.update(pilotQuantitativeObjectivesUpdateWrapper);
                }
                logVo.setBizId(pilotQuantitativeObjectivesPush.getId());
                logVo.setModeType(6);
                logVo.setModuleTableName("BIZ_PILOT_QUANTITATIVE_OBJECTIVES_PUSH");
                logVo.setItemTitle("市级重大改革项目【改革方案量化目标推进情况】审核");
                // 字典数据 shzt
                logVo.setStatus(String.valueOf(objectivesPushExamine.getStatus()));
                logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, objectivesPushExamine.getStatus()));
                logVo.setApprovalResults(0);
                logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
                logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
                logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
                logVo.setOperateUserId(ContextUtil.getCurrentUserId());
                logVo.setOperateUserName(ContextUtil.getCurrentUserName());
                logVo.setOperateDate(LocalDateTime.now());
                logVo.setModeType(0);
                logVo.setPriority(0);
                logVo.setApprovalComments(objectivesPushExamine.getApprovalComments());
                logList.add(logVo);
            }
            // 保存审批日志
            achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(logList);
        }

    }

    @Override
    public PageList<ObjectivesPushExamineAndProjectVo> objectivesPushListByPage(QueryFilter<PilotQuantitativeObjectivesPush> queryFilter) {
        List<ObjectivesPushExamineAndProjectVo> listVo = new ArrayList<>();
        PageList<PilotQuantitativeObjectivesPush> pageList = this.query(queryFilter);
        List<PilotQuantitativeObjectivesPush> list = pageList.getRows();

        Map<String, MunicipalMajorProjectManagement> projectMap = new HashMap<>();
        Map<String, PilotQuantitativeObjectives> objectivesMap = new HashMap<>();

        if(null != list && list.size() > 0){
            for (PilotQuantitativeObjectivesPush pilotQuantitativeObjectivesPush : list) {
                ObjectivesPushExamineAndProjectVo vo = new ObjectivesPushExamineAndProjectVo();
                vo.setPilotQuantitativeObjectivesPush(pilotQuantitativeObjectivesPush);
                // 量化目标
                String objectivesMeasuresId = pilotQuantitativeObjectivesPush.getObjectivesMeasuresId();
                PilotQuantitativeObjectives pilotQuantitativeObjectives = objectivesMap.get(objectivesMeasuresId);
                if(null == pilotQuantitativeObjectives){
                    pilotQuantitativeObjectives = pilotQuantitativeObjectivesManager.get(objectivesMeasuresId);
                    // 查询本年度的量化目标-
                    QueryWrapper<PilotObjectivesDetails> pilotObjectivesDetailsQueryWrapper = new QueryWrapper<>();
                    pilotObjectivesDetailsQueryWrapper.eq("YEAR_", LocalDate.now().getYear()).eq("OBJECTIVES_ID_", objectivesMeasuresId);
                    List<PilotObjectivesDetails> pilotObjectivesDetailsList = pilotObjectivesDetailsManager.list(pilotObjectivesDetailsQueryWrapper);
                    if(null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0) {
                        pilotQuantitativeObjectives.setReformQuantitativeObjectives(pilotObjectivesDetailsList.get(0)
                                .getYearValue().toPlainString());
                    }
                    objectivesMap.put(objectivesMeasuresId, pilotQuantitativeObjectives);
                }
                vo.setPilotQuantitativeObjectives(pilotQuantitativeObjectives);
                // 重大项目信息
                String projectId = "";
                if(null != pilotQuantitativeObjectives){
                    projectId = pilotQuantitativeObjectives.getProjectId();
                }
                if(StringUtils.isBlank(projectId)){
                    projectId = pilotQuantitativeObjectivesPush.getProjectId();
                }
                MunicipalMajorProjectManagement municipalMajorProjectManagement = projectMap.get(projectId);
                if(null == municipalMajorProjectManagement){
                    municipalMajorProjectManagement = municipalMajorProjectManagementManager.get(projectId);
                    projectMap.put(projectId, municipalMajorProjectManagement);
                }
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                listVo.add(vo);
            }
        }
        PageList<ObjectivesPushExamineAndProjectVo> result = new PageList<>();
        result.setRows(listVo);
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        return result;
    }

    @Override
    public List<PilotQuantitativeObjectivesPushVo> queryListByFillId(String fileId,String projectId,String isHis) {
//        QueryWrapper<PilotQuantitativeObjectivesPush> queryWrapper = new QueryWrapper();
//        queryWrapper.eq("FILL_ID_", id).eq("IS_DELE_", 0);
//        List<PilotQuantitativeObjectivesPush> list = this.list(queryWrapper);
        return pilotSpecificSchedulePushDao.queryListByFillId(fileId,projectId,isHis);
    }

    @Override
    public List<PilotQuantitativeTargetListVo> queryTargetListByFillYearMonth(Integer fillYear, Integer fillMonth) {
        String monthValueFieldName="";
        if(fillMonth>12 || fillMonth<1){
            Calendar calendar = Calendar.getInstance();
            fillMonth = calendar.get(Calendar.MONTH) + 1;
        }
        if(fillYear==null){
            Calendar calendar = Calendar.getInstance();
            fillYear = calendar.get(Calendar.YEAR) ;
        }
        if(fillMonth==1){
            monthValueFieldName ="JAN_VALUE_";
       }else if(fillMonth==2){
            monthValueFieldName ="FEB_VALUE_";
        }else if(fillMonth==3){
            monthValueFieldName ="MAR_VALUE_";
        }else if(fillMonth==4){
            monthValueFieldName ="APR_VALUE_";
        }else if(fillMonth==5){
            monthValueFieldName ="MAY_VALUE_";
        }else if(fillMonth==6){
            monthValueFieldName ="JUN_VALUE_";
        }else if(fillMonth==7){
            monthValueFieldName ="JUL_VALUE_";
        }else if(fillMonth==8){
            monthValueFieldName ="AUG_VALUE_";
        }else if(fillMonth==9){
            monthValueFieldName ="SEP_VALUE_";
        }else if(fillMonth==10){
            monthValueFieldName ="OCT_VALUE_";
        }else if(fillMonth==11){
            monthValueFieldName ="NOV_VALUE_";
        }else if(fillMonth==12){
            monthValueFieldName ="DEC_VALUE_";
        }
        return pilotSpecificSchedulePushDao.queryTargetListByFillYearMonth(fillYear,fillMonth,monthValueFieldName);
    }

    @Override
    public List<PilotQuantitativeMonthPlanVo> queryMonthPlanListByFillYearMonth(Integer fillYear, Integer fillMonth) {
        if(fillMonth>12 || fillMonth<1){
            Calendar calendar = Calendar.getInstance();
            fillMonth = calendar.get(Calendar.MONTH) + 1;
        }
        if(fillYear==null){
            Calendar calendar = Calendar.getInstance();
            fillYear = calendar.get(Calendar.YEAR) ;
        }
        return pilotSpecificSchedulePushDao.queryMonthPlanListByFillYearMonth(fillYear,fillMonth);
    }


    @Override
    @Transactional
    public void quantitativeObjectivesPushSave(QuantitativeObjectivesPushVo quantitativeObjectivesPushVo) {
        Assert.notNull(quantitativeObjectivesPushVo, "推进情况数据不能为空！");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList(), "推进情况数据不能为空！");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotProjectFill(), "填报数据不能为空！");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotProjectFill().getProjectId(), "填报数据项目ID不能为空！");

        PilotProjectFill pilotProjectFill = quantitativeObjectivesPushVo.getPilotProjectFill();
        if(pilotProjectFill == null){
            pilotProjectFill = new PilotProjectFill();
        }
        if(pilotProjectFill.getFillDate() == null ){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue()-1)/3+1;
        pilotProjectFill.setFillQuarter(quarter);
        if(StringUtils.isBlank(pilotProjectFill.getUnitId())){
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(0);
        pilotProjectFill.setFlowType(1);
        // 保存填报信息
        this.pilotProjectFillManager.saveOrUpdate(pilotProjectFill);

        // 保存推进情况
        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList();
        for(PilotQuantitativeObjectivesPush p : pilotQuantitativeObjectivesPushList){
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            if(StringUtils.isBlank(projectId)){
                p.setProjectId(pilotProjectFill.getProjectId());
            }
            Assert.notNull(objectivesMeasuresId, "量化目标ID未设置，请先设置量化目标ID！");
            LocalDate pushDate = p.getPushDate();
            if(null != pushDate){

                // 计算达标率
                BigDecimal pushProgress = p.getPushProgress();
                // 根据推进年份查询年度值，然后计算达标率，达标率=当前推进值/年度值
                Integer pushYear = pushDate.getYear();
                if(null != pushYear && StringUtils.isNotBlank(objectivesMeasuresId) && pushProgress != null){
                    BigDecimal detailsYearValue = pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
                    if(null != detailsYearValue  && detailsYearValue.compareTo(new BigDecimal(0))==1){
                        BigDecimal divide = pushProgress.divide(detailsYearValue, 4, BigDecimal.ROUND_HALF_UP);
                        p.setComplianceRate(divide);
                    }else{
                        p.setComplianceRate(new BigDecimal(100));
                    }
                }

                BigDecimal detailsMonthValue =  pilotObjectivesDetailsManager. getMonthValue(pushYear, pushDate.getMonthValue(),objectivesMeasuresId);
                if(null != detailsMonthValue && detailsMonthValue.compareTo(new BigDecimal(0))==1){
                    BigDecimal divide = pushProgress.divide(detailsMonthValue, 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                    p.setMonthRate(divide);
                }else{
                    p.setComplianceRate(new BigDecimal(100));
                }
            }
            p.setFillId(pilotProjectFill.getId());
            p.setIsDele("0");
        }
        this.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
    }

    @Override
    @Transactional
    public void quantitativeObjectivesPushSaveSaveAndCommit(QuantitativeObjectivesPushVo quantitativeObjectivesPushVo) {
        Assert.notNull(quantitativeObjectivesPushVo, "推进情况数据不能为空！");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList(), "推进情况数据不能为空！");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotProjectFill(), "填报数据不能为空！");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotProjectFill().getProjectId(), "填报数据项目ID不能为空！");

        PilotProjectFill pilotProjectFill = quantitativeObjectivesPushVo.getPilotProjectFill();
        if(pilotProjectFill == null){
            pilotProjectFill = new PilotProjectFill();
        }
        if(pilotProjectFill.getFillDate() == null ){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue()-1)/3+1;
        pilotProjectFill.setFillQuarter(quarter);
        if(StringUtils.isBlank(pilotProjectFill.getUnitId())){
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(1);
        pilotProjectFill.setFlowType(1);
        // 保存填报信息
        this.pilotProjectFillManager.saveOrUpdate(pilotProjectFill);

        // 保存推进情况
        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList();
        for(PilotQuantitativeObjectivesPush p : pilotQuantitativeObjectivesPushList){
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            if(StringUtils.isBlank(projectId)){
                p.setProjectId(pilotProjectFill.getProjectId());
            }
            Assert.notNull(objectivesMeasuresId, "量化目标ID未设置，请先设置量化目标ID！");
            LocalDate pushDate = p.getPushDate();
            if(null != pushDate){
                // 计算达标率
                BigDecimal pushProgress = p.getPushProgress();
                // 根据推进年份查询年度值，然后计算达标率，达标率=当前推进值/年度值
                Integer pushYear = pushDate.getYear();
                if(null != pushYear && StringUtils.isNotBlank(objectivesMeasuresId) && pushProgress != null){
                    BigDecimal detailsYearValue = pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
                    if(null != detailsYearValue && detailsYearValue.compareTo(new BigDecimal(0))==1){
                        BigDecimal divide = pushProgress.divide(detailsYearValue, 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                        p.setComplianceRate(divide);
                    }else{
                        p.setComplianceRate(new BigDecimal(100));
                    }

                    BigDecimal detailsMonthValue =  pilotObjectivesDetailsManager. getMonthValue(pushYear, pushDate.getMonthValue(),objectivesMeasuresId);
                    if(null != detailsMonthValue && detailsMonthValue.compareTo(new BigDecimal(0))==1){
                        BigDecimal divide = pushProgress.divide(detailsMonthValue, 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                        p.setMonthRate(divide);
                    }else{
                        p.setComplianceRate(new BigDecimal(100));
                    }
                }
            }
            p.setFillId(pilotProjectFill.getId());
            p.setIsDele("0");
        }
        this.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
        pilotProjectFill.setApprovalComments("提交数据");

        pilotProjectFillManager.createLog(pilotProjectFill, "市级重大项目量化目标推进");
    }

    @Override
    public void quantitativeObjectivesPushExamine(FillPushExamineVo fillPushExamineVo) {
        pilotProjectFillManager.examineVo(fillPushExamineVo);
    }

    @Override
    public PageList<QuantitativeObjectivesPushFillQueryVo> quantitativeObjectivesPushListByPage(QueryFilter<PilotProjectFill> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("FLOW_TYPE_", 1, QueryOP.EQUAL);
        return pilotProjectFillManager.queyrQuantitativeObjectivesPushFillList(queryFilter);
    }

    @Override
    public QuantitativeObjectivesPushFillQueryDetailVo getDetails(String id) {
        Assert.notNull(id, "条件格式不能为空");
        QuantitativeObjectivesPushFillQueryDetailVo pilotProjectFillQueryVo = new QuantitativeObjectivesPushFillQueryDetailVo();
        PilotProjectFill pilotProjectFill = pilotProjectFillManager.get(id);
        pilotProjectFillQueryVo.setPilotProjectFill(pilotProjectFill);
        if (null != pilotProjectFill) {
            if(pilotProjectFill.getStatus()==2 || pilotProjectFill.getStatus()==4){
                //驳回查询驳回意见
                AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(pilotProjectFill.getId(),pilotProjectFill.getStatus());
                pilotProjectFill.setApprovalComments(log.getApprovalComments());
            }

            // 1.項目信息
            MunicipalMajorProjectManagement municipalMajorProjectManagement = municipalMajorProjectManagementManager
                    .getMunicipalMajorProjectManagement(pilotProjectFill.getProjectId());
            pilotProjectFillQueryVo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);

            // 2.量化目标推进情况集合（包括目标信息、填报年度信息、填报月度）
            List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushList = this.queryListByFillId(pilotProjectFill.getId(),pilotProjectFill.getProjectId(),"false");
            // 设置对应年度、月度值
            LocalDate fillDate = pilotProjectFill.getFillDate();
            if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0 && null != fillDate) {
                pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                    List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
                            .eq("OBJECTIVES_ID_", p.getObjectivesMeasuresId()).eq("YEAR_", fillDate.getYear()));
                    if (null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0) {
                        PilotObjectivesDetails pilotObjectivesDetails1 = pilotObjectivesDetails.get(0);
                        // 设置年度值
                        p.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
                        // 设置月度值
                        Map map = BeanUtils.beanToMap(pilotObjectivesDetails1);
                        Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(fillDate.getMonthValue())));
                        if (null != o) {
                            BigDecimal mouthValue = (BigDecimal) o;
                            p.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
                        }
                    }
                });
            }
            pilotProjectFillQueryVo.setPilotQuantitativeObjectivesPushList(pilotQuantitativeObjectivesPushList);
            // 3.查询历史填报信息(历史信息已改为独立查询接口)
            /*
            PilotProjectFill historyPilotProjectFill = pilotProjectFillManager.getHistoryPilotProjectFill(pilotProjectFill.getProjectId(), 1);
            pilotProjectFillQueryVo.setPilotProjectFillHistory(historyPilotProjectFill);
            if(null != historyPilotProjectFill){
                List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushHistoryList = this.queryListByFillId(historyPilotProjectFill.getId());
                // 设置对应年度、月度值
                LocalDate historyFillDate = historyPilotProjectFill.getFillDate();
                if (null != pilotQuantitativeObjectivesPushHistoryList && pilotQuantitativeObjectivesPushHistoryList.size() > 0 && null != fillDate) {
                    pilotQuantitativeObjectivesPushHistoryList.stream().forEach(p -> {
                        List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
                                .eq("OBJECTIVES_ID_", p.getObjectivesMeasuresId()).eq("YEAR_", historyFillDate.getYear()));
                        if (null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0) {
                            PilotObjectivesDetails pilotObjectivesDetails1 = pilotObjectivesDetails.get(0);
                            // 设置年度值
                            p.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
                            // 设置月度值
                            try {
                                Map map = beanToMap(pilotObjectivesDetails1);
                                Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(historyFillDate.getMonthValue())));
                                if (null != o) {
                                    BigDecimal mouthValue = (BigDecimal) o;
                                    p.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
                                }
                            } catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                pilotProjectFillQueryVo.setPilotQuantitativeObjectivesPushHistoryList(pilotQuantitativeObjectivesPushHistoryList);
            }

             */
        } else {
            throw new BaseException("未找到相关审核信息");
        }
        return pilotProjectFillQueryVo;
    }

    @Override
    public QuantitativeObjectivesPushFillQueryDetailVo getHistoryDetails(String projectId, LocalDate fillDate) {
        Assert.notNull(projectId, "项目ID不能为空");
        if(null == fillDate){
            fillDate = LocalDate.now();
        }
        QuantitativeObjectivesPushFillQueryDetailVo pilotProjectFillQueryVo = new QuantitativeObjectivesPushFillQueryDetailVo();
        // 3.查询历史填报信息
        PilotProjectFill historyPilotProjectFill = pilotProjectFillManager.getHistoryPilotProjectFill(projectId, 1, fillDate);
        pilotProjectFillQueryVo.setPilotProjectFillHistory(historyPilotProjectFill);
        if(null != historyPilotProjectFill){
            if(historyPilotProjectFill.getStatus()==2 || historyPilotProjectFill.getStatus()==4){
                //驳回查询驳回意见
                AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(historyPilotProjectFill.getId(),historyPilotProjectFill.getStatus());
                historyPilotProjectFill.setApprovalComments(log.getApprovalComments());
            }
            List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushHistoryList = this.queryListByFillId(historyPilotProjectFill.getId(),historyPilotProjectFill.getProjectId(),"true");
            // 设置对应年度、月度值
            LocalDate historyFillDate = historyPilotProjectFill.getFillDate();
            if (null != pilotQuantitativeObjectivesPushHistoryList && pilotQuantitativeObjectivesPushHistoryList.size() > 0 && null != fillDate) {
                pilotQuantitativeObjectivesPushHistoryList.stream().forEach(p -> {
                    List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
                            .eq("OBJECTIVES_ID_", p.getObjectivesMeasuresId()).eq("YEAR_", historyFillDate.getYear()));
                    if (null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0) {
                        PilotObjectivesDetails pilotObjectivesDetails1 = pilotObjectivesDetails.get(0);
                        // 设置年度值
                        p.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
                        // 设置月度值
                        Map map = BeanUtils.beanToMap(pilotObjectivesDetails1);
                        Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(historyFillDate.getMonthValue())));
                        if (null != o) {
                            BigDecimal mouthValue = (BigDecimal) o;
                            p.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
                        }
                    }
                });
            }
            pilotProjectFillQueryVo.setPilotQuantitativeObjectivesPushHistoryList(pilotQuantitativeObjectivesPushHistoryList);
        }
        return pilotProjectFillQueryVo;
    }

    @Override
    public void quantitativeObjectivesPushCommit(String id) {
        Assert.notNull(id, "填报ID不能为空！");

        PilotProjectFill pilotProjectFill = pilotProjectFillManager.get(id);
        if(pilotProjectFill == null){
            throw new BaseException("未查询到相关填报数据，请刷新后重试！");
        }
        if(pilotProjectFill.getFillDate() == null ){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue()-1)/3+1;
        pilotProjectFill.setFillQuarter(quarter);
        if(StringUtils.isBlank(pilotProjectFill.getUnitId())){
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(1);
        pilotProjectFill.setFlowType(1);
        // 保存填报信息
        this.pilotProjectFillManager.saveOrUpdate(pilotProjectFill);
    }

    @Override
    public int countQuantitativeObjectivesPush(String id) {
        Assert.notNull(id, "量化目标ID");
        QueryWrapper<PilotQuantitativeObjectivesPush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("OBJECTIVES_MEASURES_ID_", id).eq("IS_DELE_", 0);
        return this.count(queryWrapper);
    }

}
