package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.majorProjects.dao.*;
import com.artfess.reform.majorProjects.manager.*;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.vo.*;
import com.artfess.reform.utils.BizUtils;
import com.artfess.reform.utils.FieldFillUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 市级重大改革项目管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Service
public class MunicipalMajorProjectManagementManagerImpl extends BaseManagerImpl<MunicipalMajorProjectManagementDao, MunicipalMajorProjectManagement> implements MunicipalMajorProjectManagementManager {

    @Resource
    private PilotQuantitativeObjectivesManager pilotQuantitativeObjectivesManager;

    @Resource
    private PilotSpecificMeasuresManager pilotSpecificMeasuresManager;

    @Resource
    private PilotSpecificScheduleManager pilotSpecificScheduleManager;

    @Resource
    private PilotSpecificMeasuresHistoryManager pilotSpecificMeasuresHistoryManager;

    @Resource
    private PilotQuantitativeObjectivesPushManager pilotQuantitativeObjectivesPushManager;

    @Resource
    private PilotSpecificSchedulePushManager pilotSpecificSchedulePushManager;

    @Resource
    private PilotObjectivesDetailsManager pilotObjectivesDetailsManager;

    @Resource
    private PilotProjectFillManager pilotProjectFillManager;

    @Resource
    private SysDictionaryManager sysDictionaryManager;

    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;

    @Resource
    private PilotQuantitativeObjectivesPushDao pilotQuantitativeObjectivesPushDao;

    @Resource
    private PilotBrandPushDao pilotBrandPushDao;

    @Resource
    private FileManager fileManager;

    @Resource
    private PilotExperiencePushDao pilotExperiencePushDao;

    @Resource
    private PilotMeasuresPushDao pilotMeasuresPushDao;

    @Resource
    private PilotSpecificMeasuresHistoryDao pilotSpecificMeasuresHistoryDao;

    @Override
    @Transactional
    public boolean removeById(Serializable id){

        // 删除子表信息,量化目标
        QueryWrapper<MunicipalMajorProjectManagement> majorProjectManagementQueryWrapper = new QueryWrapper<MunicipalMajorProjectManagement>().eq("ID_", id).eq("SEND_STATUS_", 1).eq("IS_DELE_", "0");
        int count = super.count(majorProjectManagementQueryWrapper);
        if(count > 0){
            throw new BaseException("该重大项目已正式下发，不能删除项目！");
        }

        // 具体举措
        QueryWrapper<PilotSpecificMeasures> pilotSpecificMeasuresQueryWrapper = new QueryWrapper<PilotSpecificMeasures>()
                .eq("PROJECT_ID_", id).eq("IS_DELE_", "0");
        pilotSpecificMeasuresManager.remove(pilotSpecificMeasuresQueryWrapper);

        // 历史具体举措
        QueryWrapper<PilotSpecificMeasuresHistory> pilotSpecificMeasuresHistoryQueryWrapper = new QueryWrapper<PilotSpecificMeasuresHistory>()
                .eq("PROJECT_ID_", id).eq("IS_DELE_", "0");
        pilotSpecificMeasuresHistoryManager.remove(pilotSpecificMeasuresHistoryQueryWrapper);

        // 月度计划
        QueryWrapper<PilotSpecificSchedule> pilotSpecificScheduleQueryWrapper = new QueryWrapper<PilotSpecificSchedule>()
                .eq("PROJECT_ID_", id).eq("IS_DELE_", "0");
        pilotSpecificScheduleManager.remove(pilotSpecificScheduleQueryWrapper);

        // 量化目标
        QueryWrapper<PilotQuantitativeObjectives> pilotQuantitativeObjectivesQueryWrapper = new QueryWrapper<PilotQuantitativeObjectives>()
                .eq("PROJECT_ID_", id).eq("IS_DELE_", "0");
        pilotQuantitativeObjectivesManager.remove(pilotQuantitativeObjectivesQueryWrapper);

        // 量化目标计划值
        QueryWrapper<PilotObjectivesDetails> pilotObjectivesDetailsQueryWrapper = new QueryWrapper<PilotObjectivesDetails>()
                .eq("PROJECT_ID_", id);
        pilotObjectivesDetailsManager.remove(pilotObjectivesDetailsQueryWrapper);



        // 删除主表信息
        return  SqlHelper.retBool(baseMapper.deleteById(id));
    }

    @Override
    public MunicipalMajorProjectManagement getById(Serializable id) {
        MunicipalMajorProjectManagement municipalMajorProjectManagement = super.getOne(new QueryWrapper<MunicipalMajorProjectManagement>().eq("ID_",id).last("LIMIT 1"));

        if(null != municipalMajorProjectManagement){
            if(municipalMajorProjectManagement.getStatus()==2 || municipalMajorProjectManagement.getStatus()==4){
                //驳回查询驳回意见
                AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(municipalMajorProjectManagement.getId(),municipalMajorProjectManagement.getStatus());
                municipalMajorProjectManagement.setApprovalComments(log.getApprovalComments());
            }
            // 查询子表
            municipalMajorProjectManagement.setPilotQuantitativeObjectivesList(pilotQuantitativeObjectivesManager
                    .queryPilotQuantitativeObjectivesListByProjectId(municipalMajorProjectManagement.getId()));
            municipalMajorProjectManagement.setPilotSpecificMeasuresList(pilotSpecificMeasuresManager
                    .queryListByProjectId(municipalMajorProjectManagement.getId()));
            municipalMajorProjectManagement.setPilotSpecificScheduleList(pilotSpecificScheduleManager
                    .queryPilotSpecificScheduleListByProjectId(municipalMajorProjectManagement.getId()));
        }
        return municipalMajorProjectManagement;
    }

    @Override
    public MunicipalMajorProjectManagement getMunicipalMajorProjectManagement(Serializable id) {
        MunicipalMajorProjectManagement municipalMajorProjectManagement = super.getById(id);
        return municipalMajorProjectManagement;
    }

//    @Override
//    public MunicipalMajorProjectManagement getExamineById(PilotProjectFill pilotProjectFill) {
//        Assert.notNull(pilotProjectFill, "参数不能为空");
//        Assert.notNull(pilotProjectFill.getProjectId(), "项目ID不能为空");
//        MunicipalMajorProjectManagement municipalMajorProjectManagement = super.getById(pilotProjectFill.getProjectId());
//        // 量化方案目标,c
//        List<PilotQuantitativeObjectives> pilotQuantitativeObjectivesList = pilotQuantitativeObjectivesManager
//                .queryListByProjectId(municipalMajorProjectManagement.getId(), pilotProjectFill.getFillDate());
//        municipalMajorProjectManagement.setPilotQuantitativeObjectivesList(pilotQuantitativeObjectivesList);
//        // 改革举措(已改为季度计划的执行情况)
//        municipalMajorProjectManagement.setPilotSpecificMeasuresList(pilotSpecificMeasuresManager
//                .queryListByProjectId(municipalMajorProjectManagement.getId()));
//        // 季度计划-季度计划形成的成果
//        List<PilotSpecificSchedule> pilotSpecificSchedulesList = pilotSpecificScheduleManager
//                .queryListByProjectId(municipalMajorProjectManagement.getId());
//        municipalMajorProjectManagement.setPilotSpecificScheduleList(pilotSpecificSchedulesList);
//
//        // 按照季度处理季度计划数据
//        List<Map<String, List<PilotSpecificSchedule>>> pilotSpecificScheduleQuarterList= new ArrayList<>();
//        if(null != pilotSpecificSchedulesList && pilotSpecificSchedulesList.size() > 0){
//            Map<String, List<PilotSpecificSchedule>> map = new LinkedHashMap<>();
//            for (PilotSpecificSchedule pilotSpecificSchedule : pilotSpecificSchedulesList){
//                int year = LocalDate.now().getYear();
//                String planQuarter = String.valueOf(pilotSpecificSchedule.getPlanQuarter());
//                if(null != pilotSpecificSchedule.getPlanYear() && year == pilotSpecificSchedule.getPlanYear()){
//                    List<PilotSpecificSchedule> pilotSpecificSchedulePushes = map.get(planQuarter);
//                    if(null == pilotSpecificSchedulePushes){
//                        pilotSpecificSchedulePushes = new ArrayList<>();
//                        pilotSpecificSchedulePushes.add(pilotSpecificSchedule);
//                        map.put(planQuarter, pilotSpecificSchedulePushes);
//                    }else {
//                        pilotSpecificSchedulePushes.add(pilotSpecificSchedule);
//                        map.put(planQuarter, pilotSpecificSchedulePushes);
//                    }
//                }
//            }
//            if(null != map && map.size() > 0){
//                for (String key : map.keySet()) {
//                    Map<String, List<PilotSpecificSchedule>>  subMap = new LinkedHashMap<>();
//                    subMap.put(key, map.get(key));
//                    pilotSpecificScheduleQuarterList.add(subMap);
//                }
//            }
//        }
//        municipalMajorProjectManagement.setPilotSpecificScheduleQuarterList(pilotSpecificScheduleQuarterList);
//        return municipalMajorProjectManagement;
//    }


    @Override
    public MunicipalMajorProjectManagement getPilotQuantitativeObjectivesVoById(PilotProjectFill pilotProjectFill) {
        Assert.notNull(pilotProjectFill, "参数不能为空");
        Assert.notNull(pilotProjectFill.getProjectId(), "项目ID不能为空");
        MunicipalMajorProjectManagement municipalMajorProjectManagement = super.getById(pilotProjectFill.getProjectId());
        if(null == pilotProjectFill.getFillDate()){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        // 量化方案目标,
        List<PilotQuantitativeObjectives> pilotQuantitativeObjectivesList = pilotQuantitativeObjectivesManager
                .queryListByProjectId(municipalMajorProjectManagement.getId(), pilotProjectFill.getFillDate());
        municipalMajorProjectManagement.setPilotQuantitativeObjectivesList(pilotQuantitativeObjectivesList);
        return municipalMajorProjectManagement;
    }

    @Override
    public MunicipalMajorProjectManagement getPilotMeasuresVoAndPilotSpecificSchedulePushById(PilotProjectFill pilotProjectFill) {
        Assert.notNull(pilotProjectFill, "参数不能为空");
        Assert.notNull(pilotProjectFill.getProjectId(), "项目ID不能为空");
        if(null == pilotProjectFill.getFillDate()){
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        LocalDate fillDate = pilotProjectFill.getFillDate();
        MunicipalMajorProjectManagement municipalMajorProjectManagement = super.getById(pilotProjectFill.getProjectId());
         // 季度计划-季度计划形成的成果
        List<PilotSpecificSchedule> pilotSpecificSchedulesList = pilotSpecificScheduleManager.queryListByProjectId(pilotProjectFill.getProjectId());
        municipalMajorProjectManagement.setPilotSpecificScheduleList(pilotSpecificSchedulesList);

        // 按照月份处理每个月的计划数据
        List<Map<String, List<PilotSpecificSchedule>>> pilotSpecificScheduleQuarterList= new ArrayList<>();
        if(null != pilotSpecificSchedulesList && pilotSpecificSchedulesList.size() > 0){
            Map<String, List<PilotSpecificSchedule>> map = new LinkedHashMap<>();
            for (PilotSpecificSchedule pilotSpecificSchedule : pilotSpecificSchedulesList){
                int year = fillDate.getYear();
                String planQuarter = String.valueOf(pilotSpecificSchedule.getPlanQuarter());
                if(null != pilotSpecificSchedule.getPlanYear() && year == pilotSpecificSchedule.getPlanYear()){
                    List<PilotSpecificSchedule> pilotSpecificSchedulePushes = map.get(planQuarter);
                    if(null == pilotSpecificSchedulePushes){
                        pilotSpecificSchedulePushes = new ArrayList<>();
                        pilotSpecificSchedulePushes.add(pilotSpecificSchedule);
                        map.put(planQuarter, pilotSpecificSchedulePushes);
                    }else {
                        pilotSpecificSchedulePushes.add(pilotSpecificSchedule);
                        map.put(planQuarter, pilotSpecificSchedulePushes);
                    }
                }
            }
            if(null != map && map.size() > 0){
                for (String key : map.keySet()) {
                    Map<String, List<PilotSpecificSchedule>>  subMap = new LinkedHashMap<>();
                    subMap.put(key, map.get(key));
                    pilotSpecificScheduleQuarterList.add(subMap);
                }
            }
        }
        municipalMajorProjectManagement.setPilotSpecificScheduleQuarterList(pilotSpecificScheduleQuarterList);

        return municipalMajorProjectManagement;
    }


//    @Override
//    public MunicipalMajorProjectManagementVo getExamineVoById(PilotProjectFill pilotProjectFill) {
//        Assert.notNull(pilotProjectFill, "参数不能为空");
//        Assert.notNull(pilotProjectFill.getProjectId(), "项目ID不能为空");
//        MunicipalMajorProjectManagement project = super.getById(pilotProjectFill.getProjectId());
//        MunicipalMajorProjectManagementVo municipalMajorProjectManagement = new MunicipalMajorProjectManagementVo();
//        BeanUtils.copyProperties(project, municipalMajorProjectManagement);
//        PilotProjectFillQueryVo fill = pilotProjectFillManager.getDraftDetails(pilotProjectFill.getProjectId());
//        // 1.量化方案目标,c
//        List<PilotQuantitativeObjectives> pilotQuantitativeObjectivesList = pilotQuantitativeObjectivesManager
//                .queryListByProjectId(municipalMajorProjectManagement.getId(), pilotProjectFill.getFillDate());
//        if(null != pilotQuantitativeObjectivesList && pilotQuantitativeObjectivesList.size() > 0){
//            List<PilotQuantitativeObjectivesVo> voList = new ArrayList<>(pilotQuantitativeObjectivesList.size());
//            for (PilotQuantitativeObjectives pilotQuantitativeObjectives : pilotQuantitativeObjectivesList){
//                // 1.1 转化为vo
//                PilotQuantitativeObjectivesVo vo = new PilotQuantitativeObjectivesVo();
//                BeanUtils.copyProperties(pilotQuantitativeObjectives, vo);
//                vo.setId(pilotQuantitativeObjectives.getId());
//
//                // 获取当前年度值，当前月度值
//                List<PilotObjectivesDetails> pilotObjectivesDetailsList = pilotQuantitativeObjectives.getPilotObjectivesDetailsList();
//                if (null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0) {
//                    PilotObjectivesDetails pilotObjectivesDetails1 = pilotObjectivesDetailsList.get(0);
//                    for (PilotObjectivesDetails p : pilotObjectivesDetailsList){
//                        Integer year = p.getYear();
//                        if(null != year &&  year == LocalDate.now().getYear()){
//                            pilotObjectivesDetails1 = p;
//                            break;
//                        }
//                    }
//                    BigDecimal yearValue = pilotObjectivesDetails1.getYearValue();
//                    if(null !=  yearValue){
//                        vo.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
//                    }
//                    try {
//                        Map map = beanToMap(pilotObjectivesDetails1);
//                        Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(LocalDate.now().getMonthValue())));
//                        if (null != o) {
//                            BigDecimal mouthValue = (BigDecimal) o;
//                            vo.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
//                        }
//                    } catch (IllegalAccessException e) {
//                        e.printStackTrace();
//                    }
//                }
//
//
//                // 1.2 目标推进草稿信息关联
//                if(null != fill && fill.getPilotQuantitativeObjectivesPushList() != null){
//                    List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushList = fill.getPilotQuantitativeObjectivesPushList();
//                    for(PilotQuantitativeObjectivesPushVo pushVo : pilotQuantitativeObjectivesPushList){
//                        if(pilotQuantitativeObjectives.getId().equalsIgnoreCase(pushVo.getObjectivesMeasuresId())){
//                            vo.setDataId(pushVo.getId());
//                            vo.setFillId(pushVo.getFillId());
//                            vo.setObjectivesMeasuresId(vo.getObjectivesMeasuresId());
//                            vo.setPushProgress(pushVo.getPushProgress());
//                            vo.setPushDate(pushVo.getPushDate());
//                            vo.setPushYear(pushVo.getPushYear());
//                            vo.setPushQuarter(pushVo.getPushQuarter());
//                            vo.setPushMonth(pushVo.getPushMonth());
//                            vo.setComplianceRate(vo.getComplianceRate());
//                            vo.setDefaultFileList(vo.getDefaultFileList());
//                            break;
//                        }
//                    }
//                }
//                voList.add(vo);
//            }
//            municipalMajorProjectManagement.setPilotQuantitativeObjectivesList(voList);
//        }
//        // 改革举措(已改为季度计划的执行情况)
//        List<PilotSpecificMeasures> pilotSpecificMeasuresList = pilotSpecificMeasuresManager
//                .queryListByProjectId(municipalMajorProjectManagement.getId());
//        if(null != pilotSpecificMeasuresList){
//            pilotSpecificMeasuresList.stream().forEach(p->{
//                p.setDataId(p.getId());
//            });
//        }
//        municipalMajorProjectManagement.setPilotSpecificMeasuresList(pilotSpecificMeasuresList);
//
//        // 2.季度计划-季度计划形成的成果
//        List<PilotSpecificSchedule> pilotSpecificSchedulesList = pilotSpecificScheduleManager
//                .queryListByProjectId(municipalMajorProjectManagement.getId());
//        if(null != pilotSpecificSchedulesList && pilotSpecificSchedulesList.size() > 0){
//            List<PilotMeasuresVo> voList = new ArrayList<>(pilotSpecificSchedulesList.size());
//            for(PilotSpecificSchedule pilotSpecificSchedule : pilotSpecificSchedulesList){
////            // 2.1 转为vo
//                PilotMeasuresVo vo = new PilotMeasuresVo();
//                BeanUtils.copyProperties(pilotSpecificSchedule, vo);
//                vo.setId(pilotSpecificSchedule.getId());
//                // 2.2 计划推进草稿关联
//                if(null != fill && fill.getPilotMeasuresPushList() != null){
//                    List<PilotMeasuresPushVo> pilotMeasuresPushList = fill.getPilotMeasuresPushList();
//                    for(PilotMeasuresPushVo pushVo : pilotMeasuresPushList){
//                        if(pilotSpecificSchedule.getId().equalsIgnoreCase(pushVo.getMeasuresId())){
//                            vo.setDataId(pushVo.getId());
//                            vo.setFillId(pushVo.getFillId());
//                            vo.setPlanId(pushVo.getMeasuresId());
//                            vo.setIsOver(pushVo.getIsOver());
//                            vo.setCompletedWork(pushVo.getCompletedWork());
//                            vo.setProblems(pushVo.getProblems());
//                            vo.setWorkPlan(pushVo.getWorkPlan());
//                            vo.setDefaultFileList(vo.getDefaultFileList());
//                            break;
//                        }
//                    }
//                }
//                voList.add(vo);
//            }
//            municipalMajorProjectManagement.setPilotSpecificScheduleList(voList);
//        }
//        // 按照季度处理季度计划数据
//        List<PilotMeasuresVo> pilotSpecificScheduleList = municipalMajorProjectManagement.getPilotSpecificScheduleList();
//        List<Map<String, List<PilotMeasuresVo>>> pilotSpecificScheduleQuarterList= new ArrayList<>();
//        if(null != pilotSpecificScheduleList && pilotSpecificScheduleList.size() > 0){
//            Map<String, List<PilotMeasuresVo>> map = new LinkedHashMap<>();
//            for (PilotMeasuresVo vo : pilotSpecificScheduleList) {
//                String planQuarter = String.valueOf(vo.getPlanQuarter());
//                List<PilotMeasuresVo> pilotMeasuresVo = map.get(planQuarter);
//                if (null == pilotMeasuresVo) {
//                    pilotMeasuresVo = new ArrayList<>();
//                    pilotMeasuresVo.add(vo);
//                    map.put(planQuarter, pilotMeasuresVo);
//                } else {
//                    pilotMeasuresVo.add(vo);
//                    map.put(planQuarter, pilotMeasuresVo);
//                }
//            }
//            if (null != map && map.size() > 0) {
//                for (String key : map.keySet()) {
//                    Map<String, List<PilotMeasuresVo>> subMap = new LinkedHashMap<>();
//                    subMap.put(key, map.get(key));
//                    pilotSpecificScheduleQuarterList.add(subMap);
//                }
//            }
//        }
//        municipalMajorProjectManagement.setPilotSpecificScheduleQuarterList(pilotSpecificScheduleQuarterList);
//
//        // 市级重大改革项目填报审核记录
//        if(null != fill && fill.getPilotProjectFill() != null){
//            PilotProjectFill projectFill = fill.getPilotProjectFill();
//            projectFill.setDataId(projectFill.getId());
//            municipalMajorProjectManagement.setPilotProjectFill(projectFill);
//        }
//        // 项目经验推广总结情况集合
//        if(null != fill && fill.getPilotExperiencePushList() != null){
//            List<PilotExperiencePush> pilotExperiencePushList = fill.getPilotExperiencePushList();
//            pilotExperiencePushList.stream().forEach(p->{
//                p.setDataId(p.getId());
//            });
//            municipalMajorProjectManagement.setPilotExperiencePushList(pilotExperiencePushList);
//        }
//        // 进度计划明细推进情况集合
//        if(null != fill && fill.getPilotSpecificSchedulePushList() != null){
//            List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = fill.getPilotSpecificSchedulePushList();
//            pilotSpecificSchedulePushList.stream().forEach(p->{
//                p.setDataId(p.getId());
//            });
//            municipalMajorProjectManagement.setPilotSpecificSchedulePushList(pilotSpecificSchedulePushList);
//        }
//        // 项目品牌显示度情况集合
//        if(null != fill && fill.getPilotBrandPushList() != null){
//            List<PilotBrandPush> pilotBrandPushList = fill.getPilotBrandPushList();
//            pilotBrandPushList.stream().forEach(p->{
//                p.setDataId(p.getId());
//            });
//            municipalMajorProjectManagement.setPilotBrandPushList(pilotBrandPushList);
//        }
//        return municipalMajorProjectManagement;
//    }

    @Override
    public boolean isExists(MunicipalMajorProjectManagement municipalMajorProjectManagement){
         if (municipalMajorProjectManagement.getId()==null){
             MunicipalMajorProjectManagement entity = this.getOne(new QueryWrapper<MunicipalMajorProjectManagement>()
                     .eq("PROJECT_NAME_", municipalMajorProjectManagement.getProjectName())
                     .eq("PROJECT_TYPE_", municipalMajorProjectManagement.getProjectType())
                     .eq("IS_DELE_", "0")
                     .last("LIMIT 1"));
             return entity==null;
         }else {
             MunicipalMajorProjectManagement entity = this.getOne(new QueryWrapper<MunicipalMajorProjectManagement>()
                     .eq("PROJECT_NAME_", municipalMajorProjectManagement.getProjectName())
                     .eq("PROJECT_TYPE_", municipalMajorProjectManagement.getProjectType())
                     .eq("IS_DELE_", "0"));
             if (entity==null){
                 return true;
             }else {
                 return entity.getId().equals(municipalMajorProjectManagement.getId());
             }
         }
    }

    @Override
    @Transactional
    public boolean updateStatus(MunicipalMajorProjectManagement project) {
        Assert.notNull(project, "市级重大改革项目信息不能为空");
        Assert.notNull(project.getId(), "项目id不能为空");
        Assert.notNull(project.getStatus(), "项目审核状态不能为空");
        if(project.getSendStatus()==1){
            project.setSendTime(LocalDateTime.now());
        }
        MunicipalMajorProjectManagement entity = super.getById(project.getId());
        boolean b = super.updateById(project);
        // 4.写入审核日志表
        if (entity==null||(entity.getStatus()!=project.getStatus())) this.createLog(project.getId(),project.getStatus(),project.getApprovalResults(),project.getApprovalComments(),project.getProjectName());
        //  1. 量化目标
        List<PilotQuantitativeObjectives> pilotQuantitativeObjectivesList = project.getPilotQuantitativeObjectivesList();
        if(null != pilotQuantitativeObjectivesList && pilotQuantitativeObjectivesList.size() > 0){
            pilotQuantitativeObjectivesList.stream().forEach(p -> {
                p.setProjectId(project.getId());
            });
            pilotQuantitativeObjectivesManager.saveOrUpdateBatch(pilotQuantitativeObjectivesList);
            // 保存改革方案明确的量化目标的计划值集合
            pilotQuantitativeObjectivesList.stream().forEach(p -> {
                List<PilotObjectivesDetails> pilotObjectivesDetailsList = p.getPilotObjectivesDetailsList();
                if(null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0){
                    pilotObjectivesDetailsList.stream().forEach(d -> {
                        d.setProjectId(project.getId());
                        d.setObjectivesId(p.getId());
                    });
                    //修改现有数据
                    pilotObjectivesDetailsManager.saveOrUpdateBatch(pilotObjectivesDetailsList);
                }
            });
        }
        //  2.具体举措
        List<PilotSpecificMeasures> pilotSpecificMeasuresList = project.getPilotSpecificMeasuresList();
        if(null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0){
            pilotSpecificMeasuresList.stream().forEach(p -> {
                p.setProjectId(project.getId());
                p.setDistributionType(0);
            });
            pilotSpecificMeasuresManager.saveOrUpdateBatch(pilotSpecificMeasuresList);
            //审核状态为5，改革办确认通过的才同步到历史表
            if(project.getStatus()==5){
                List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresHistoryList = new ArrayList<>(pilotSpecificMeasuresList.size());
                for (PilotSpecificMeasures pilotSpecificMeasures : pilotSpecificMeasuresList){
                    QueryWrapper<PilotSpecificMeasuresHistory> queryWrapper =new QueryWrapper<>();
                    queryWrapper.eq("SPECIFIC_MEASURES_ID_", pilotSpecificMeasures.getId()).eq("SN_",0).eq("DISTRIBUTION_TYPE_", 0);
                    List<PilotSpecificMeasuresHistory> hisList = pilotSpecificMeasuresHistoryManager.list(queryWrapper);
                    if(hisList!=null && hisList.size()>0){
                        for(PilotSpecificMeasuresHistory history : hisList){
                            history.setReformSpecificMeasures(pilotSpecificMeasures.getReformSpecificMeasures());
                            pilotSpecificMeasuresHistoryList.add(history);
                        }
                    }else{
                        PilotSpecificMeasuresHistory history = new PilotSpecificMeasuresHistory();
                        BeanUtils.copyProperties(pilotSpecificMeasures ,history);
                        history.setId(null);
                        history.setIterationDate(LocalDate.now());
                        history.setIterationYear(LocalDate.now().getYear());
                        history.setIterationMonth(LocalDate.now().getMonthValue());
                        history.setIterationQuarter(Integer.valueOf(LocalDate.now().getMonthValue()+2)/3);
                        history.setDistributionType(0);
                        history.setSn(0);
                        history.setStatus(5);
                        history.setSynStatus(1);
                        history.setSpecificMeasuresId(pilotSpecificMeasures.getId());
                        pilotSpecificMeasuresHistoryList.add(history);
                    }

                }
                pilotSpecificMeasuresHistoryManager.saveOrUpdateBatch(pilotSpecificMeasuresHistoryList);
            }

        }
        //  3.月度计划
        List<PilotSpecificSchedule> pilotSpecificScheduleList = project.getPilotSpecificScheduleList();
        if(null != pilotSpecificScheduleList && pilotSpecificScheduleList.size() > 0){
            pilotSpecificScheduleList.stream().forEach(p -> {
                p.setProjectId(project.getId());
                p.setPlanStatus(1);
                //根据所填月份获取季度
                if (p.getPlanMonth()!=null) p.setPlanQuarter((p.getPlanMonth()+2)/3);
                //更新推进表月度计划类型
                pilotMeasuresPushManager.update(new UpdateWrapper<PilotMeasuresPush>().set("PLAN_TYPE_",p.getPlanType()).eq("PLAN_ID_",p.getId()));
            });
            pilotSpecificScheduleManager.saveOrUpdateBatch(pilotSpecificScheduleList);
        }


        return b;
    }

    @Override
    @Transactional
    public boolean revocation(String id,Integer status,Integer approvalResults) {
        Assert.hasText(id, "市级重大改革项目ID不能为空");
        Assert.notNull(status, "市级重大改革项目状态不能为空");
        Assert.notNull(approvalResults, "市级重大改革项目执行结果不能为空");
        MunicipalMajorProjectManagement project = this.baseMapper.selectById(id);
        if(com.artfess.base.util.BeanUtils.isEmpty(project)){
            throw new RuntimeException("市级重大改革项目ID错误！");
        }
        project.setStatus(status);
        project.setSendStatus(0);
        boolean b = super.updateById(project);
        this.createLog(id,status,approvalResults,"",project.getProjectName());
        return b;
    }

    @Override
    @Transactional
    public boolean updateSendStatus(String id) {
        Assert.hasText(id,"项目ID不能为空！");
        UpdateWrapper<MunicipalMajorProjectManagement> updateWrapper = new UpdateWrapper();
        updateWrapper.set("SEND_STATUS_", 1).set("SEND_TIME_", LocalDateTime.now()).eq("id_", id);
        return this.update(updateWrapper);
    }

    @Override
    public PageList<MunicipalMajorProjectManagement> queryByPage(QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        IPage<MunicipalMajorProjectManagement> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public PageList<MunicipalMajorProjectManagement> queryByPageGroup(QueryFilter<MunicipalMajorProjectManagement> queryFilter, String code) {
        IPage<MunicipalMajorProjectManagement> iPage = baseMapper.queryByPageGroup(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()),code);
        return new PageList<>(iPage);
    }

    @Override
    public MunicipalMajorProjectAllVo overAllQuery(String id, Integer year, Integer month) {
        MunicipalMajorProjectAllVo municipalMajorProjectAllVo=new MunicipalMajorProjectAllVo();
        //项目基本信息查询
        MunicipalMajorProjectManagement municipalMajorProjectManagement = this.getOne(new QueryWrapper<MunicipalMajorProjectManagement>().eq("ID_",id).eq("IS_DELE_","0"),false);
        municipalMajorProjectAllVo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
       //查询量化目标信息
        List<QuantitativeObjectivesVo> quantitativeObjectivesVoList = pilotQuantitativeObjectivesPushDao.quantitativeObjectivesInfo(id, year, month);
        if (quantitativeObjectivesVoList !=null&&quantitativeObjectivesVoList.size()>0) municipalMajorProjectAllVo.setPilotQuantitativeObjectivesList(quantitativeObjectivesVoList);
        //查询月度计划信息
        List<PilotBrandPush> pilotBrandPushList = pilotBrandPushDao.pilotBrandPushInfo(id, year, month);
//        for (PilotBrandPush pilotBrandPush : pilotBrandPushList) {
//            List<DefaultFile> files = fileManager.queryFileByBizId(pilotBrandPush.getId());
//            if (com.artfess.base.util.BeanUtils.isNotEmpty(files)){
//                pilotBrandPush.setFiles(files);
//            }
//        }
        if (pilotBrandPushList!=null&&pilotBrandPushList.size()>0)municipalMajorProjectAllVo.setPilotBrandPushList(pilotBrandPushList);
        //查询经验推广信息
        List<PilotExperiencePush> pilotExperiencePushList = pilotExperiencePushDao.pilotExperiencePushInfo(id, year, month);
//        for (PilotExperiencePush pilotExperiencePush : pilotExperiencePushList) {
//            List<DefaultFile> files = fileManager.queryFileByBizId(pilotExperiencePush.getId());
//            if (com.artfess.base.util.BeanUtils.isNotEmpty(files)){
//                pilotExperiencePush.setDefaultFileList(files);
//            }
//        }
        if(pilotExperiencePushList!=null&&pilotExperiencePushList.size()>0)municipalMajorProjectAllVo.setPilotExperiencePushList(pilotExperiencePushList);
        //查询月度计划信息
        List<PilotMeasuresPush> pilotMeasuresPushList = pilotMeasuresPushDao.pilotMeasuresPushInfo(id, year, month);
//        for (PilotMeasuresPush pilotMeasuresPush : pilotMeasuresPushList) {
//            List<DefaultFile> files = fileManager.queryFileByBizId(pilotMeasuresPush.getId());
//            if (com.artfess.base.util.BeanUtils.isNotEmpty(files)){
//                pilotMeasuresPush.setDefaultFileList(files);
//            }
//        }
        if(pilotMeasuresPushList!=null&&pilotMeasuresPushList.size()>0)municipalMajorProjectAllVo.setPilotMeasuresPushList(pilotMeasuresPushList);
        //查询迭代举措信息
        List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresHistoryList = pilotSpecificMeasuresHistoryDao.pilotSpecificMeasuresHistoryInfo(id, year, month);
        if(pilotSpecificMeasuresHistoryList!=null&&pilotSpecificMeasuresHistoryList.size()>0)municipalMajorProjectAllVo.setPilotSpecificMeasuresHistoryList(pilotSpecificMeasuresHistoryList);
        return municipalMajorProjectAllVo;
    }

    @Override
    @Transactional
    public void create(MunicipalMajorProjectManagement municipalMajorProjectManagement){
        Assert.notNull(municipalMajorProjectManagement, "市级重大改革项目信息不能为空");
        // 保存主表信息
        municipalMajorProjectManagement.setClosing(1);
        municipalMajorProjectManagement.setStatus(-1);
        municipalMajorProjectManagement.setSendStatus(0);
        super.create(municipalMajorProjectManagement);
        // 保存子表信息
        //  1. 量化目标
        List<PilotQuantitativeObjectives> pilotQuantitativeObjectivesList = municipalMajorProjectManagement.getPilotQuantitativeObjectivesList();
        if(null != pilotQuantitativeObjectivesList && pilotQuantitativeObjectivesList.size() > 0){
            pilotQuantitativeObjectivesList.stream().forEach(p -> {
                p.setProjectId(municipalMajorProjectManagement.getId());
            });
            pilotQuantitativeObjectivesManager.saveBatch(pilotQuantitativeObjectivesList);
            // 保存改革方案明确的量化目标的计划值集合
            pilotQuantitativeObjectivesList.stream().forEach(p -> {
                List<PilotObjectivesDetails> pilotObjectivesDetailsList = p.getPilotObjectivesDetailsList();
                if(null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0){
                    pilotObjectivesDetailsList.stream().forEach(d -> {
                        d.setProjectId(municipalMajorProjectManagement.getId());
                        d.setObjectivesId(p.getId());
                        d.setLastTime(new Date().getTime());
                    });
                    pilotObjectivesDetailsManager.saveOrUpdateBatch(pilotObjectivesDetailsList);
                }
            });
        }
        //  2.具体举措
        List<PilotSpecificMeasures> pilotSpecificMeasuresList = municipalMajorProjectManagement.getPilotSpecificMeasuresList();
        if(null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0){
            pilotSpecificMeasuresList.stream().forEach(p -> {
                p.setProjectId(municipalMajorProjectManagement.getId());
                p.setDistributionType(0);
            });
            pilotSpecificMeasuresManager.saveOrUpdateBatch(pilotSpecificMeasuresList);

        }
        //  3.月度计划
        List<PilotSpecificSchedule> pilotSpecificScheduleList = municipalMajorProjectManagement.getPilotSpecificScheduleList();
        if(null != pilotSpecificScheduleList && pilotSpecificScheduleList.size() > 0){
            pilotSpecificScheduleList.stream().forEach(p -> {
                p.setProjectId(municipalMajorProjectManagement.getId());
                p.setPlanStatus(1);
                //根据所填月份获取季度
                if (p.getPlanMonth()!=null) p.setPlanQuarter((p.getPlanMonth()+2)/3);
            });
            pilotSpecificScheduleManager.saveBatch(pilotSpecificScheduleList);
        }
    }

    @Override
    public PageList<MunicipalMajorProjectManagement> query(QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        boolean isdele = true;
        if(null != querys && querys.size() > 0){
            for(QueryField queryField : querys){
                String property = queryField.getProperty();
                if("IS_DELE_".equalsIgnoreCase(property) || "ISDELE" .equalsIgnoreCase(property)){
                    isdele = false;
                    break;
                }
            }
        }
        if(isdele){
            queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        }
        PageList<MunicipalMajorProjectManagement> queryPageList = super.query(queryFilter);
//        List<MunicipalMajorProjectManagement> rows = queryPageList.getRows();
//        if(null != rows && rows.size() > 0){
//             // 查询子表信息
//            for (MunicipalMajorProjectManagement municipalMajorProjectManagement : rows){
//                municipalMajorProjectManagement.setPilotQuantitativeObjectivesList(pilotQuantitativeObjectivesManager
//                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
//                municipalMajorProjectManagement.setPilotSpecificMeasuresList(pilotSpecificMeasuresManager
//                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
//                municipalMajorProjectManagement.setPilotSpecificScheduleList(pilotSpecificScheduleManager
//                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
//            }
//        }
        return queryPageList;
    }

    @Override
    public PageList<MunicipalMajorProjectManagement> queryProjectList(QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        boolean isdele = true;
        if (null != querys && querys.size() > 0) {
            for (QueryField queryField : querys) {
                String property = queryField.getProperty();
                if ("IS_DELE_".equalsIgnoreCase(property) || "ISDELE".equalsIgnoreCase(property)) {
                    isdele = false;
                    break;
                }
            }
        }
        if (isdele) {
            queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        }
        PageBean pageBean = queryFilter.getPageBean();
        IPage<MunicipalMajorProjectManagement> result = this.baseMapper.selectPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<MunicipalMajorProjectManagement>(result);
    }

    @Override
    public PageList<MunicipalMajorProjectManagement> queryList(QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        // 如果不是管理员，各个单位只查询自己组织的项目数据
        IUser user = ContextUtil.getCurrentUser();
        if(null != user && !user.isAdmin()){
            if(StringUtils.isNotBlank(ContextUtil.getCurrentOrgId())){
                queryFilter.addFilter("UNIT_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
        }
        PageList<MunicipalMajorProjectManagement> queryPageList = this.query(queryFilter);
        return queryPageList;
    }

    @Override
    public List<MunicipalMajorProjectManagement> queryNoPage(QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        List<MunicipalMajorProjectManagement> municipalMajorProjectManagements = super.queryNoPage(queryFilter);
        if(null != municipalMajorProjectManagements && municipalMajorProjectManagements.size() > 0){
            // 查询子表信息
            for (MunicipalMajorProjectManagement municipalMajorProjectManagement : municipalMajorProjectManagements){
                municipalMajorProjectManagement.setPilotQuantitativeObjectivesList(pilotQuantitativeObjectivesManager
                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
                municipalMajorProjectManagement.setPilotSpecificMeasuresList(pilotSpecificMeasuresManager
                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
                municipalMajorProjectManagement.setPilotSpecificScheduleList(pilotSpecificScheduleManager
                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
            }
        }
        return super.queryNoPage(queryFilter);
    }

    @Override
    public List<MunicipalMajorProjectManagement> queryAll(QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        return super.queryNoPage(queryFilter);
    }

    @Override
    @Transactional
    public boolean updateById(MunicipalMajorProjectManagement municipalMajorProjectManagement) {
        Assert.notNull(municipalMajorProjectManagement, "市级重大改革项目信息不能为空");
        boolean b = super.updateById(municipalMajorProjectManagement);
        //  1. 量化目标
        List<PilotQuantitativeObjectives> pilotQuantitativeObjectivesList = municipalMajorProjectManagement.getPilotQuantitativeObjectivesList();
        if(null != pilotQuantitativeObjectivesList && pilotQuantitativeObjectivesList.size() > 0){
            pilotQuantitativeObjectivesList.stream().forEach(p -> {
                p.setProjectId(municipalMajorProjectManagement.getId());
            });
            pilotQuantitativeObjectivesManager.saveOrUpdateBatch(pilotQuantitativeObjectivesList);
            // 保存改革方案明确的量化目标的计划值集合
            pilotQuantitativeObjectivesList.stream().forEach(p -> {
                List<PilotObjectivesDetails> pilotObjectivesDetailsList = p.getPilotObjectivesDetailsList();
                if(null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0){
                    pilotObjectivesDetailsList.stream().forEach(d -> {
                        d.setProjectId(municipalMajorProjectManagement.getId());
                        d.setObjectivesId(p.getId());
                    });
                     //修改现有数据
                    pilotObjectivesDetailsManager.saveOrUpdateBatch(pilotObjectivesDetailsList);
                }
            });
        }
        //  2.具体举措
        List<PilotSpecificMeasures> pilotSpecificMeasuresList = municipalMajorProjectManagement.getPilotSpecificMeasuresList();
        if(null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0){
            pilotSpecificMeasuresList.stream().forEach(p -> {
                p.setProjectId(municipalMajorProjectManagement.getId());
                p.setDistributionType(0);
            });
            pilotSpecificMeasuresManager.saveOrUpdateBatch(pilotSpecificMeasuresList);

        }
        //  3.月度计划
        List<PilotSpecificSchedule> pilotSpecificScheduleList = municipalMajorProjectManagement.getPilotSpecificScheduleList();
        if(null != pilotSpecificScheduleList && pilotSpecificScheduleList.size() > 0){
            pilotSpecificScheduleList.stream().forEach(p -> {
                p.setProjectId(municipalMajorProjectManagement.getId());
                p.setPlanStatus(1);
                //根据所填月份获取季度
                if (p.getPlanMonth()!=null) p.setPlanQuarter((p.getPlanMonth()+2)/3);
                //更新推进表月度计划类型
                pilotMeasuresPushManager.update(new UpdateWrapper<PilotMeasuresPush>().set("PLAN_TYPE_",p.getPlanType()).eq("PLAN_ID_",p.getId()));
            });
            pilotSpecificScheduleManager.saveOrUpdateBatch(pilotSpecificScheduleList);

        }
        return b;
    }

    @Override
    public PageList<MunicipalMajorProjectManagement> queryIterationProject(QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        // 1. 分页查询主表数据
        PageList<MunicipalMajorProjectManagement> queryPageList = super.query(queryFilter);
        List<MunicipalMajorProjectManagement> rows = queryPageList.getRows();
        // 2.查询子表户数
        if(null != rows && rows.size() > 0){
            // 查询子表信息
            for (MunicipalMajorProjectManagement municipalMajorProjectManagement : rows){
                // 量化目标，针对举措的，所以就不查询了
//                municipalMajorProjectManagement.setPilotQuantitativeObjectivesList(pilotQuantitativeObjectivesManager
//                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
                // 具体举措，查询待审核的
                municipalMajorProjectManagement.setPilotSpecificMeasuresList(pilotSpecificMeasuresManager
                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
                // 进度计划，针对举措的，所以就不查询了
//                municipalMajorProjectManagement.setPilotSpecificScheduleList(pilotSpecificScheduleManager
//                        .queryListByProjectId(municipalMajorProjectManagement.getId()));
            }
        }
        return queryPageList;
    }

    @Override
    @Transactional
    public void pushSave(PushCommitVo pushCommitVo) {
        Assert.notNull(pushCommitVo, "提交数据不能为空！");
        pilotQuantitativeObjectivesPushManager.objectivesPushSave(pushCommitVo.getPilotQuantitativeObjectivesPushList());
        pilotSpecificSchedulePushManager.schedulePushSave(pushCommitVo.getPilotSpecificSchedulePushList());
    }

    @Override
    @Transactional
    public void pushSaveAndCommit(PushCommitVo pushCommitVo) {
        Assert.notNull(pushCommitVo, "提交数据不能为空！");
        pilotQuantitativeObjectivesPushManager.objectivesPushSaveSaveAndCommit(pushCommitVo.getPilotQuantitativeObjectivesPushList());
        pilotSpecificSchedulePushManager.schedulePushSaveSaveAndCommit(pushCommitVo.getPilotSpecificSchedulePushList());
    }

    @Override
    @Transactional
    public void pushExamine(PushExamineVo pushExamineVo) {
        Assert.notNull(pushExamineVo, "提交数据不能为空！");
        ObjectivesPushExamine objectivesPushExamine = new ObjectivesPushExamine();
        objectivesPushExamine.setIds(pushExamineVo.getQuantitativeObjectivesPushIds());
        objectivesPushExamine.setStatus(pushExamineVo.getStatus());
        pilotQuantitativeObjectivesPushManager.objectivesPushExamine(objectivesPushExamine);

        objectivesPushExamine.setIds(pushExamineVo.getSpecificSchedulePushIds());
        pilotSpecificSchedulePushManager.schedulePushExamine(objectivesPushExamine);
    }

    public void createLog(String id, Integer status,Integer approvalResults,String approvalComments,String title) {
        List<Integer> statusList = Arrays.asList(0,1, 3, 5);
        // 审批日志
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("hy_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(2);
        logVo.setBizType("6-0");
        logVo.setModuleTableName("BIZ_MUNICIPAL_MAJOR_PROJECT_MANAGEMENT");

        // 字典数据 shzt
        logVo.setStatus(String.valueOf(status));
        logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, status));

        if (com.artfess.base.util.BeanUtils.isNotEmpty(approvalResults)&&approvalResults==2){
            if (status==0){
                logVo.setItemTitle("市级重大项目【"+title +"】撤回为草稿" );
                logVo.setOperateInfo("撤回为草稿");
            }else if (status==1){
                logVo.setItemTitle("市级重大项目【"+title +"】撤回为提交待审核" );
                logVo.setOperateInfo("撤回为提交待审核");
            }else if (status==3){
                logVo.setItemTitle("市级重大项目【"+title +"】撤回为审核通过" );
                logVo.setOperateInfo("撤回为审核通过");
            }
            logVo.setApprovalResults(2);
        }else {
            if (null != status && statusList.contains(status)) {
                logVo.setApprovalResults(0);
            } else {
                logVo.setApprovalResults(1);
            }
            logVo.setItemTitle("市级重大项目【"+title +"】" + BizUtils.getDicValueByCode(shzt, status));
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, status));
        }

        if(null != status && status == 5){
            logVo.setFinish(true);
        }else {
            logVo.setFinish(false);
        }
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setApprovalComments(approvalComments);
        logVo.setModeType(0);
        logVo.setPriority(0);
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}
