package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.majorProjects.manager.BizMunicipalNotStartProjectManagementManager;
import com.artfess.reform.majorProjects.manager.BizPilotNotStartProjectFillManager;
import com.artfess.reform.majorProjects.model.BizMunicipalNotStartProjectManagement;
import com.artfess.reform.majorProjects.model.BizPilotNotStartMeasuresPush;
import com.artfess.reform.majorProjects.dao.BizPilotNotStartMeasuresPushDao;
import com.artfess.reform.majorProjects.manager.BizPilotNotStartMeasuresPushManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.model.BizPilotNotStartProjectFill;
import com.artfess.reform.majorProjects.vo.FillPushExamineVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目具体举措计划（月度计划）推进情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-10-17
 */
@Service
public class BizPilotNotStartMeasuresPushManagerImpl extends BaseManagerImpl<BizPilotNotStartMeasuresPushDao, BizPilotNotStartMeasuresPush> implements BizPilotNotStartMeasuresPushManager {

    @Resource
    BizMunicipalNotStartProjectManagementManager bizMunicipalNotSatrtProjectManagementManager;
    @Resource
    BizPilotNotStartProjectFillManager bizPilotNotStartProjectFillManager;
    @Resource
    FileManager fileManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;

    @Override
    @Transactional
    public boolean saveOrUpdateDate(BizPilotNotStartProjectFill fill) {
        Assert.notNull(fill.getProjectId(),"项目id不能为空");
        List<BizPilotNotStartMeasuresPush> pushList = fill.getPilotNotStartMeasuresPushList();
        Assert.isTrue(BeanUtils.isNotEmpty(pushList),"需录入的月度战况不能为空");
        boolean chick=true;
        String id = fill.getId();
        if (BeanUtils.isNotEmpty(id)){
            BizPilotNotStartProjectFill firstFill = bizPilotNotStartProjectFillManager.getById(id);
            chick=BeanUtils.isEmpty(firstFill.getStatus())||(BeanUtils.isNotEmpty(firstFill.getStatus())&&firstFill.getStatus()!=fill.getStatus());
        }
        //创建审批记录
        if (BeanUtils.isEmpty(fill.getFillDate())){
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int year = calendar.get(Calendar.YEAR);
            int month = calendar.get(Calendar.MONTH) + 1;
            int quarter=(month+2)/3;
            fill.setFillDate(new Date());
            fill.setFillYear(year);
            fill.setFillMonth(month);
            fill.setFillQuarter(quarter);
        }
        boolean res = bizPilotNotStartProjectFillManager.saveOrUpdate(fill);
        //记录审批流程
        if (chick)setApprovalLog(fill);

        //录入月度战况
        pushList.stream().forEach(p->{
            if (BeanUtils.isEmpty(id)){
                p.setId(null);
            }
            p.setFillId(fill.getId());
            p.setProjectId(fill.getProjectId());
            if (BeanUtils.isNotEmpty(p.getPlanMonth()))p.setPlanQuarter((p.getPlanMonth()+2)/3);
            super.saveOrUpdate(p);
            //更新附件
            if (BeanUtils.isNotEmpty(p.getFiles())) {
                //复制历史更新附件
                if (BeanUtils.isEmpty(id)){
                    List<DefaultFile> files = p.getFiles();
                    for (DefaultFile file : files) {
                        //将之前数据重新复制一份
                        if (BeanUtils.isNotEmpty(file.getBizId())){
                            file.setId(null);
                            fileManager.save(file);
                        }
                    }
                }
                List<String> fileIds = p.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                fileManager.updateFileBizIdByIds(fileIds,p.getId());
            }
        });



        return res;
    }

    @Override
    @Transactional
    public List<BizPilotNotStartProjectFill> findById(String projectId) {
        QueryWrapper<BizPilotNotStartProjectFill> fillWrapper=new QueryWrapper<>();
        fillWrapper.eq("PROJECT_ID_",projectId);
        fillWrapper.orderByDesc("CREATE_TIME_");
        fillWrapper.last("LIMIT 2");
        List<BizPilotNotStartProjectFill> fillList = bizPilotNotStartProjectFillManager.list(fillWrapper);
        if (BeanUtils.isNotEmpty(fillList)){
            fillList.stream().forEach(p->{
                //查询驳回记录
                if (p.getStatus()==2){
                    AchieveStatusLog logCom = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                            .eq("BIZ_ID_",p.getId())
                            .eq("STATUS_",2)
                            .orderByDesc("OPERATE_DATE_")
                            .last("LIMIT 1"));
                    if (BeanUtils.isNotEmpty(logCom)){
                        p.setApprovalComments(logCom.getApprovalComments());
                    }
                }
                //查询推进信息
                QueryWrapper<BizPilotNotStartMeasuresPush> pushWrapper=new QueryWrapper<>();
                pushWrapper.eq("FILL_ID_",p.getId());
                List<BizPilotNotStartMeasuresPush> pushList = super.list(pushWrapper);
                if (BeanUtils.isNotEmpty(pushList)){
                    p.setPilotNotStartMeasuresPushList(pushList);
                    pushList.stream().forEach(t->{
                        List<DefaultFile> files = fileManager.queryFileByBizId(t.getId());
                        if (BeanUtils.isNotEmpty(files))t.setFiles(files);
                    });
                }
            });
        }
        return fillList;
    }

    @Override
    @Transactional
    public boolean updateById(FillPushExamineVo fillVo) {
       Assert.notNull(fillVo.getId(),"id不能为空");
       Assert.notNull(fillVo.getStatus(),"审核状态不能为空");
        boolean chick=true;
        String id = fillVo.getId();
        if (BeanUtils.isNotEmpty(id)){
            BizPilotNotStartProjectFill firstFill = bizPilotNotStartProjectFillManager.getById(id);
            chick=BeanUtils.isEmpty(firstFill.getStatus())||(BeanUtils.isNotEmpty(firstFill.getStatus())&&firstFill.getStatus()!=fillVo.getStatus());
        }
        UpdateWrapper<BizPilotNotStartProjectFill> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("STATUS_",fillVo.getStatus());
        updateWrapper.eq("ID_",fillVo.getId());
        boolean res = bizPilotNotStartProjectFillManager.update(updateWrapper);
        if (chick){
            BizPilotNotStartProjectFill fill=new BizPilotNotStartProjectFill();
            fill.setId(fillVo.getId());
            fill.setStatus(fillVo.getStatus());
            fill.setProjectId(fillVo.getProjectId());
            fill.setApprovalResults(fillVo.getApprovalResults());
            fill.setApprovalComments(fillVo.getApprovalComments());
            setApprovalLog(fill);
        }
        return res;
    }

    @Transactional
    public void setApprovalLog(BizPilotNotStartProjectFill entity){
        // 审批日志
        BizMunicipalNotStartProjectManagement projectManagement = bizMunicipalNotSatrtProjectManagementManager.getOne(new QueryWrapper<BizMunicipalNotStartProjectManagement>()
                .eq("ID_", entity.getProjectId())
                .eq("IS_DELE_", "0")
                .last("LIMIT 1"));
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("lgyp_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(entity.getId());
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_PILOT_NOT_START_PROJECT_FILL");
        logVo.setApprovalResults(entity.getApprovalResults());
        if (BeanUtils.isEmpty(entity.getApprovalResults())){
            if (entity.getStatus()%2==0&&entity.getStatus()!=0){
                logVo.setApprovalResults(1);
            }else {
                logVo.setApprovalResults(0);
            }
            if (entity.getStatus()==0){
                logVo.setItemTitle("【"+projectManagement.getProjectName()+"】保存为草稿");
            } else if (entity.getStatus()==1){
                logVo.setItemTitle("【"+projectManagement.getProjectName()+"】提交改革办核准");
            }else if (entity.getStatus()==2){
                logVo.setItemTitle("【"+projectManagement.getProjectName()+"】改革办核准驳回");
            }else if (entity.getStatus()==3){
                logVo.setItemTitle("【"+projectManagement.getProjectName()+"】改革办核准通过");
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt,entity.getStatus()));
        }else if (entity.getApprovalResults()==2){
            if (entity.getStatus()==0){
                logVo.setItemTitle("【"+projectManagement.getProjectName()+"】撤回为草稿");
                logVo.setOperateInfo("撤回为草稿");
            } else if (entity.getStatus()==1){
                logVo.setItemTitle("【"+projectManagement.getProjectName()+"】撤回为提交改革办核准");
                logVo.setOperateInfo("撤回为提交改革办核准");
            }
        }
        logVo.setBizType("10");
        logVo.setStatus(entity.getStatus().toString());
        logVo.setApprovalComments(entity.getApprovalComments());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}
