package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.dao.PilotMeasuresPushDao;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotMeasuresPushVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目具体举措计划推进情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
@Service
public class BizPilotMeasuresPushManagerImpl extends BaseManagerImpl<PilotMeasuresPushDao, PilotMeasuresPush> implements PilotMeasuresPushManager {

    @Resource
    private PilotMeasuresPushDao pilotMeasuresPushDao;

    @Resource
    private FileManager fileManager;

    @Override
    public List<PilotMeasuresPushVo> queryListByFillId(String fillId,String projectId,String isHis) {
//        QueryWrapper<PilotMeasuresPush> queryWrapper = new QueryWrapper();
//        queryWrapper.eq("FILL_ID_", id).eq("IS_DELE_", 0);
//        List<PilotMeasuresPush> list = this.list(queryWrapper);
        List<PilotMeasuresPushVo> pilotMeasuresPushVoList = pilotMeasuresPushDao.queryListByFillId(fillId,projectId,isHis);
        if(null != pilotMeasuresPushVoList && pilotMeasuresPushVoList.size() > 0){
            for(PilotMeasuresPushVo p : pilotMeasuresPushVoList){
                p.setDefaultFileList(fileManager.queryFileByBizId(p.getId(), "ProjectPlanPush"));
            }
        }
        return pilotMeasuresPushVoList;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<PilotMeasuresPush> list) {
        boolean b = super.saveOrUpdateBatch(list);
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileList, p.getId(), "ProjectPlanPush");
                }
            });
        }
        return b;
    }

    @Override
    public boolean saveOrUpdate(PilotMeasuresPush entity) {

        List<DefaultFile> defaultFileList = entity.getDefaultFileList();
        List<String>  fileIdList=null;
        if (defaultFileList!=null&&defaultFileList.size()>0)  {
            fileIdList = defaultFileList.stream().map(p -> p.getId()).collect(Collectors.toList());
        }
        //当再次更新时,生成新的附件
        if (BeanUtils.isEmpty(entity.getId())&&BeanUtils.isNotEmpty(defaultFileList)){
            List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().in("ID_",fileIdList));
            for (DefaultFile file : files) {
                //将之前数据重新复制一份
                if (BeanUtils.isNotEmpty(file.getBizId())){
                    file.setId(null);
                    fileManager.save(file);
                }
            }
        }
        boolean b = super.saveOrUpdate(entity);
        // 保存文件
        if(null != defaultFileList && defaultFileList.size() > 0){
            // 修改附件bizId
            fileManager.updateFileBizIdByIds(fileIdList, entity.getId(), "ProjectPlanPush");
        }
//        boolean b = super.saveOrUpdate(entity);
//        List<DefaultFile> defaultFileList = entity.getDefaultFileList();
//        if(null != defaultFileList && defaultFileList.size() > 0){
//            List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
//            // 修改附件bizId
//            fileManager.updateFileBizIdByIds(fileList, entity.getId(), "ProjectPlanPush");
//        }
        return b;
    }

    @Override
    public boolean save(PilotMeasuresPush entity) {
        boolean b = super.save(entity);
        List<DefaultFile> defaultFileList = entity.getDefaultFileList();
        if(null != defaultFileList && defaultFileList.size() > 0){
            List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
            // 修改附件bizId
            fileManager.updateFileBizIdByIds(fileList, entity.getId(), "ProjectPlanPush");
        }
        return b;
    }

    @Override
    public boolean saveBatch(Collection<PilotMeasuresPush> list) {
        boolean b = super.saveBatch(list);
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileList, p.getId(), "ProjectPlanPush");
                }
            });
        }
        return b;
    }

    @Override
    public void updateStatusByProjectFill(PilotProjectFill pilotProjectFill) {
        if(null == pilotProjectFill || StringUtils.isBlank(pilotProjectFill.getId())){
            return;
        }
        String fillId = pilotProjectFill.getId();
        Integer status = pilotProjectFill.getStatus();
        QueryWrapper<PilotMeasuresPush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("FILL_ID_", fillId).eq("IS_DELE_", 0);
        List<PilotMeasuresPush> list = this.list(queryWrapper);
        if(null != list && list.size() > 0){
            List<String> ids = new ArrayList<>();
            for (PilotMeasuresPush p : list){
//                if(p.getStatus() == null || p.getStatus() < 5){
//                    ids.add(p.getId());
//                }
                // 未完成的并且是审核中的数据才修改状态
                if(!(p.getStatus() != null && "1".equalsIgnoreCase(p.getIsOver()) && p.getStatus() == 5)){
                    ids.add(p.getId());
                }
            }
            if(null != ids && ids.size() > 0){
                UpdateWrapper<PilotMeasuresPush> updateWrapper = new UpdateWrapper<>();
                updateWrapper.set("STATUS_", status);
                updateWrapper.in("ID_", ids);
                this.update(updateWrapper);
            }
        }

    }

    @Override
    public PageList<PilotMeasuresPushVo> queryList(QueryFilter<PilotMeasuresPush> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<PilotMeasuresPushVo> result = this.baseMapper.queryList(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));

        if(null != result.getRecords() && result.getRecords().size() > 0){
            for(PilotMeasuresPushVo p : result.getRecords()){
                p.setDefaultFileList(fileManager.queryFileByBizId(p.getId(), "ProjectPlanPush"));
            }
        }
        return new PageList<>(result);
    }

    @Override
    public PageList<PilotMeasuresPush> achievementInfo(QueryFilter<PilotMeasuresPush> queryFilter) {
        IPage<PilotMeasuresPush> iPage = this.baseMapper.achievementInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public PilotMeasuresPush achievementFindById(String id) {
        Assert.notNull(id,"项目id不能为空");
        PilotMeasuresPush entity = pilotMeasuresPushDao.selectById(id);
        List<DefaultFile> files = fileManager.queryFileByBizId(id);
        if (files !=null&&files.size()>0) entity.setDefaultFileList(files);
        return entity;
    }

    @Override
    public int countPilotMeasuresPushPush(String id) {
        Assert.notNull(id, "计划ID不能为空");
        QueryWrapper<PilotMeasuresPush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("PLAN_ID_", id).gt("status_",0).eq("IS_DELE_", 0);
        return this.count(queryWrapper);
    }
}
