package com.artfess.reform.majorProjects.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedulePush;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.vo.*;

import java.util.List;

/**
 * j进度计划推进情况 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotSpecificSchedulePushManager extends BaseManager<PilotSpecificSchedulePush> {


    /**
     * 批量保存数据，包括附件
     * @param pilotSpecificSchedulePushList
     */
    void saveBatch(List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList);

    /**
     * 根据ID查询详情，包括附件
     * @param id
     * @return
     */
    PilotSpecificSchedulePush getById(String id);


    /**
     * 根据进度计划ID查询推进情况集合，包括附件
     * @param objectivesMeasuresId
     * @return
     */
    List<PilotSpecificSchedulePush> queryListByObjectivesMeasuresId(String objectivesMeasuresId);

    /**
     * 计划推进情况审核保存接口
     * @param pilotSpecificSchedulePush
     */
    void schedulePushSave(List<PilotSpecificSchedulePush> pilotSpecificSchedulePush);

    /**
     *计划推进情况保存并提交审核接口
     * @param pilotSpecificSchedulePush
     */
    void schedulePushSaveSaveAndCommit(List<PilotSpecificSchedulePush> pilotSpecificSchedulePush);

    /**
     * 计划推进情况审核接口
     * @param schedulePushExamine
     */
    void schedulePushExamine(ObjectivesPushExamine schedulePushExamine);

    /**
     * 分页查询计划推进情况审核列表分页查询
     * @param queryFilter
     * @return
     */
    PageList<SchedulePushExamineAndProjectVo> schedulePushListByPage(QueryFilter<PilotSpecificSchedulePush> queryFilter);

    /**
     * 分页查询计划推进情况审核列表分页查询
     * @param queryFilter
     * @return
     */
    PageList<QuantitativeObjectivesPushFillQueryVo> scheduleAndMeasurePushListByPage(QueryFilter<PilotProjectFill> queryFilter);


    /**
     * 根据填报ID查询推进信息
     * @param id 填报ID
     * @return
     */
    List<PilotSpecificSchedulePush> queryListByFillId(String id);

    /**
     * 填报数据领导审核接口
     * @param fillPushExamineVo
     */
    void pilotSpecificSchedulePushAndMeasurePushExamine(FillPushExamineVo fillPushExamineVo);

    /**
     * 进度计划推进情况及改革成果审核提交接口
     * @param pilotSpecificSchedulePushAndMeasurePushVo
     */
    void pilotSpecificSchedulePushAndMeasurePushSaveCommit(PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo);

    /**
     * 进度计划推进情况及改革成果审核保存接口
     * @param pilotSpecificSchedulePushAndMeasurePushVo
     */
    void pilotSpecificSchedulePushAndMeasurePushSave(PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo);

    /**
     * 进度计划推进情况及改革成果修改审核接口
     * @param pilotSpecificSchedulePushAndMeasurePushVo
     */
    void pilotSpecificSchedulePushAndMeasurePushUpdate(PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo);
    /**
     * 根据填报ID查询审核详情信息
     * @param id
     * @return
     */
    PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo getDetails(String id);

    /**
     * 根据填报ID查询审核详情信息
     * @param projectId
     * @return
     */
    PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo getHisDetails(String projectId);

    /**
     * 根据填报ID上报数据
     * @param id
     */
    void pilotSpecificSchedulePushCommit(String id);

    /**
     * 根据ID统计是否存在推进记录数据
     * @param id
     * @return
     */
    int countPilotSpecificSchedulePush(String id);

    /**
     * 根据填报信息修改计划状态
     * @param pilotProjectFill
     */
    void updateStatusByProjectFill(PilotProjectFill pilotProjectFill);
}
