package com.artfess.reform.majorProjects.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.vo.*;

import java.time.LocalDate;
import java.util.List;

/**
 * 改革方案量化目标j进度计划推进情况 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotQuantitativeObjectivesPushManager extends BaseManager<PilotQuantitativeObjectivesPush> {

    /**
     * 目标推进情况保存接口
     * @param pilotQuantitativeObjectivesPushList
     */
    void objectivesPushSave(List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList);

    /**
     * 目标推进接口保存并提交审核接口
     * @param pilotQuantitativeObjectivesPushList
     */
    void objectivesPushSaveSaveAndCommit(List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList);

    /**
     * 目标推进进度审核接口
     * @param objectivesPushExamine
     */
    void objectivesPushExamine(ObjectivesPushExamine objectivesPushExamine);

    /**
     * 分页查询目标推进情况审核列表数据，包含项目信息，目标信息
     * @param queryFilter
     * @return
     */
    PageList<ObjectivesPushExamineAndProjectVo> objectivesPushListByPage(QueryFilter<PilotQuantitativeObjectivesPush> queryFilter);

    /**
     * 根据填报ID查询推进信息
     * @param id 填报ID
     * @param projectId 项目ＩＤ
     * @param isHis 是否历史数据查询（true：是，false：不是）
     * @return
     */
    List<PilotQuantitativeObjectivesPushVo> queryListByFillId(String id,String projectId,String isHis);

    /**
     * 根据填报年度查询所有项目的量化目标清单以及完成情况
     * @param fillYear 填报年
     * @param fillMonth 填报月
     * @return
     */
    List<PilotQuantitativeTargetListVo> queryTargetListByFillYearMonth(Integer fillYear, Integer fillMonth);

    /**
     * 根据填报年度查询所有项目的月度计划清单以及完成情况
     * @param fillYear 填报年
     * @param fillMonth 填报月
     * @return
     */
    List<PilotQuantitativeMonthPlanVo> queryMonthPlanListByFillYearMonth(Integer fillYear, Integer fillMonth);

    /**
     * 目标推进情况审核保存接口
     * @param quantitativeObjectivesPushVo
     */
    void quantitativeObjectivesPushSave(QuantitativeObjectivesPushVo quantitativeObjectivesPushVo);

    /**
     * 目标推进情况审核提交接口
     * @param quantitativeObjectivesPushVo
     */
    void quantitativeObjectivesPushSaveSaveAndCommit(QuantitativeObjectivesPushVo quantitativeObjectivesPushVo);

    /**
     * 领导审核数据接口
     * @param fillPushExamineVo
     */
    void quantitativeObjectivesPushExamine(FillPushExamineVo fillPushExamineVo);

    /**
     *
     * @param queryFilter
     * @return
     */
    PageList<QuantitativeObjectivesPushFillQueryVo> quantitativeObjectivesPushListByPage(QueryFilter<PilotProjectFill> queryFilter);

    /**
     * 根据审核填报ID查询推进详情
     * @param id
     * @return
     */
    QuantitativeObjectivesPushFillQueryDetailVo getDetails(String id);

    /**
     * 用户根据ID上报数据
     * @param id
     * @return
     */
    void quantitativeObjectivesPushCommit(String id);

    /**
     *
     * @param id
     * @return
     */
    int countQuantitativeObjectivesPush(String id);

    /**
     * 根据项目ID和填报时间查询历史填报记录，填报时间如果为空则默认为当前时间
     * @param projectId
     * @param fillDate
     * @return
     */
    QuantitativeObjectivesPushFillQueryDetailVo getHistoryDetails(String projectId, LocalDate fillDate);
}
