package com.artfess.reform.majorProjects.manager;

import com.artfess.reform.majorProjects.model.PilotObjectivesDetails;
import com.artfess.base.manager.BaseManager;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 改革方案明确的量化目标的计划值 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */
public interface PilotObjectivesDetailsManager extends BaseManager<PilotObjectivesDetails> {


    /**
     * 根据年度和目标ID获取计划详情
     * @param year 年度
     * @param objectivesMeasuresId 目标ID
     * @return
     */
    PilotObjectivesDetails getDetailsByYearAndObjectivesMeasuresId(Integer year, String objectivesMeasuresId);

    /**
     * 根据年度和目标ID获取年度目标值
     * @param pushYear 年度
     * @param objectivesMeasuresId 目标ID
     * @return
     */
    public BigDecimal getYearValue(Integer pushYear, String objectivesMeasuresId);

    /**
     * 根据年度和月度，目标ID获取月度目标值
     * @param pushYear 年度
     * @param pushMonth 月度
     * @param objectivesMeasuresId 目标ID
     * @return
     */
    public BigDecimal getMonthValue(Integer pushYear, Integer pushMonth,String objectivesMeasuresId);
}
