package com.artfess.reform.majorProjects.dao;

import com.artfess.reform.majorProjects.model.PilotSpecificSchedulePush;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeMonthPlanVo;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeTargetListVo;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeObjectivesPushVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 月度计划推进情况 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotSpecificSchedulePushDao extends BaseMapper<PilotSpecificSchedulePush> {

    /**
     * 根据填报ID查询详情
     * @param fileId
     * @return
     */
    List<PilotQuantitativeObjectivesPushVo> queryListByFillId(@Param("fileId") String  fileId,@Param("projectId") String  projectId,@Param("isHis") String  isHis);

    /**
     * 根据填报年度查询所有项目的量化目标清单以及完成情况
     * @param fillYear  填报年
     * @param fillMonth  填报月
     * @param monthValueFieldName 填报月的字段名称
     * @return
     */
    List<PilotQuantitativeTargetListVo> queryTargetListByFillYearMonth(@Param("fillYear") Integer  fillYear, @Param("fillMonth") Integer  fillMonth, @Param("monthValueFieldName") String monthValueFieldName);

    /**
     * 根据填报年度查询所有项目的月度计划清单以及完成情况
     * @param fillYear  填报年
     * @param fillMonth 填报月
     * @return
     */
    List<PilotQuantitativeMonthPlanVo> queryMonthPlanListByFillYearMonth(@Param("fillYear") Integer  fillYear, @Param("fillMonth") Integer  fillMonth);
}
