package com.artfess.reform.majorProjects.dao;


import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;



/**
 * 市级重大改革项目填报审核记录 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
public interface PilotProjectFillDao extends BaseMapper<PilotProjectFill> {

    IPage<PilotProjectFill> queryList(IPage<PilotProjectFill> convert2IPage,@Param(Constants.WRAPPER) Wrapper<PilotProjectFill> convert2Wrapper);

    /**
     * @Description: 根据流程类型分页查询项目最新的流程填报情况
     * @param flowType 流程类型（1：量化目标审核流程2：月度计划审核流程，3：经验推广流程，4：品牌显示度流程）
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<PilotProjectFill> queryPageFillList(IPage<PilotProjectFill> convert2iPage, @Param(Constants.WRAPPER) Wrapper<PilotProjectFill> convert2Wrapper,@Param("flowType") Integer flowType);

    /**
     * @Description: 专项小组查询重大项目
     * @param flowType 流程类型（1：量化目标审核流程2：月度计划审核流程，3：经验推广流程，4：品牌显示度流程）
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<PilotProjectFill> queryPageFillGroup(IPage<PilotProjectFill> convert2iPage, @Param(Constants.WRAPPER) Wrapper<PilotProjectFill> convert2Wrapper,@Param("flowType") Integer flowType,@Param("code") String code);

}
