package com.artfess.reform.majorProjects.dao;

import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目经验推广总结情况 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
public interface PilotExperiencePushDao extends BaseMapper<PilotExperiencePush> {

    /**
     * 经验推广数据查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<PilotExperiencePush> queryByPage(IPage<PilotExperiencePush> convert2IPage,
                                           @Param(Constants.WRAPPER) Wrapper<PilotExperiencePush> convert2Wrapper);

    List<PilotExperiencePush> pilotExperiencePushInfo(@Param("projectId")String projectId, @Param("year")Integer year, @Param("month")Integer month);


}
