package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedulePush;
import com.artfess.reform.majorProjects.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.manager.PilotSpecificSchedulePushManager;

import javax.annotation.Resource;
import java.util.List;

/**
 * 进度计划推进情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/majorProjects/pilotSpecificSchedulePush/v1/")
@Api(tags = "市级重大改革项目管理-进度计划推进情况")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotSpecificSchedulePushController extends BaseController<PilotSpecificSchedulePushManager, PilotSpecificSchedulePush> {

    @Resource
    private PilotSpecificSchedulePushManager pilotSpecificSchedulePushManager;

    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除数据")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        pilotSpecificSchedulePushManager.removeById(id);
        return CommonResult.success(id, "数据删除成功！");
    }

    @DeleteMapping("/removeByIds")
    @ApiOperation("根据id批量删除数据")
    public CommonResult<String> deleteById(@ApiParam(name="ids", value="实体id") @PathVariable List<String> ids) {
        pilotSpecificSchedulePushManager.removeByIds(ids);
        return CommonResult.success(ids, "数据删除成功！");
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加数据接口")
    public CommonResult<String> create(@RequestBody PilotSpecificSchedulePush pilotSpecificSchedulePush) {
        pilotSpecificSchedulePushManager.create(pilotSpecificSchedulePush);
        return CommonResult.success(pilotSpecificSchedulePush.getId(), "数据保存成功！");

    }

    @PostMapping("/saveBatch")
    @ApiOperation("批量添加数据")
    public CommonResult<String> create(@RequestBody List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList) {
        pilotSpecificSchedulePushManager.saveBatch(pilotSpecificSchedulePushList);
        return CommonResult.success(pilotSpecificSchedulePushList, "数据保存成功！");

    }

    @PostMapping("/list")
    @ApiOperation("分页查询数据")
    public PageList<PilotSpecificSchedulePush> list(@RequestBody QueryFilter<PilotSpecificSchedulePush> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        return pilotSpecificSchedulePushManager.query(queryFilter);
    }

    @PostMapping(value="/queryNoPage", produces={"application/json; charset=utf-8" })
    @ApiOperation("不分页查询")
    public List<PilotSpecificSchedulePush> queryNoPage(@RequestBody QueryFilter<PilotSpecificSchedulePush> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        return pilotSpecificSchedulePushManager.queryNoPage(queryFilter);
    }

    /**
     * 审批填报初始化计划目标情况
     * @param pilotProjectFill
     * @return
     */
    @PostMapping("/examineInit")
    @ApiOperation("审批填报初始化-根据项目projectId初始化审批填报计划目标情况")
    public MunicipalMajorProjectManagement getExamineById(@RequestBody PilotProjectFill pilotProjectFill) {
        return municipalMajorProjectManagementManager.getPilotMeasuresVoAndPilotSpecificSchedulePushById(pilotProjectFill);
    }


    @PutMapping("/pilotSpecificSchedulePushAndMeasurePushSave")
    @ApiOperation("进度计划推进情况及改革成果审核保存接口")
    public CommonResult<String> pilotSpecificSchedulePushAndMeasurePushSave(@RequestBody PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo) {
        pilotSpecificSchedulePushManager.pilotSpecificSchedulePushAndMeasurePushSave(pilotSpecificSchedulePushAndMeasurePushVo);
        return CommonResult.success(pilotSpecificSchedulePushAndMeasurePushVo, "数据保存成功！");
    }


    @PutMapping("/pilotSpecificSchedulePushAndMeasurePushSaveCommit")
    @ApiOperation("进度计划推进情况及改革成果审核提交接口")
    public CommonResult<String> pilotSpecificSchedulePushAndMeasurePushSaveCommit(@RequestBody PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo) {
        pilotSpecificSchedulePushManager.pilotSpecificSchedulePushAndMeasurePushSaveCommit(pilotSpecificSchedulePushAndMeasurePushVo);
        return CommonResult.success(pilotSpecificSchedulePushAndMeasurePushVo, "数据提交成功！");
    }

    @PutMapping("/pilotSpecificSchedulePushAndMeasurePushUpdate")
    @ApiOperation("修改推进信息和审核状态接口")
    public CommonResult<String> pilotSpecificSchedulePushAndMeasurePushUpdate(@RequestBody PilotSpecificSchedulePushAndMeasurePushVo pilotSpecificSchedulePushAndMeasurePushVo) {
        pilotSpecificSchedulePushManager.pilotSpecificSchedulePushAndMeasurePushUpdate(pilotSpecificSchedulePushAndMeasurePushVo);
        return CommonResult.success(pilotSpecificSchedulePushAndMeasurePushVo, "数据修改成功！");
    }

    @PostMapping("/pilotSpecificSchedulePushAndMeasurePushExamine")
    @ApiOperation("进度计划推进情况及改革成果部门审核接口")
    public CommonResult<String> pilotSpecificSchedulePushAndMeasurePushExamine(@RequestBody FillPushExamineVo fillPushExamineVo) {
        fillPushExamineVo.setTitle("市级重大项目月度计划推进");
        pilotSpecificSchedulePushManager.pilotSpecificSchedulePushAndMeasurePushExamine(fillPushExamineVo);
        return CommonResult.success(fillPushExamineVo, "数据审核成功！");
    }

    /**
     * 根据ID上报数据详情
     * @param id
     * @return
     */
    @GetMapping("/pilotSpecificSchedulePushCommit")
    @ApiOperation("审核-根据ID上报数据")
    public  CommonResult<String> pilotSpecificSchedulePushCommit(@ApiParam(name = "id", value = "填报审核记录ID") @RequestParam(value = "id",required = true) String id) {
        pilotSpecificSchedulePushManager.pilotSpecificSchedulePushCommit(id);
        return CommonResult.success(id, "数据上报成功！");
    }


    /**
     * 审批历史数据查询详情
     * @return
     */
    @GetMapping("/getHisDetails")
    @ApiOperation("审核-根据项目ID查询历史数据详情")
    public PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo getHisDetails(@ApiParam(name = "projectId", value = "填报项目ID") @RequestParam(value = "projectId",required = true) String projectId) {
        return pilotSpecificSchedulePushManager.getHisDetails(projectId);
    }

    /**
     * 审批数据查询详情
     * @param id
     * @return
     */
    @GetMapping("/getDetails")
    @ApiOperation("审核-根据ID查询审核数据详情")
    public PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo getDetails(@ApiParam(name = "id", value = "填报审核记录ID") @RequestParam(value = "id",required = true) String id) {
        return pilotSpecificSchedulePushManager.getDetails(id);
    }

    /**
     * 分页查询目标推进情况审核列表数据，包含项目信息，目标信息
     * @param queryFilter
     * @return
     */
//    @PostMapping("/schedulePushListByPage")
//    @ApiOperation("分页查询计划推进情况审核列表分页查询")
//    public PageList<SchedulePushExamineAndProjectVo> schedulePushListByPage(@RequestBody QueryFilter<PilotSpecificSchedulePush> queryFilter) {
//        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
//        PageList<SchedulePushExamineAndProjectVo> queryList= pilotSpecificSchedulePushManager.schedulePushListByPage(queryFilter);
//        return queryList;
//    }

    /**
     * 分页查询目标推进情况审核列表数据，包含项目信息，目标信息
     * @param queryFilter
     * @return
     */
    @PostMapping("/scheduleAndMeasurePushListByPage")
    @ApiOperation("进度计划推进情况及改革成果列表分页查询")
    public PageList<QuantitativeObjectivesPushFillQueryVo> scheduleAndMeasurePushListByPage(@RequestBody QueryFilter<PilotProjectFill> queryFilter) {
        PageList<QuantitativeObjectivesPushFillQueryVo> queryList= pilotSpecificSchedulePushManager.scheduleAndMeasurePushListByPage(queryFilter);
        return queryList;
    }
    
}
