package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificSchedulePushManager;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * 进度计划表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/majorProjects/pilotSpecificSchedule/v1/")
@Api(tags = "市级重大改革项目管理-改革方案进度计划")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotSpecificScheduleController extends BaseController<PilotSpecificScheduleManager, PilotSpecificSchedule> {


    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;

    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        // 验证删除
        int count = pilotMeasuresPushManager.countPilotMeasuresPushPush(id);
        if(count > 0){
            throw new BaseException("计划已经在推进中，不能删除该计划！");
        }
        baseService.removeById(id);
        pilotMeasuresPushManager.remove(new QueryWrapper<PilotMeasuresPush>().eq("PLAN_ID_",id));
        return CommonResult.success(id, "删除成功！");
    }

    @DeleteMapping("/ggbDeleteById/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> ggbDeleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        baseService.removeById(id);
        pilotMeasuresPushManager.remove(new QueryWrapper<PilotMeasuresPush>().eq("PLAN_ID_",id));
        return CommonResult.success(id, "删除成功！");
    }

    @RequestMapping(value = "scheduleExport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出月度推进计划列表", httpMethod = "POST", notes = "导出改革需求列表")
    public void scheduleExport(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter queryFilter,@RequestParam(required = false)Boolean isAffirm) throws Exception {
       baseService.exportExcel(response,queryFilter,isAffirm);
    }

}
