package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.reform.majorProjects.vo.IterationExamine;
import com.artfess.reform.majorProjects.vo.IterationExamineAndProjectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;

import javax.annotation.Resource;
import java.util.List;

/**
 * 改革方案明确的具体举措表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/majorProjects/pilotSpecificMeasures/v1/")
@Api(tags = "市级重大改革项目管理-改革方案明确的具体举措")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotSpecificMeasuresController extends BaseController<PilotSpecificMeasuresManager, PilotSpecificMeasures> {

    @Resource
    private PilotSpecificMeasuresManager pilotSpecificMeasuresManager;

//    @PutMapping("/iterationSave")
//    @ApiOperation("举措迭代审核[迭代举措]保存接口")
//    public CommonResult<String> iterationSave(@RequestBody List<PilotSpecificMeasures> pilotSpecificMeasuresList) {
//        pilotSpecificMeasuresManager.iterationSave(pilotSpecificMeasuresList);
//        return CommonResult.success(pilotSpecificMeasuresList, "数据保存成功！");
//    }

    @PutMapping("/iterationAddSave")
    @ApiOperation("举措迭代审核[新增举措]保存接口")
    public CommonResult<String> iterationAddSave(@RequestBody List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        pilotSpecificMeasuresManager.iterationAddSave(pilotSpecificMeasuresList);
        return CommonResult.success(pilotSpecificMeasuresList, "数据保存成功！");
    }


    @PutMapping("/iterationSaveAndCommit")
    @ApiOperation("举措迭代审核提交接口")
    public CommonResult<String> iterationSaveAndCommit(@RequestBody List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        pilotSpecificMeasuresManager.iterationSaveAndCommit(pilotSpecificMeasuresList);
        return CommonResult.success(pilotSpecificMeasuresList, "数据提交成功！");
    }

    @PostMapping("/iteration")
    @ApiOperation("举措迭代部门审核接口")
    public CommonResult<String> iteration(@RequestBody IterationExamine iteration) {
        pilotSpecificMeasuresManager.iterationCommit(iteration);
        return CommonResult.success(iteration, "数据提交成功！");
    }

    /**
     * 分页查询举措迭代审核列表数据，包含项目信息
     * @param queryFilter
     * @return
     */
    @PostMapping("/iterationListByPage")
    @ApiOperation("举措迭代审核列表分页查询")
    public PageList<IterationExamineAndProjectVo> iterationListByPage(@RequestBody QueryFilter<PilotSpecificMeasuresHistory> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        PageList<IterationExamineAndProjectVo> queryList= pilotSpecificMeasuresManager.iterationListByPage(queryFilter);
        return queryList;
    }


    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        // 删除验证，举措迭代的时候不能删除
        int count = pilotSpecificMeasuresManager.countPilotSpecificMeasuresByParentId(id);
        if(count > 0){
            throw new BaseException("举措已在迭代审核中，不能删除该举措！");
        }
         baseService.deleteMeasuresById(id);
        return CommonResult.success(id, "数据删除成功！");
    }


}
